/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;
import org.eclipse.ui.externaltools.internal.model.ImageDescriptorRegistry;

public class ExternalToolsImages {
    private static ImageRegistry imageRegistry;
    private static ImageDescriptorRegistry imageDescriptorRegistry;
    private static Map imageDescriptors;
    private static URL ICON_BASE_URL;
    private static final String LOCALTOOL = "clcl16/";
    private static final String OBJECT = "obj16/";
    private static final String WIZBAN = "wizban/";
    private static final String OVR = "ovr16/";

    static {
        ICON_BASE_URL = null;
        String pathSuffix = "icons/full/";
        try {
            ICON_BASE_URL = new URL(ExternalToolsPlugin.getDefault().getDescriptor().getInstallURL(), pathSuffix);
        }
        catch (MalformedURLException malformedURLException) {}
    }

    private static void declareImages() {
        ExternalToolsImages.declareRegistryImage("org.eclipse.ui.externaltools.property", "obj16/property_obj.gif");
        ExternalToolsImages.declareRegistryImage("org.eclipse.ui.externaltools.html_tab_obj", "obj16/task_obj.gif");
        ExternalToolsImages.declareRegistryImage("org.eclipse.ui.externaltools.ant_tsk_arrow", "obj16/ant_tsk_arrow.gif");
        ExternalToolsImages.declareRegistryImage("org.eclipse.ui.externaltools.remove", "clcl16/remove_co.gif");
        ExternalToolsImages.declareRegistryImage("org.eclipse.ui.externaltools.removeAll", "clcl16/removeAll_co.gif");
        ExternalToolsImages.declareRegistryImage("org.eclipse.ui.externaltools.add", "clcl16/add_co.gif");
        ExternalToolsImages.declareRegistryImage("org.eclipse.ui.externaltools.run", "clcl16/run_tool.gif");
        ExternalToolsImages.declareRegistryImage("org.eclipse.ui.externaltools.search", "clcl16/search.gif");
        ExternalToolsImages.declareRegistryImage("org.eclipse.ui.externaltools.moveUp", "clcl16/moveUp.gif");
        ExternalToolsImages.declareRegistryImage("org.eclipse.ui.externaltools.moveDown", "clcl16/moveDown.gif");
        ExternalToolsImages.declareRegistryImage("org.eclipse.ui.externaltools.activate", "clcl16/activate.gif");
        ExternalToolsImages.declareRegistryImage("org.eclipse.ui.externaltools.deactivate", "clcl16/deactivate.gif");
        ExternalToolsImages.declareRegistryImage("org.eclipse.ui.externaltools.goToFile", "clcl16/gotoobj_tsk.gif");
        ExternalToolsImages.declareRegistryImage("org.eclipse.ui.externaltools.toggle", "clcl16/toggle.gif");
        ExternalToolsImages.declareRegistryImage("org.eclipse.ui.externaltools.antProject", "obj16/ant_buildfile.gif");
        ExternalToolsImages.declareRegistryImage("org.eclipse.ui.externaltools.antProjectError", "obj16/ant_project_err.gif");
        ExternalToolsImages.declareRegistryImage("org.eclipse.ui.externaltools.antTarget", "obj16/targetpublic_obj.gif");
        ExternalToolsImages.declareRegistryImage("org.eclipse.ui.externaltools.antPrivateTarget", "obj16/targetprivate_obj.gif");
        ExternalToolsImages.declareRegistryImage("org.eclipse.ui.externaltools.antDefaultTarget", "obj16/defaulttarget_obj.gif");
        ExternalToolsImages.declareRegistryImage("org.eclipse.ui.externaltools.antTargetError", "obj16/ant_target_err.gif");
        ExternalToolsImages.declareRegistryImage("org.eclipse.ui.externaltools.antTargetElements", "obj16/elements.gif");
        ExternalToolsImages.declareRegistryImage("org.eclipse.ui.externaltools.antTargetElement", "obj16/element.gif");
        ExternalToolsImages.declareRegistryImage("org.eclipse.ui.externaltools.IMG_WIZBAN_EXTERNAL_TOOLS", "wizban/ext_tools_wiz.gif");
        ExternalToolsImages.declareRegistryImage("org.eclipse.ui.externaltools.IMG_ACTION_REFRESH", "clcl16/refresh.gif");
        ExternalToolsImages.declareRegistryImage("org.eclipse.ui.externaltools.IMG_TAB_MAIN", "obj16/main_tab.gif");
        ExternalToolsImages.declareRegistryImage("org.eclipse.ui.externaltools.IMG_TAB_OPTIONS", "obj16/options_tab.gif");
        ExternalToolsImages.declareRegistryImage("org.eclipse.ui.externaltools.IMG_PROPERTY", "obj16/prop_ps.gif");
        ExternalToolsImages.declareRegistryImage("org.eclipse.ui.externaltools.IMG_TAB_ANT_TARGETS", "clcl16/ant_targets.gif");
        ExternalToolsImages.declareRegistryImage("org.eclipse.ui.externaltools.ovrError", "ovr16/error_co.gif");
    }

    private static final void declareRegistryImage(String key, String path) {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        try {
            desc = ImageDescriptor.createFromURL((URL)ExternalToolsImages.makeIconFileURL(path));
        }
        catch (MalformedURLException malformedURLException) {}
        imageRegistry.put(key, desc);
        imageDescriptors.put(key, desc);
    }

    public static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            ExternalToolsImages.initializeImageRegistry();
        }
        return imageRegistry;
    }

    public static ImageRegistry initializeImageRegistry() {
        imageRegistry = new ImageRegistry(ExternalToolsPlugin.getStandardDisplay());
        imageDescriptors = new HashMap(30);
        ExternalToolsImages.declareImages();
        return imageRegistry;
    }

    public static Image getImage(String key) {
        return ExternalToolsImages.getImageRegistry().get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        if (imageDescriptors == null) {
            ExternalToolsImages.initializeImageRegistry();
        }
        return (ImageDescriptor)imageDescriptors.get(key);
    }

    private static URL makeIconFileURL(String iconPath) throws MalformedURLException {
        if (ICON_BASE_URL == null) {
            throw new MalformedURLException();
        }
        return new URL(ICON_BASE_URL, iconPath);
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        ExternalToolsImages.setImageDescriptors(action, "lcl16", iconName);
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        ImageDescriptor id;
        try {
            id = ImageDescriptor.createFromURL((URL)ExternalToolsImages.makeIconFileURL("d" + type, relPath));
            if (id != null) {
                action.setDisabledImageDescriptor(id);
            }
        }
        catch (MalformedURLException e) {
            ExternalToolsPlugin.getDefault().log(e);
        }
        try {
            id = ImageDescriptor.createFromURL((URL)ExternalToolsImages.makeIconFileURL("c" + type, relPath));
            if (id != null) {
                action.setHoverImageDescriptor(id);
            }
        }
        catch (MalformedURLException e) {
            ExternalToolsPlugin.getDefault().log(e);
        }
        action.setImageDescriptor(ExternalToolsImages.create("e" + type, relPath));
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (ICON_BASE_URL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(ICON_BASE_URL, buffer.toString());
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)ExternalToolsImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException e) {
            ExternalToolsPlugin.getDefault().log(e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public static Image getImage(CompositeImageDescriptor imageDescriptor) {
        if (imageDescriptorRegistry == null) {
            imageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return imageDescriptorRegistry.get((ImageDescriptor)imageDescriptor);
    }

    public static void disposeImageDescriptorRegistry() {
        if (imageDescriptorRegistry != null) {
            imageDescriptorRegistry.dispose();
        }
    }
}

