/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.model;

import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsUtil;
import org.eclipse.ui.externaltools.internal.model.VariableContextManager;

public final class ExternalToolBuilder
extends IncrementalProjectBuilder {
    public static final String ID = "org.eclipse.ui.externaltools.ExternalToolBuilder";
    private static final String BUILD_TYPE_SEPARATOR = ",";
    private static final int[] DEFAULT_BUILD_TYPES = new int[]{10, 6};

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        ILaunchConfiguration config = ExternalToolsUtil.configFromBuildCommandArgs(args);
        if (config == null) {
            return null;
        }
        boolean runTool = false;
        int[] buildKinds = ExternalToolBuilder.buildTypesToArray(config.getAttribute("org.eclipse.ui.externaltools.ATTR_RUN_BUILD_KINDS", ""));
        int i = 0;
        while (i < buildKinds.length) {
            if (kind == buildKinds[i]) {
                runTool = true;
                break;
            }
            ++i;
        }
        if (!runTool) {
            return null;
        }
        VariableContextManager.getDefault().buildStarted(this.getProject(), kind);
        config.launch("run", null);
        VariableContextManager.getDefault().buildEnded();
        this.forgetLastBuiltState();
        return null;
    }

    public static int[] buildTypesToArray(String buildTypes) {
        int count = 0;
        boolean incremental = false;
        boolean full = false;
        boolean auto = false;
        if (buildTypes == null || buildTypes.length() == 0) {
            return DEFAULT_BUILD_TYPES;
        }
        StringTokenizer tokenizer = new StringTokenizer(buildTypes, BUILD_TYPE_SEPARATOR);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if ("incremental".equals(token)) {
                if (incremental) continue;
                incremental = true;
                ++count;
                continue;
            }
            if ("full".equals(token)) {
                if (full) continue;
                full = true;
                ++count;
                continue;
            }
            if (!"auto".equals(token) || auto) continue;
            auto = true;
            ++count;
        }
        int[] results = new int[count];
        count = 0;
        if (incremental) {
            results[count] = 10;
            ++count;
        }
        if (full) {
            results[count] = 6;
            ++count;
        }
        if (auto) {
            results[count] = 9;
            ++count;
        }
        return results;
    }
}

