/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.model;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsImages;

public class AntImageDescriptor
extends CompositeImageDescriptor {
    public static final int DEFAULT_TARGET = 1;
    public static final int HAS_ERRORS = 2;
    private ImageDescriptor fBaseImage;
    private int fFlags;
    private Point fSize;

    public AntImageDescriptor(ImageDescriptor baseImage, int flags) {
        this.setBaseImage(baseImage);
        this.setFlags(flags);
    }

    protected Point getSize() {
        if (this.fSize == null) {
            ImageData data = this.getBaseImage().getImageData();
            this.setSize(new Point(data.width, data.height));
        }
        return this.fSize;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AntImageDescriptor)) {
            return false;
        }
        AntImageDescriptor other = (AntImageDescriptor)((Object)object);
        return this.getBaseImage().equals(other.getBaseImage()) && this.getFlags() == other.getFlags();
    }

    public int hashCode() {
        return this.getBaseImage().hashCode() | this.getFlags();
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.getBaseImage().getImageData();
        if (bg == null) {
            bg = ImageDescriptor.DEFAULT_IMAGE_DATA;
        }
        this.drawImage(bg, 0, 0);
        this.drawOverlays();
    }

    protected void drawOverlays() {
        int flags = this.getFlags();
        int x = 0;
        int y = 0;
        ImageData data = null;
        if ((flags & 2) != 0) {
            x = this.getSize().x;
            y = 0;
            data = ExternalToolsImages.getImageDescriptor("org.eclipse.ui.externaltools.ovrError").getImageData();
            this.drawImage(data, x -= data.width, y);
        }
    }

    protected ImageDescriptor getBaseImage() {
        return this.fBaseImage;
    }

    protected void setBaseImage(ImageDescriptor baseImage) {
        this.fBaseImage = baseImage;
    }

    protected int getFlags() {
        return this.fFlags;
    }

    protected void setFlags(int flags) {
        this.fFlags = flags;
    }

    protected void setSize(Point size) {
        this.fSize = size;
    }
}

