/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.launchConfigurations;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsLaunchConfigurationMessages;
import org.eclipse.ui.externaltools.internal.launchConfigurations.VariableSelectionDialog;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsImages;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;
import org.eclipse.ui.externaltools.internal.model.ToolUtil;
import org.eclipse.ui.externaltools.internal.registry.ExternalToolVariableRegistry;

public abstract class ExternalToolsMainTab
extends AbstractLaunchConfigurationTab {
    protected Text locationField;
    protected Text workDirectoryField;
    protected Button fileLocationButton;
    protected Button workspaceLocationButton;
    protected Button fileWorkingDirectoryButton;
    protected Button workspaceWorkingDirectoryButton;
    protected Button runBackgroundButton;
    protected Text argumentField;
    protected Button variableButton;
    protected SelectionAdapter selectionAdapter;
    protected ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ExternalToolsMainTab.this.updateLaunchConfigurationDialog();
        }
    };

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData gridData = new GridData(768);
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)gridData);
        mainComposite.setFont(parent.getFont());
        this.createLocationComponent(mainComposite);
        this.createWorkDirectoryComponent(mainComposite);
        this.createArgumentComponent(mainComposite);
        this.createVerticalSpacer(mainComposite, 2);
        this.createRunBackgroundComponent(mainComposite);
    }

    protected void createLocationComponent(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)gridData);
        Label label = new Label(composite, 0);
        label.setText(ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsMainTab.&Location___2"));
        label.setFont(font);
        this.locationField = new Text(composite, 2048);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.locationField.setLayoutData((Object)data);
        this.locationField.setFont(font);
        Composite buttonComposite = new Composite(parent, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        gridData = new GridData(128);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setFont(font);
        this.createVerticalSpacer(buttonComposite, 1);
        this.workspaceLocationButton = this.createPushButton(buttonComposite, ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsMainTab.&Browse_Workspace..._3"), null);
        this.workspaceLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ExternalToolsMainTab.this.handleWorkspaceLocationButtonSelected();
            }
        });
        this.fileLocationButton = this.createPushButton(buttonComposite, ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsMainTab.Brows&e_File_System..._4"), null);
        this.fileLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ExternalToolsMainTab.this.handleLocationButtonSelected();
            }
        });
    }

    protected void createWorkDirectoryComponent(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)gridData);
        Label label = new Label(composite, 0);
        label.setText(this.getWorkingDirectoryLabel());
        label.setFont(font);
        this.workDirectoryField = new Text(composite, 2048);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.workDirectoryField.setLayoutData((Object)data);
        this.workDirectoryField.setFont(font);
        Composite buttonComposite = new Composite(parent, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        gridData = new GridData(128);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setFont(font);
        this.createVerticalSpacer(buttonComposite, 1);
        this.workspaceWorkingDirectoryButton = this.createPushButton(buttonComposite, ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsMainTab.Browse_Wor&kspace..._6"), null);
        this.workspaceWorkingDirectoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ExternalToolsMainTab.this.handleWorkspaceWorkingDirectoryButtonSelected();
            }
        });
        this.fileWorkingDirectoryButton = this.createPushButton(buttonComposite, ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsMainTab.Browse_F&ile_System..._7"), null);
        this.fileWorkingDirectoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ExternalToolsMainTab.this.handleFileWorkingDirectoryButtonSelected();
            }
        });
    }

    protected String getWorkingDirectoryLabel() {
        return ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsMainTab.Working_&Directory__5");
    }

    protected void createArgumentComponent(Composite parent) {
        Font font = parent.getFont();
        Label label = new Label(parent, 0);
        label.setText(ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsMainTab.&Arguments___1"));
        GridData data = new GridData(256);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setFont(font);
        this.argumentField = new Text(parent, 2626);
        data = new GridData(1808);
        data.widthHint = 200;
        data.heightHint = 40;
        this.argumentField.setLayoutData((Object)data);
        this.argumentField.setFont(font);
        this.argumentField.addModifyListener(this.modifyListener);
        this.variableButton = this.createPushButton(parent, ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsMainTab.Varia&bles..._2"), null);
        GridData gridData = new GridData(258);
        this.variableButton.setLayoutData((Object)gridData);
        this.variableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VariableSelectionDialog dialog = new VariableSelectionDialog(ExternalToolsMainTab.this.getShell());
                if (dialog.open() == 0) {
                    ExternalToolsMainTab.this.argumentField.insert(dialog.getForm().getSelectedVariable());
                }
            }
        });
        Label instruction = new Label(parent, 0);
        instruction.setText(ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsMainTab.Note__Enclose_an_argument_containing_spaces_using_double-quotes_(__)._Not_applicable_for_variables._3"));
        data = new GridData(256);
        data.horizontalSpan = 2;
        instruction.setLayoutData((Object)data);
        instruction.setFont(font);
    }

    protected void createRunBackgroundComponent(Composite parent) {
        this.runBackgroundButton = new Button(parent, 32);
        this.runBackgroundButton.setText(ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsMainTab.Run_tool_in_bac&kground_4"));
        GridData data = new GridData(256);
        data.horizontalSpan = 2;
        this.runBackgroundButton.setLayoutData((Object)data);
        this.runBackgroundButton.setFont(parent.getFont());
        this.runBackgroundButton.addSelectionListener(this.getSelectionAdapter());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.updateLocation(configuration);
        this.updateWorkingDirectory(configuration);
        this.updateArgument(configuration);
        this.updateRunBackground(configuration);
    }

    protected void updateWorkingDirectory(ILaunchConfiguration configuration) {
        String workingDir = "";
        try {
            workingDir = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", "");
        }
        catch (CoreException ce) {
            ExternalToolsPlugin.getDefault().log(ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsMainTab.Error_reading_configuration_10"), ce);
        }
        this.workDirectoryField.setText(workingDir);
        this.workDirectoryField.addModifyListener(this.modifyListener);
    }

    protected void updateLocation(ILaunchConfiguration configuration) {
        String location = "";
        try {
            location = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", "");
        }
        catch (CoreException ce) {
            ExternalToolsPlugin.getDefault().log(ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsMainTab.Error_reading_configuration_10"), ce);
        }
        this.locationField.setText(location);
        this.locationField.addModifyListener(this.modifyListener);
    }

    protected void updateArgument(ILaunchConfiguration configuration) {
        String arguments = "";
        try {
            arguments = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", "");
        }
        catch (CoreException ce) {
            ExternalToolsPlugin.getDefault().log(ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsMainTab.Error_reading_configuration_7"), ce);
        }
        this.argumentField.setText(arguments);
    }

    protected void updateRunBackground(ILaunchConfiguration configuration) {
        boolean runInBackground = true;
        try {
            runInBackground = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_RUN_IN_BACKGROUND", true);
        }
        catch (CoreException ce) {
            ExternalToolsPlugin.getDefault().log(ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsMainTab.Error_reading_configuration_7"), ce);
        }
        this.runBackgroundButton.setSelection(runInBackground);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String location = this.locationField.getText().trim();
        if (location.length() == 0) {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", null);
        } else {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", location);
        }
        String workingDirectory = this.workDirectoryField.getText().trim();
        if (workingDirectory.length() == 0) {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", null);
        } else {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", workingDirectory);
        }
        this.setAttribute("org.eclipse.ui.externaltools.ATTR_RUN_IN_BACKGROUND", configuration, this.runBackgroundButton.getSelection(), true);
        String arguments = this.argumentField.getText().trim();
        if (arguments.length() == 0) {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", null);
        } else {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", arguments);
        }
    }

    public String getName() {
        return ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsMainTab.&Main_17");
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        return this.validateLocation() && this.validateWorkDirectory() && this.validateArguments();
    }

    public boolean canSave() {
        return this.isValid(null);
    }

    protected boolean validateArguments() {
        String value = this.argumentField.getText().trim();
        if (!this.containsVariable(value)) {
            return true;
        }
        String variableError = this.validateVariables(value);
        if (variableError != null) {
            this.setErrorMessage(variableError);
            return false;
        }
        return true;
    }

    protected boolean validateLocation() {
        String value = this.locationField.getText().trim();
        if (value.length() < 1) {
            this.setErrorMessage(ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsMainTab.External_tool_location_cannot_be_empty_18"));
            this.setMessage(null);
            return false;
        }
        if (this.containsVariable(value)) {
            String variableError = this.validateVariables(value);
            if (variableError != null) {
                this.setErrorMessage(variableError);
                return false;
            }
            return true;
        }
        File file = new File(value);
        if (!file.exists()) {
            this.setErrorMessage(ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsMainTab.External_tool_location_does_not_exist_19"));
            return false;
        }
        if (!file.isFile()) {
            this.setErrorMessage(ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsMainTab.External_tool_location_specified_is_not_a_file_20"));
            return false;
        }
        return true;
    }

    private String validateVariables(String value) {
        int start = 0;
        ToolUtil.VariableDefinition variable = ToolUtil.extractVariableTag(value, start);
        while (variable.start != -1) {
            if (variable.end == -1) {
                return ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsMainTab.Invalid_Expected_closing_}");
            }
            if (variable.name == null || variable.name.length() == 0) {
                return ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsMainTab.No_variable_specified");
            }
            ExternalToolVariableRegistry registry = ExternalToolsPlugin.getDefault().getToolVariableRegistry();
            if (registry.getVariable(variable.name) == null) {
                return MessageFormat.format(ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsMainTab.Unknown_variable"), variable.name);
            }
            start = variable.end;
            variable = ToolUtil.extractVariableTag(value, start);
        }
        return null;
    }

    private boolean containsVariable(String value) {
        return ToolUtil.extractVariableTag((String)value, (int)0).start != -1;
    }

    protected boolean validateWorkDirectory() {
        String value = this.workDirectoryField.getText().trim();
        if (value.length() <= 0) {
            return true;
        }
        if (this.containsVariable(value)) {
            String variableError = this.validateVariables(value);
            if (variableError != null) {
                this.setErrorMessage(variableError);
                return false;
            }
            return true;
        }
        File file = new File(value);
        if (!file.exists()) {
            this.setErrorMessage(ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsMainTab.External_tool_working_directory_does_not_exist_or_is_invalid_21"));
            return false;
        }
        if (!file.isDirectory()) {
            this.setErrorMessage(ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsMainTab.Not_a_directory"));
            return false;
        }
        return true;
    }

    protected void handleLocationButtonSelected() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 0);
        fileDialog.setFileName(this.locationField.getText());
        String text = fileDialog.open();
        if (text != null) {
            this.locationField.setText(text);
        }
    }

    protected void handleWorkspaceLocationButtonSelected() {
        ResourceSelectionDialog dialog = new ResourceSelectionDialog(this.getShell(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsMainTab.Select_a_resource_22"));
        dialog.open();
        Object[] results = dialog.getResult();
        if (results == null || results.length < 1) {
            return;
        }
        IResource resource = (IResource)results[0];
        StringBuffer buf = new StringBuffer();
        ToolUtil.buildVariableTag("workspace_loc", resource.getFullPath().toString(), buf);
        String text = buf.toString();
        if (text != null) {
            this.locationField.setText(text);
        }
    }

    protected void handleWorkspaceWorkingDirectoryButtonSelected() {
        ContainerSelectionDialog containerDialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsMainTab.&Select_a_directory__23"));
        containerDialog.open();
        Object[] resource = containerDialog.getResult();
        String text = null;
        if (resource != null && resource.length > 0) {
            text = ToolUtil.buildVariableTag("workspace_loc", ((IPath)resource[0]).toString());
        }
        if (text != null) {
            this.workDirectoryField.setText(text);
        }
    }

    protected void handleFileWorkingDirectoryButtonSelected() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 8192);
        dialog.setMessage(ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsMainTab.&Select_a_directory__23"));
        dialog.setFilterPath(this.workDirectoryField.getText());
        String text = dialog.open();
        if (text != null) {
            this.workDirectoryField.setText(text);
        }
    }

    public Image getImage() {
        return ExternalToolsImages.getImage("org.eclipse.ui.externaltools.IMG_TAB_MAIN");
    }

    protected SelectionListener getSelectionAdapter() {
        if (this.selectionAdapter == null) {
            this.selectionAdapter = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExternalToolsMainTab.this.updateLaunchConfigurationDialog();
                }
            };
        }
        return this.selectionAdapter;
    }
}

