/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.launchConfigurations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsLaunchConfigurationMessages;
import org.eclipse.ui.externaltools.internal.model.ExternalToolBuilder;
import org.eclipse.ui.help.WorkbenchHelp;

public class ExternalToolsBuilderTab
extends AbstractLaunchConfigurationTab {
    private Button fullBuildButton;
    private Button autoBuildButton;
    private Button incrementalBuildButton;
    private SelectionListener fSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            ExternalToolsBuilderTab.this.updateLaunchConfigurationDialog();
        }
    };

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.ui.externaltools.builders_tab_context");
        GridLayout layout = new GridLayout();
        GridData gridData = new GridData(768);
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)gridData);
        mainComposite.setFont(parent.getFont());
        this.createBuildScheduleComponent(mainComposite);
    }

    private void createBuildScheduleComponent(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsBuilderTab.Run_this_builder_for__1"));
        this.fullBuildButton = this.createButton(parent, ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsBuilderTab.&Full_builds_2"), ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsBuilderTab.Full"));
        this.incrementalBuildButton = this.createButton(parent, ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsBuilderTab.&Incremental_builds_4"), ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsBuilderTab.Inc"));
        this.autoBuildButton = this.createButton(parent, ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsBuilderTab.&Auto_builds_(Not_recommended)_6"), ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsBuilderTab.Auto"));
    }

    private Button createButton(Composite parent, String text, String tooltipText) {
        Button button = new Button(parent, 32);
        button.setText(text);
        button.setToolTipText(tooltipText);
        button.addSelectionListener(this.fSelectionListener);
        return button;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        StringBuffer buffer = new StringBuffer("full");
        buffer.append(',');
        buffer.append("incremental");
        buffer.append(',');
        configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_RUN_BUILD_KINDS", buffer.toString());
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.fullBuildButton.setSelection(false);
        this.incrementalBuildButton.setSelection(false);
        this.autoBuildButton.setSelection(false);
        String buildKindString = null;
        try {
            buildKindString = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_RUN_BUILD_KINDS", "");
        }
        catch (CoreException coreException) {}
        int[] buildTypes = ExternalToolBuilder.buildTypesToArray(buildKindString);
        int i = 0;
        while (i < buildTypes.length) {
            switch (buildTypes[i]) {
                case 6: {
                    this.fullBuildButton.setSelection(true);
                    break;
                }
                case 10: {
                    this.incrementalBuildButton.setSelection(true);
                    break;
                }
                case 9: {
                    this.autoBuildButton.setSelection(true);
                }
            }
            ++i;
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        StringBuffer buffer = new StringBuffer();
        if (this.fullBuildButton.getSelection()) {
            buffer.append("full").append(',');
        }
        if (this.incrementalBuildButton.getSelection()) {
            buffer.append("incremental").append(',');
        }
        if (this.autoBuildButton.getSelection()) {
            buffer.append("auto").append(',');
        }
        configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_RUN_BUILD_KINDS", buffer.toString());
    }

    public String getName() {
        return ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsBuilderTab.Build_Options_9");
    }

    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
    }
}

