/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.dialog;

import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.externaltools.internal.group.IGroupDialogPage;
import org.eclipse.ui.externaltools.internal.model.ToolUtil;
import org.eclipse.ui.externaltools.internal.registry.ExternalToolVariable;
import org.eclipse.ui.externaltools.internal.variable.IVariableComponent;

public class ExternalToolVariableForm {
    private static final int VISIBLE_ITEM_COUNT = 6;
    private String variableListLabelText;
    private ExternalToolVariable[] variables;
    private IVariableComponent[] components;
    private IGroupDialogPage page;
    private Label variableListLabel;
    private List variableList;
    private Composite variableComposite;
    private StackLayout variableLayout;
    private int activeComponentIndex = -1;

    public ExternalToolVariableForm(String variableListLabelText, ExternalToolVariable[] variables) {
        this.variableListLabelText = variableListLabelText;
        this.variables = variables;
        this.components = new IVariableComponent[variables.length];
    }

    public Composite createContents(Composite parent, IGroupDialogPage page) {
        Font font = parent.getFont();
        this.page = page;
        Composite mainComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        GridData data = new GridData(1808);
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)data);
        this.variableListLabel = new Label(mainComposite, 0);
        this.variableListLabel.setText(this.variableListLabelText);
        data = new GridData(256);
        data.horizontalSpan = 1;
        this.variableListLabel.setLayoutData((Object)data);
        this.variableListLabel.setFont(font);
        this.variableList = new List(mainComposite, 2820);
        data = new GridData(768);
        data.heightHint = this.variableList.getItemHeight() * 6;
        this.variableList.setLayoutData((Object)data);
        this.variableList.setFont(font);
        this.variableComposite = new Composite(mainComposite, 0);
        this.variableLayout = new StackLayout();
        this.variableLayout.marginWidth = 0;
        this.variableLayout.marginHeight = 0;
        data = new GridData(1808);
        this.variableComposite.setLayout((Layout)this.variableLayout);
        this.variableComposite.setLayoutData((Object)data);
        this.variableComposite.setFont(font);
        this.createVariableComponents();
        this.populateVariableList();
        this.variableList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalToolVariableForm.this.updateVariableComposite(null, false);
            }
        });
        this.setEnabled(true);
        return mainComposite;
    }

    private void createVariableComponents() {
        int i = 0;
        while (i < this.variables.length) {
            ExternalToolVariable var = this.variables[i];
            this.components[i] = var.getComponent();
            this.components[i].createContents(this.variableComposite, var.getTag(), this.page);
            ++i;
        }
    }

    public String getSelectedVariable() {
        if (this.activeComponentIndex != -1) {
            String varValue = this.components[this.activeComponentIndex].getVariableValue();
            return ToolUtil.buildVariableTag(this.variables[this.activeComponentIndex].getTag(), varValue);
        }
        return null;
    }

    public boolean isValid() {
        if (this.activeComponentIndex != -1) {
            return this.components[this.activeComponentIndex].isValid();
        }
        return true;
    }

    private void populateVariableList() {
        String[] items = new String[this.variables.length];
        StringBuffer buffer = new StringBuffer(80);
        int i = 0;
        while (i < this.variables.length) {
            ToolUtil.buildVariableTag(this.variables[i].getTag(), null, buffer);
            buffer.append(" - ");
            buffer.append(this.variables[i].getDescription());
            items[i] = buffer.toString();
            buffer.setLength(0);
            ++i;
        }
        this.variableList.setItems(items);
    }

    public void selectVariable(String varName, String varValue) {
        if (varName != null && varName.length() > 0) {
            int i = 0;
            while (i < this.variables.length) {
                if (varName.equals(this.variables[i].getTag())) {
                    this.variableList.select(i);
                    this.updateVariableComposite(varValue, true);
                    return;
                }
                ++i;
            }
        }
        this.variableList.deselectAll();
        this.updateVariableComposite(varValue, false);
    }

    private void setComponentVisible(int index) {
        this.variableLayout.topControl = index == -1 ? null : this.components[index].getControl();
        this.variableComposite.layout();
    }

    public void setEnabled(boolean enabled) {
        this.variableListLabel.setEnabled(enabled);
        this.variableList.setEnabled(enabled);
        if (enabled && this.variableList.getSelection().length == 0 && this.variableList.getItemCount() > 0) {
            this.variableList.select(0);
            this.activeComponentIndex = 0;
        }
        this.variableComposite.setVisible(enabled);
        this.setComponentVisible(this.activeComponentIndex);
    }

    private void updateVariableComposite(String value, boolean setValue) {
        if (this.variableList.getSelectionIndex() == this.activeComponentIndex) {
            return;
        }
        this.activeComponentIndex = this.variableList.getSelectionIndex();
        this.setComponentVisible(this.activeComponentIndex);
        if (this.activeComponentIndex != -1 && setValue) {
            this.components[this.activeComponentIndex].setVariableValue(value);
        }
        this.page.updateValidState();
    }

    public void validate() {
        if (this.activeComponentIndex != -1) {
            this.components[this.activeComponentIndex].validate();
        }
    }
}

