/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.view.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.eclipse.ant.core.ProjectInfo;
import org.eclipse.ant.core.TargetInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.externaltools.internal.ant.model.AntUtil;
import org.eclipse.ui.externaltools.internal.ant.view.elements.AntNode;
import org.eclipse.ui.externaltools.internal.ant.view.elements.AntViewElementsMessages;
import org.eclipse.ui.externaltools.internal.ant.view.elements.TargetNode;

public class ProjectNode
extends AntNode {
    private List targets = null;
    private TargetNode defaultTarget = null;
    private String buildFileName;
    private boolean isErrorNode = false;
    private String defaultTargetName;

    public ProjectNode(String name, String buildFileName) {
        super(name);
        this.buildFileName = buildFileName;
    }

    public ProjectNode(String buildFileName) {
        this((String)null, buildFileName);
    }

    public TargetNode[] getTargets() {
        if (this.targets == null) {
            this.parseBuildFile();
        }
        return this.targets.toArray(new TargetNode[this.targets.size()]);
    }

    private void addTarget(TargetNode target) {
        this.targets.add(target);
        target.setParent(this);
    }

    public void setDefaultTarget(TargetNode target) {
        this.defaultTarget = target;
    }

    public String getBuildFileName() {
        return this.buildFileName;
    }

    public TargetNode getDefaultTarget() {
        if (this.targets == null) {
            this.parseBuildFile();
        }
        return this.defaultTarget;
    }

    public String getDefaultTargetName() {
        if (this.defaultTarget != null) {
            return this.defaultTarget.getName();
        }
        return this.defaultTargetName;
    }

    public void setDefaultTargetName(String name) {
        this.defaultTargetName = name;
    }

    public void setIsErrorNode(boolean isErrorNode) {
        this.isErrorNode = isErrorNode;
    }

    public boolean isErrorNode() {
        return this.isErrorNode;
    }

    public void parseBuildFile() {
        Target target;
        this.clear();
        TargetInfo[] infos = null;
        try {
            infos = AntUtil.getTargets(this.buildFileName);
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
            return;
        }
        if (infos.length < 1) {
            this.setErrorMessage(AntViewElementsMessages.getString("ProjectNode.No_targets"));
            return;
        }
        ProjectInfo projectInfo = infos[0].getProject();
        Project project = new Project();
        if (projectInfo.getName() != null) {
            project.setName(projectInfo.getName());
        }
        int i = 0;
        while (i < infos.length) {
            TargetInfo info = infos[i];
            if (info.isDefault()) {
                project.setDefault(info.getName());
            }
            target = new Target();
            target.setName(info.getName());
            String[] dependencies = info.getDependencies();
            StringBuffer depends = new StringBuffer();
            int numDependencies = dependencies.length;
            if (numDependencies > 0) {
                depends.append(dependencies[0]);
            }
            int j = 1;
            while (j < numDependencies) {
                depends.append(',').append(dependencies[j]);
                ++j;
            }
            target.setDepends(depends.toString());
            target.setDescription(info.getDescription());
            project.addTarget(target);
            ++i;
        }
        if (project.getDefaultTarget() == null) {
            this.setErrorMessage(AntViewElementsMessages.getString("ProjectNode.No_default"));
            return;
        }
        String projectName = project.getName();
        if (projectName == null) {
            projectName = AntViewElementsMessages.getString("ProjectNode.<name_unspecified>_1");
        }
        this.setName(projectName);
        this.setDescription(projectInfo.getDescription());
        Enumeration projTargets = project.getTargets().elements();
        while (projTargets.hasMoreElements()) {
            target = (Target)projTargets.nextElement();
            Enumeration targetDependencies = target.getDependencies();
            TargetNode targetNode = new TargetNode(target.getName(), target.getDescription());
            while (targetDependencies.hasMoreElements()) {
                targetNode.addDependency((String)targetDependencies.nextElement());
            }
            this.addTarget(targetNode);
            if (!target.getName().equals(project.getDefaultTarget())) continue;
            this.setDefaultTarget(targetNode);
        }
        Collections.sort(this.targets, new Comparator(){

            public int compare(Object o1, Object o2) {
                String name1 = "";
                String name2 = "";
                if (o1 instanceof TargetNode) {
                    name1 = ((TargetNode)o1).getName();
                }
                if (o2 instanceof TargetNode) {
                    name2 = ((TargetNode)o2).getName();
                }
                return name1.compareToIgnoreCase(name2);
            }
        });
    }

    private void clear() {
        this.targets = new ArrayList();
        this.setIsErrorNode(false);
        this.setDefaultTarget(null);
        this.setDefaultTargetName(null);
    }

    private void setErrorMessage(String errorMessage) {
        this.setName(this.getBuildFileName());
        this.setIsErrorNode(true);
        TargetNode target = new TargetNode(errorMessage, errorMessage);
        target.setIsErrorNode(true);
        this.addTarget(target);
    }

    public String getName() {
        String name;
        if (super.getName() == null) {
            this.parseBuildFile();
        }
        if ((name = super.getName()) == null || name.length() == 0) {
            name = AntViewElementsMessages.getString("ProjectNode.<name_unspecified>_1");
        }
        return name;
    }

    public String toString() {
        return this.getName();
    }
}

