/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.view.actions;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.externaltools.internal.ant.launchConfigurations.AntLaunchShortcut;
import org.eclipse.ui.externaltools.internal.ant.model.AntUtil;
import org.eclipse.ui.externaltools.internal.ant.view.AntView;
import org.eclipse.ui.externaltools.internal.ant.view.actions.AntViewActionMessages;
import org.eclipse.ui.externaltools.internal.ant.view.elements.ProjectNode;
import org.eclipse.ui.externaltools.internal.ant.view.elements.TargetNode;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsImages;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.texteditor.IUpdate;

public class RunTargetAction
extends Action
implements IUpdate {
    private AntView view;

    public RunTargetAction(AntView view) {
        super(AntViewActionMessages.getString("RunTargetAction.Run_1"), ExternalToolsImages.getImageDescriptor("org.eclipse.ui.externaltools.run"));
        this.setToolTipText(AntViewActionMessages.getString("RunTargetAction.Run_Default"));
        this.view = view;
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ui.externaltools.run_target_action_context");
    }

    public void run() {
        TargetNode target = this.getSelectedTarget();
        if (target == null) {
            return;
        }
        this.run(target);
    }

    public void run(TargetNode target) {
        IFile file = AntUtil.getFile(target.getProject().getBuildFileName());
        AntLaunchShortcut shortcut = new AntLaunchShortcut();
        shortcut.launch(file, "run", target.getName());
    }

    public void update() {
        this.setEnabled(this.getSelectedTarget() != null);
    }

    private TargetNode getSelectedTarget() {
        IStructuredSelection selection = (IStructuredSelection)this.view.getProjectViewer().getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        Iterator iter = selection.iterator();
        Object data = iter.next();
        if (iter.hasNext() || !(data instanceof TargetNode) && !(data instanceof ProjectNode)) {
            return null;
        }
        if (data instanceof TargetNode) {
            return (TargetNode)selection.getFirstElement();
        }
        return ((ProjectNode)selection.getFirstElement()).getDefaultTarget();
    }
}

