/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.view.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.externaltools.internal.ant.launchConfigurations.AntLaunchShortcut;
import org.eclipse.ui.externaltools.internal.ant.model.AntUtil;
import org.eclipse.ui.externaltools.internal.ant.view.AntView;
import org.eclipse.ui.externaltools.internal.ant.view.actions.AntViewActionMessages;
import org.eclipse.ui.externaltools.internal.ant.view.elements.AntNode;
import org.eclipse.ui.externaltools.internal.ant.view.elements.ProjectNode;
import org.eclipse.ui.externaltools.internal.ant.view.elements.TargetNode;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.texteditor.IUpdate;

public class EditLaunchConfigurationAction
extends Action
implements IUpdate {
    private AntView view;
    private ProjectNode projectNode;

    public EditLaunchConfigurationAction(AntView view) {
        super(AntViewActionMessages.getString("EditLaunchConfigurationAction.Properties"));
        this.setDescription(AntViewActionMessages.getString("EditLaunchConfigurationAction.Edit"));
        this.view = view;
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ui.externaltools.edit_launch_configuration_action_context");
    }

    public void run() {
        IFile file = AntUtil.getFile(this.projectNode.getBuildFileName());
        ILaunchConfiguration configuration = null;
        List configurations = AntLaunchShortcut.findExistingLaunchConfigurations(file);
        if (configurations.isEmpty()) {
            configuration = AntLaunchShortcut.createDefaultLaunchConfiguration(file);
        } else if (configurations.size() == 1) {
            configuration = (ILaunchConfiguration)configurations.get(0);
        } else {
            configuration = AntLaunchShortcut.chooseConfig(configurations);
            if (configuration == null) {
                return;
            }
        }
        if (configuration != null) {
            DebugUITools.openLaunchConfigurationPropertiesDialog((Shell)this.view.getSite().getShell(), (ILaunchConfiguration)configuration, (String)"org.eclipse.ui.externaltools.launchGroup.builder");
        }
    }

    public void update() {
        boolean enabled;
        block10: {
            IStructuredSelection selection;
            block8: {
                Object element;
                block11: {
                    block9: {
                        enabled = false;
                        selection = (IStructuredSelection)this.view.getProjectViewer().getSelection();
                        if (selection.size() != 1) break block8;
                        element = selection.getFirstElement();
                        if (!(element instanceof ProjectNode)) break block9;
                        if (!((ProjectNode)element).isErrorNode()) {
                            enabled = true;
                            this.projectNode = (ProjectNode)element;
                        }
                        break block10;
                    }
                    if (!(element instanceof TargetNode)) break block11;
                    if (!((TargetNode)element).isErrorNode()) {
                        enabled = true;
                        this.projectNode = this.getProjectNode((AntNode)element);
                    }
                    break block10;
                }
                if (!(element instanceof AntNode)) break block10;
                this.projectNode = this.getProjectNode((AntNode)element);
                enabled = true;
                break block10;
            }
            if (!selection.isEmpty()) {
                Iterator iter = selection.iterator();
                Object data = null;
                enabled = true;
                ProjectNode tempProjectNode = null;
                while (iter.hasNext()) {
                    ProjectNode projectNode;
                    TargetNode targetNode;
                    data = iter.next();
                    if (!(data instanceof AntNode)) continue;
                    if (data instanceof TargetNode && (targetNode = (TargetNode)data).isErrorNode()) {
                        enabled = false;
                        break;
                    }
                    if (data instanceof ProjectNode && (projectNode = (ProjectNode)data).isErrorNode()) {
                        enabled = false;
                        break;
                    }
                    tempProjectNode = this.getProjectNode(data);
                    if (this.projectNode != null) {
                        if (this.projectNode.equals(tempProjectNode)) continue;
                        enabled = false;
                        break;
                    }
                    this.projectNode = tempProjectNode;
                }
            }
        }
        if (!enabled) {
            this.projectNode = null;
        }
        this.setEnabled(enabled);
    }

    private ProjectNode getProjectNode(AntNode antNode) {
        AntNode parentNode = null;
        if (antNode instanceof ProjectNode) {
            parentNode = antNode;
        } else {
            parentNode = antNode.getParent();
            while (parentNode != null && !(parentNode instanceof ProjectNode)) {
                parentNode = parentNode.getParent();
            }
        }
        return (ProjectNode)parentNode;
    }
}

