/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.view.actions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.externaltools.internal.ant.view.actions.AntViewActionMessages;
import org.eclipse.ui.externaltools.internal.ant.view.actions.EditorImageDescriptor;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;

public class AntOpenWithMenu
extends ContributionItem {
    private IWorkbenchPage page;
    private IAdaptable file;
    private IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
    private static final String SYSTEM_EDITOR_ID = "org.eclipse.ui.SystemEditor";
    private static Map imageCache = new Hashtable(11);
    public static final String ID = "org.eclipse.ui.externaltools.AntOpenWithMenu";
    static /* synthetic */ Class class$0;

    public AntOpenWithMenu(IWorkbenchPage page) {
        super(ID);
        this.page = page;
    }

    public void setFile(IAdaptable file) {
        this.file = file;
    }

    public void dispose() {
        super.dispose();
        Iterator iter = imageCache.values().iterator();
        while (iter.hasNext()) {
            Image image = (Image)iter.next();
            image.dispose();
        }
        imageCache.clear();
    }

    private Image getImage(IEditorDescriptor editorDesc) {
        ImageDescriptor imageDesc = this.getImageDescriptor(editorDesc);
        if (imageDesc == null) {
            return null;
        }
        Image image = (Image)imageCache.get(imageDesc);
        if (image == null) {
            image = imageDesc.createImage();
            imageCache.put(imageDesc, image);
        }
        return image;
    }

    private ImageDescriptor getImageDescriptor(IEditorDescriptor editorDesc) {
        ImageDescriptor imageDesc = null;
        imageDesc = editorDesc == null ? this.registry.getImageDescriptor(this.getFileResource()) : editorDesc.getImageDescriptor();
        if (imageDesc == null && editorDesc.getId().equals(SYSTEM_EDITOR_ID)) {
            imageDesc = this.getSystemEditorImageDescriptor(this.getFileResource().getFileExtension());
        }
        return imageDesc;
    }

    private ImageDescriptor getSystemEditorImageDescriptor(String extension) {
        Program externalProgram = null;
        if (extension != null) {
            externalProgram = Program.findProgram((String)extension);
        }
        if (externalProgram == null) {
            return null;
        }
        return new EditorImageDescriptor(externalProgram);
    }

    private void createMenuItem(Menu menu, final IEditorDescriptor descriptor, IEditorDescriptor preferredEditor) {
        final MenuItem menuItem = new MenuItem(menu, 16);
        boolean isPreferred = preferredEditor != null && descriptor.getId().equals(preferredEditor.getId());
        menuItem.setSelection(isPreferred);
        menuItem.setText(descriptor.getLabel());
        Image image = this.getImage(descriptor);
        if (image != null) {
            menuItem.setImage(image);
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (!menuItem.getSelection()) break;
                        AntOpenWithMenu.this.openEditor(descriptor);
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }

    public void fill(Menu menu, int index) {
        IFile file = this.getFileResource();
        if (file == null) {
            return;
        }
        IEditorDescriptor defaultEditor = this.registry.getDefaultEditor();
        IEditorDescriptor preferredEditor = this.registry.getDefaultEditor(file);
        IEditorDescriptor[] editors = this.registry.getEditors(file);
        Arrays.sort(editors, new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = ((IEditorDescriptor)o1).getLabel();
                String s2 = ((IEditorDescriptor)o2).getLabel();
                return s1.compareToIgnoreCase(s2);
            }
        });
        IEditorDescriptor antEditor = this.registry.findEditor("org.eclipse.ui.externaltools.internal.ant.editor.AntEditor");
        boolean defaultFound = false;
        boolean antFound = false;
        ArrayList<String> alreadyAddedEditors = new ArrayList<String>(editors.length);
        int i = 0;
        while (i < editors.length) {
            IEditorDescriptor editor = editors[i];
            if (!alreadyAddedEditors.contains(editor.getId())) {
                this.createMenuItem(menu, editor, preferredEditor);
                if (defaultEditor != null && editor.getId().equals(defaultEditor.getId())) {
                    defaultFound = true;
                }
                if (antEditor != null && editor.getId().equals(antEditor.getId())) {
                    antFound = true;
                }
                alreadyAddedEditors.add(editor.getId());
            }
            ++i;
        }
        if (editors.length > 0) {
            new MenuItem(menu, 2);
        }
        if (!antFound && antEditor != null) {
            this.createMenuItem(menu, antEditor, preferredEditor);
        }
        if (!defaultFound && defaultEditor != null) {
            this.createMenuItem(menu, defaultEditor, preferredEditor);
        }
        IEditorDescriptor descriptor = this.registry.findEditor(SYSTEM_EDITOR_ID);
        this.createMenuItem(menu, descriptor, preferredEditor);
        this.createDefaultMenuItem(menu, file);
    }

    private IFile getFileResource() {
        IResource resource;
        if (this.file instanceof IFile) {
            return (IFile)this.file;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)this.file.getAdapter((Class)clazz)) instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    public boolean isDynamic() {
        return true;
    }

    private void openEditor(IEditorDescriptor editor) {
        IFile file = this.getFileResource();
        try {
            if (editor == null) {
                this.page.openSystemEditor(file);
            } else {
                this.page.openEditor(file, editor.getId());
            }
        }
        catch (PartInitException e) {
            ExternalToolsPlugin.getDefault().log(MessageFormat.format(AntViewActionMessages.getString("AntViewOpenWithMenu.Editor_failed"), file.getLocation().toOSString()), e);
        }
    }

    private void createDefaultMenuItem(Menu menu, final IFile file) {
        final MenuItem menuItem = new MenuItem(menu, 16);
        menuItem.setSelection(this.registry.getDefaultEditor(file) == null);
        menuItem.setText(AntViewActionMessages.getString("AntViewOpenWithMenu.Default_Editor_4"));
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (!menuItem.getSelection()) break;
                        AntOpenWithMenu.this.registry.setDefaultEditor(file, null);
                        try {
                            AntOpenWithMenu.this.page.openEditor(file);
                            break;
                        }
                        catch (PartInitException e) {
                            ExternalToolsPlugin.getDefault().log(MessageFormat.format(AntViewActionMessages.getString("AntViewOpenWithMenu.Editor_failed"), file.getLocation().toOSString()), e);
                        }
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }
}

