/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.view;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.externaltools.internal.ant.view.AntViewMessages;
import org.eclipse.ui.externaltools.internal.ant.view.elements.ProjectNode;
import org.eclipse.ui.externaltools.internal.ant.view.elements.TargetNode;
import org.eclipse.ui.externaltools.internal.model.AntImageDescriptor;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsImages;

public class AntViewLabelProvider
implements ILabelProvider {
    public Image getImage(Object element) {
        if (element instanceof ProjectNode) {
            ProjectNode project = (ProjectNode)element;
            int flags = 0;
            if (project.isErrorNode()) {
                flags |= 2;
            }
            AntImageDescriptor descriptor = new AntImageDescriptor(ExternalToolsImages.getImageDescriptor("org.eclipse.ui.externaltools.antProject"), flags);
            return ExternalToolsImages.getImage(descriptor);
        }
        if (element instanceof TargetNode) {
            TargetNode target = (TargetNode)element;
            int flags = 0;
            ImageDescriptor base = null;
            if (target.equals(target.getProject().getDefaultTarget())) {
                flags |= 1;
                base = ExternalToolsImages.getImageDescriptor("org.eclipse.ui.externaltools.antDefaultTarget");
            } else {
                base = target.getDescription() == null ? ExternalToolsImages.getImageDescriptor("org.eclipse.ui.externaltools.antPrivateTarget") : ExternalToolsImages.getImageDescriptor("org.eclipse.ui.externaltools.antTarget");
            }
            if (target.isErrorNode()) {
                flags |= 2;
            }
            return ExternalToolsImages.getImage(new AntImageDescriptor(base, flags));
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof TargetNode) {
            TargetNode node = (TargetNode)element;
            StringBuffer name = new StringBuffer(node.getName());
            if (node.getName().equals(node.getProject().getDefaultTargetName())) {
                name.append(AntViewMessages.getString("TargetNode.default"));
            }
            return name.toString();
        }
        if (element instanceof ProjectNode) {
            ProjectNode project = (ProjectNode)element;
            StringBuffer buffer = new StringBuffer(project.getName());
            String defaultTarget = project.getDefaultTargetName();
            if (defaultTarget != null) {
                buffer.append(" [").append(defaultTarget).append(']');
            }
            return buffer.toString();
        }
        return element.toString();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

