/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.preferences;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.core.Type;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.externaltools.internal.ant.preferences.AddCustomDialog;
import org.eclipse.ui.externaltools.internal.ant.preferences.AntPage;
import org.eclipse.ui.externaltools.internal.ant.preferences.AntPreferencesMessages;
import org.eclipse.ui.externaltools.internal.ant.preferences.AntRuntimePreferencePage;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;

public class AntTypesPage
extends AntPage {
    private static final int ADD_TYPE_BUTTON = 1025;
    private static final int EDIT_TYPE_BUTTON = 1026;
    private static final int REMOVE_BUTTON = 1027;
    private final AntTypesLabelProvider labelProvider = new AntTypesLabelProvider();

    public AntTypesPage(AntRuntimePreferencePage preferencePage) {
        super(preferencePage);
    }

    protected void addButtonsToButtonGroup(Composite parent) {
        this.createPushButton(parent, AntPreferencesMessages.getString("AntTypesPage.addTypeButtonTitle"), 1025);
        this.editButton = this.createPushButton(parent, AntPreferencesMessages.getString("AntTypesPage.editTypeButtonTitle"), 1026);
        this.createSeparator(parent);
        this.removeButton = this.createPushButton(parent, AntPreferencesMessages.getString("AntTypesPage.removeButtonTitle"), 1027);
    }

    private void addType() {
        String title = AntPreferencesMessages.getString("AntTypesPage.addTypeDialogTitle");
        String msg = AntPreferencesMessages.getString("AntTypesPage.addTypeDialogDescription");
        Iterator types = this.getContents(true).iterator();
        ArrayList<String> names = new ArrayList<String>();
        while (types.hasNext()) {
            Type aTask = (Type)types.next();
            names.add(aTask.getTypeName());
        }
        AddCustomDialog dialog = new AddCustomDialog(this.getShell(), this.getPreferencePage().getLibraryURLs(), names, title, msg, AntPreferencesMessages.getString("AntTypesPage.type_1"));
        if (dialog.open() == 1) {
            return;
        }
        Type type = new Type();
        type.setTypeName(dialog.getName());
        type.setClassName(dialog.getClassName());
        type.setLibrary(dialog.getLibrary());
        this.addContent(type);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1025: {
                this.addType();
                break;
            }
            case 1026: {
                this.edit(this.getSelection());
                break;
            }
            case 1027: {
                this.remove();
            }
        }
    }

    protected TabItem createTabItem(TabFolder folder) {
        TabItem item = new TabItem(folder, 0);
        item.setText(AntPreferencesMessages.getString("AntTypesPage.typesPageTitle"));
        item.setImage(this.labelProvider.getTypeImage());
        item.setData((Object)this);
        Composite top = new Composite((Composite)folder, 0);
        top.setFont(folder.getFont());
        item.setControl((Control)this.createContents(top));
        this.connectToFolder(item, folder);
        return item;
    }

    protected void edit(IStructuredSelection selection) {
        Type type = (Type)selection.getFirstElement();
        if (type == null) {
            return;
        }
        String title = AntPreferencesMessages.getString("AntTypesPage.editTypeDialogTitle");
        String msg = AntPreferencesMessages.getString("AntTypesPage.editTypeDialogDescription");
        Iterator types = this.getContents(true).iterator();
        ArrayList<String> names = new ArrayList<String>();
        while (types.hasNext()) {
            Type aTask = (Type)types.next();
            names.add(aTask.getTypeName());
        }
        AddCustomDialog dialog = new AddCustomDialog(this.getShell(), this.getPreferencePage().getLibraryURLs(), names, title, msg, AntPreferencesMessages.getString("AntTypesPage.type_1"));
        dialog.setClassName(type.getClassName());
        dialog.setName(type.getTypeName());
        dialog.setLibrary(type.getLibrary());
        if (dialog.open() == 1) {
            return;
        }
        type.setTypeName(dialog.getName());
        type.setClassName(dialog.getClassName());
        type.setLibrary(dialog.getLibrary());
        this.updateContent(type);
    }

    protected ITableLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    protected void initialize() {
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        this.setInput(prefs.getTypes());
    }

    protected String getHelpContextId() {
        return "org.eclipse.ui.externaltools.ant_types_page_context";
    }

    private static final class AntTypesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private static final String IMG_TYPE = "icons/full/obj16/type.gif";
        private Image typeImage;

        public void dispose() {
            if (this.typeImage != null) {
                this.typeImage.dispose();
                this.typeImage = null;
            }
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return this.getTypeImage();
        }

        public String getColumnText(Object element, int columnIndex) {
            Type type = (Type)element;
            StringBuffer text = new StringBuffer(type.getTypeName());
            text.append(" (");
            text.append(type.getLibrary().getFile());
            text.append(": ");
            text.append(type.getClassName());
            text.append(')');
            if (type.isDefault()) {
                text.append(AntPreferencesMessages.getString("AntTypesPage._[system_type]_3"));
            }
            return text.toString();
        }

        public Image getTypeImage() {
            if (this.typeImage == null) {
                ImageDescriptor desc = ExternalToolsPlugin.getDefault().getImageDescriptor(IMG_TYPE);
                this.typeImage = desc.createImage();
            }
            return this.typeImage;
        }
    }
}

