/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.preferences;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.core.Task;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.externaltools.internal.ant.preferences.AddCustomDialog;
import org.eclipse.ui.externaltools.internal.ant.preferences.AntPage;
import org.eclipse.ui.externaltools.internal.ant.preferences.AntPreferencesMessages;
import org.eclipse.ui.externaltools.internal.ant.preferences.AntRuntimePreferencePage;

public class AntTasksPage
extends AntPage {
    private static final int ADD_TASK_BUTTON = 1025;
    private static final int EDIT_TASK_BUTTON = 1026;
    private static final int REMOVE_BUTTON = 1027;
    private final AntTasksLabelProvider labelProvider = new AntTasksLabelProvider();

    public AntTasksPage(AntRuntimePreferencePage preferencePage) {
        super(preferencePage);
    }

    protected void addButtonsToButtonGroup(Composite parent) {
        this.createPushButton(parent, AntPreferencesMessages.getString("AntTasksPage.addTaskButtonTitle"), 1025);
        this.editButton = this.createPushButton(parent, AntPreferencesMessages.getString("AntTasksPage.editTaskButtonTitle"), 1026);
        this.createSeparator(parent);
        this.removeButton = this.createPushButton(parent, AntPreferencesMessages.getString("AntTasksPage.removeButtonTitle"), 1027);
    }

    private void addTask() {
        String title = AntPreferencesMessages.getString("AntTasksPage.addTaskDialogTitle");
        String msg = AntPreferencesMessages.getString("AntTasksPage.addTaskDialogDescription");
        Iterator tasks = this.getContents(true).iterator();
        ArrayList<String> names = new ArrayList<String>();
        while (tasks.hasNext()) {
            Task task = (Task)tasks.next();
            names.add(task.getTaskName());
        }
        AddCustomDialog dialog = new AddCustomDialog(this.getShell(), this.getPreferencePage().getLibraryURLs(), names, title, msg, AntPreferencesMessages.getString("AntTasksPage.task_1"));
        if (dialog.open() == 1) {
            return;
        }
        Task task = new Task();
        task.setTaskName(dialog.getName());
        task.setClassName(dialog.getClassName());
        task.setLibrary(dialog.getLibrary());
        this.addContent(task);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1025: {
                this.addTask();
                break;
            }
            case 1026: {
                this.edit(this.getSelection());
                break;
            }
            case 1027: {
                this.remove();
            }
        }
    }

    protected TabItem createTabItem(TabFolder folder) {
        TabItem item = new TabItem(folder, 0);
        item.setText(AntPreferencesMessages.getString("AntTasksPage.title"));
        item.setImage(this.labelProvider.getTaskImage());
        item.setData((Object)this);
        Composite top = new Composite((Composite)folder, 0);
        top.setFont(folder.getFont());
        item.setControl((Control)this.createContents(top));
        this.connectToFolder(item, folder);
        return item;
    }

    protected void edit(IStructuredSelection selection) {
        Task task = (Task)selection.getFirstElement();
        if (task == null) {
            return;
        }
        String title = AntPreferencesMessages.getString("AntTasksPage.editTaskDialogTitle");
        String msg = AntPreferencesMessages.getString("AntTasksPage.editTaskDialogDescription");
        Iterator tasks = this.getContents(true).iterator();
        ArrayList<String> names = new ArrayList<String>();
        while (tasks.hasNext()) {
            Task aTask = (Task)tasks.next();
            names.add(aTask.getTaskName());
        }
        AddCustomDialog dialog = new AddCustomDialog(this.getShell(), this.getPreferencePage().getLibraryURLs(), names, title, msg, AntPreferencesMessages.getString("AntTasksPage.task_1"));
        dialog.setClassName(task.getClassName());
        dialog.setName(task.getTaskName());
        dialog.setLibrary(task.getLibrary());
        if (dialog.open() == 1) {
            return;
        }
        task.setTaskName(dialog.getName());
        task.setClassName(dialog.getClassName());
        task.setLibrary(dialog.getLibrary());
        this.updateContent(task);
    }

    protected ITableLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    protected void initialize() {
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        this.setInput(prefs.getTasks());
    }

    protected String getHelpContextId() {
        return "org.eclipse.ui.externaltools.ant_tasks_page_context";
    }

    private static final class AntTasksLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private Image taskImage;

        public void dispose() {
            this.taskImage = null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return this.getTaskImage();
        }

        public String getColumnText(Object element, int columnIndex) {
            Task task = (Task)element;
            StringBuffer text = new StringBuffer(task.getTaskName());
            text.append(" (");
            text.append(task.getLibrary().getFile());
            text.append(": ");
            text.append(task.getClassName());
            text.append(')');
            if (task.isDefault()) {
                text.append(AntPreferencesMessages.getString("AntTasksPage._[system_task]_3"));
            }
            return text.toString();
        }

        public Image getTaskImage() {
            if (this.taskImage == null) {
                this.taskImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_TASK_TSK");
            }
            return this.taskImage;
        }
    }
}

