/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.preferences;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.core.Property;
import org.eclipse.ant.core.Task;
import org.eclipse.ant.core.Type;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.externaltools.internal.ant.preferences.AntClasspathPage;
import org.eclipse.ui.externaltools.internal.ant.preferences.AntPreferencesMessages;
import org.eclipse.ui.externaltools.internal.ant.preferences.AntPropertiesPage;
import org.eclipse.ui.externaltools.internal.ant.preferences.AntTasksPage;
import org.eclipse.ui.externaltools.internal.ant.preferences.AntTypesPage;
import org.eclipse.ui.externaltools.internal.ant.preferences.TabFolderLayout;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;
import org.eclipse.ui.help.WorkbenchHelp;

public class AntRuntimePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private AntClasspathPage classpathPage;
    private AntTasksPage tasksPage;
    private AntTypesPage typesPage;
    private AntPropertiesPage propertiesPage;

    public AntRuntimePreferencePage() {
        this.setDescription(AntPreferencesMessages.getString("AntPreferencePage.description"));
        this.setPreferenceStore(ExternalToolsPlugin.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        folder.setFont(parent.getFont());
        this.classpathPage = new AntClasspathPage(this);
        this.classpathPage.createTabItem(folder);
        this.tasksPage = new AntTasksPage(this);
        this.tasksPage.createTabItem(folder);
        this.typesPage = new AntTypesPage(this);
        this.typesPage.createTabItem(folder);
        this.propertiesPage = new AntPropertiesPage(this);
        this.propertiesPage.createTabItem(folder);
        this.tasksPage.initialize();
        this.typesPage.initialize();
        this.classpathPage.initialize();
        this.propertiesPage.initialize();
        return folder;
    }

    protected void performDefaults() {
        super.performDefaults();
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        this.tasksPage.setInput(prefs.getDefaultTasks());
        this.typesPage.setInput(prefs.getDefaultTypes());
        this.classpathPage.performDefaults();
        this.propertiesPage.performDefaults();
    }

    public boolean performOk() {
        URL[] urls;
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        List contents = this.classpathPage.getAntURLs();
        if (contents != null) {
            urls = contents.toArray(new URL[contents.size()]);
            prefs.setAntURLs(urls);
        }
        if ((contents = this.classpathPage.getUserURLs()) != null) {
            urls = contents.toArray(new URL[contents.size()]);
            prefs.setCustomURLs(urls);
        }
        String antHome = this.classpathPage.getAntHome();
        prefs.setAntHome(antHome);
        contents = this.tasksPage.getContents(false);
        if (contents != null) {
            Task[] tasks = contents.toArray(new Task[contents.size()]);
            prefs.setCustomTasks(tasks);
        }
        if ((contents = this.typesPage.getContents(false)) != null) {
            Type[] types = contents.toArray(new Type[contents.size()]);
            prefs.setCustomTypes(types);
        }
        if ((contents = this.propertiesPage.getProperties()) != null) {
            Property[] properties = contents.toArray(new Property[contents.size()]);
            prefs.setCustomProperties(properties);
        }
        String[] files = this.propertiesPage.getPropertyFiles();
        prefs.setCustomPropertyFiles(files);
        prefs.updatePluginPreferences();
        return super.performOk();
    }

    protected GridData setButtonLayoutData(Button button) {
        return super.setButtonLayoutData(button);
    }

    protected List getLibraryURLs() {
        ArrayList urls = new ArrayList();
        urls.addAll(this.classpathPage.getAntURLs());
        urls.addAll(this.classpathPage.getUserURLs());
        return urls;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.ui.externaltools.ant_runtime_preference_page_context");
    }
}

