/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.externaltools.internal.ant.preferences.AntPreferencesMessages;
import org.eclipse.ui.externaltools.internal.ant.preferences.ColorEditor;
import org.eclipse.ui.externaltools.internal.ant.preferences.OverlayPreferenceStore;
import org.eclipse.ui.externaltools.internal.ant.preferences.TabFolderLayout;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;
import org.eclipse.ui.externaltools.internal.ui.StatusInfo;
import org.eclipse.ui.help.WorkbenchHelp;

public class AntEditorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public final OverlayPreferenceStore.OverlayKey[] fKeys = new OverlayPreferenceStore.OverlayKey[]{new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "currentLineColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "currentLine"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "printMarginColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "printMarginColumn"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "printMargin"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "problemIndicationColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "problemIndication"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "warningIndicationColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "warningIndication"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "infoIndicationColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "infoIndication"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "taskIndicationColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "taskIndication"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "bookmarkIndicationColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "bookmarkIndication"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "searchResultIndicationColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "searchResultIndication"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "othersIndicationColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "othersIndication"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "errorIndicationInOverviewRuler"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "warningIndicationInOverviewRuler"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "infoIndicationInOverviewRuler"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "taskIndicationInOverviewRuler"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "bookmarkIndicationInOverviewRuler"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "searchResultIndicationInOverviewRuler"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "othersIndicationInOverviewRuler"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "overviewRuler"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "lineNumberColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "lineNumberRuler"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "planty.color.default"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "planty.color.instr"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "planty.color.string"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "planty.color.tag"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "planty.color.xml_comment")};
    private final String[][] fAppearanceColorListModel;
    private final String[][] fAnnotationColorListModel;
    private OverlayPreferenceStore fOverlayStore;
    private Map fCheckBoxes;
    private SelectionListener fCheckBoxListener;
    private Map fTextFields;
    private ModifyListener fTextFieldListener;
    private ArrayList fNumberFields;
    private ModifyListener fNumberFieldListener;
    private List fAppearanceColorList;
    private List fAnnotationList;
    private ColorEditor fAppearanceColorEditor;
    private ColorEditor fAnnotationForegroundColorEditor;
    private Button fShowInTextCheckBox;
    private Button fShowInOverviewRulerCheckBox;

    public AntEditorPreferencePage() {
        String[][] stringArrayArray = new String[8][];
        stringArrayArray[0] = new String[]{AntPreferencesMessages.getString("AntEditorPreferencePage.lineNumberForegroundColor"), "lineNumberColor"};
        stringArrayArray[1] = new String[]{AntPreferencesMessages.getString("AntEditorPreferencePage.currentLineHighlighColor"), "currentLineColor"};
        stringArrayArray[2] = new String[]{AntPreferencesMessages.getString("AntEditorPreferencePage.printMarginColor"), "printMarginColor"};
        String[] stringArray = new String[3];
        stringArray[0] = AntPreferencesMessages.getString("AntEditorPreferencePage.Ant_editor_text_1");
        stringArray[1] = "planty.color.default";
        stringArrayArray[3] = stringArray;
        String[] stringArray2 = new String[3];
        stringArray2[0] = AntPreferencesMessages.getString("AntEditorPreferencePage.Ant_editor_processing_instuctions_2");
        stringArray2[1] = "planty.color.instr";
        stringArrayArray[4] = stringArray2;
        String[] stringArray3 = new String[3];
        stringArray3[0] = AntPreferencesMessages.getString("AntEditorPreferencePage.Ant_editor_constant_strings_3");
        stringArray3[1] = "planty.color.string";
        stringArrayArray[5] = stringArray3;
        String[] stringArray4 = new String[3];
        stringArray4[0] = AntPreferencesMessages.getString("AntEditorPreferencePage.Ant_editor_tags_4");
        stringArray4[1] = "planty.color.tag";
        stringArrayArray[6] = stringArray4;
        String[] stringArray5 = new String[3];
        stringArray5[0] = AntPreferencesMessages.getString("AntEditorPreferencePage.Ant_editor_comments_5");
        stringArray5[1] = "planty.color.xml_comment";
        stringArrayArray[7] = stringArray5;
        this.fAppearanceColorListModel = stringArrayArray;
        this.fAnnotationColorListModel = new String[][]{{AntPreferencesMessages.getString("AntEditorPreferencePage.annotations.errors"), "problemIndicationColor", "problemIndication", "errorIndicationInOverviewRuler"}, {AntPreferencesMessages.getString("AntEditorPreferencePage.annotations.warnings"), "warningIndicationColor", "warningIndication", "warningIndicationInOverviewRuler"}, {AntPreferencesMessages.getString("AntEditorPreferencePage.annotations.infos"), "infoIndicationColor", "infoIndication", "infoIndicationInOverviewRuler"}, {AntPreferencesMessages.getString("AntEditorPreferencePage.annotations.tasks"), "taskIndicationColor", "taskIndication", "taskIndicationInOverviewRuler"}, {AntPreferencesMessages.getString("AntEditorPreferencePage.annotations.searchResults"), "searchResultIndicationColor", "searchResultIndication", "searchResultIndicationInOverviewRuler"}, {AntPreferencesMessages.getString("AntEditorPreferencePage.annotations.bookmarks"), "bookmarkIndicationColor", "bookmarkIndication", "bookmarkIndicationInOverviewRuler"}, {AntPreferencesMessages.getString("AntEditorPreferencePage.annotations.others"), "othersIndicationColor", "othersIndication", "othersIndicationInOverviewRuler"}};
        this.fCheckBoxes = new HashMap();
        this.fCheckBoxListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                AntEditorPreferencePage.this.fOverlayStore.setValue((String)AntEditorPreferencePage.this.fCheckBoxes.get(button), button.getSelection());
            }
        };
        this.fTextFields = new HashMap();
        this.fTextFieldListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.widget;
                AntEditorPreferencePage.this.fOverlayStore.setValue((String)AntEditorPreferencePage.this.fTextFields.get(text), text.getText());
            }
        };
        this.fNumberFields = new ArrayList();
        this.fNumberFieldListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AntEditorPreferencePage.this.numberFieldChanged((Text)e.widget);
            }
        };
        this.setDescription(AntPreferencesMessages.getString("AntEditorPreferencePage.description"));
        this.setPreferenceStore(ExternalToolsPlugin.getDefault().getPreferenceStore());
        this.fOverlayStore = new OverlayPreferenceStore(this.getPreferenceStore(), this.fKeys);
    }

    public void init(IWorkbench workbench) {
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.ui.externaltools.ant_editor_preference_page_context");
    }

    private void handleAppearanceColorListSelection() {
        int i = this.fAppearanceColorList.getSelectionIndex();
        String key = this.fAppearanceColorListModel[i][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)key);
        this.fAppearanceColorEditor.setColorValue(rgb);
    }

    private void handleAnnotationListSelection() {
        int i = this.fAnnotationList.getSelectionIndex();
        String key = this.fAnnotationColorListModel[i][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)key);
        this.fAnnotationForegroundColorEditor.setColorValue(rgb);
        key = this.fAnnotationColorListModel[i][2];
        this.fShowInTextCheckBox.setSelection(this.fOverlayStore.getBoolean(key));
        key = this.fAnnotationColorListModel[i][3];
        this.fShowInOverviewRulerCheckBox.setSelection(this.fOverlayStore.getBoolean(key));
    }

    private Control createAppearancePage(Composite parent) {
        Composite appearanceComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        appearanceComposite.setLayout((Layout)layout);
        String label = AntPreferencesMessages.getString("AntEditorPreferencePage.printMarginColumn");
        this.addTextField(appearanceComposite, label, "printMarginColumn", 3, 0, true);
        label = AntPreferencesMessages.getString("AntEditorPreferencePage.showOverviewRuler");
        this.addCheckBox(appearanceComposite, label, "overviewRuler", 0);
        label = AntPreferencesMessages.getString("AntEditorPreferencePage.showLineNumbers");
        this.addCheckBox(appearanceComposite, label, "lineNumberRuler", 0);
        label = AntPreferencesMessages.getString("AntEditorPreferencePage.highlightCurrentLine");
        this.addCheckBox(appearanceComposite, label, "currentLine", 0);
        label = AntPreferencesMessages.getString("AntEditorPreferencePage.showPrintMargin");
        this.addCheckBox(appearanceComposite, label, "printMargin", 0);
        Label l = new Label(appearanceComposite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = this.convertHeightInCharsToPixels(1) / 2;
        l.setLayoutData((Object)gd);
        l = new Label(appearanceComposite, 16384);
        l.setText(AntPreferencesMessages.getString("AntEditorPreferencePage.appearanceOptions"));
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        Composite editorComposite = new Composite(appearanceComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(1296);
        gd.horizontalSpan = 2;
        editorComposite.setLayoutData((Object)gd);
        this.fAppearanceColorList = new List(editorComposite, 2564);
        gd = new GridData(770);
        gd.heightHint = this.convertHeightInCharsToPixels(8);
        this.fAppearanceColorList.setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        l = new Label(stylesComposite, 16384);
        l.setText(AntPreferencesMessages.getString("AntEditorPreferencePage.color"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        l.setLayoutData((Object)gd);
        this.fAppearanceColorEditor = new ColorEditor(stylesComposite);
        Button foregroundColorButton = this.fAppearanceColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        this.fAppearanceColorList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AntEditorPreferencePage.this.handleAppearanceColorListSelection();
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = AntEditorPreferencePage.this.fAppearanceColorList.getSelectionIndex();
                String key = AntEditorPreferencePage.this.fAppearanceColorListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)AntEditorPreferencePage.this.fOverlayStore, (String)key, (RGB)AntEditorPreferencePage.this.fAppearanceColorEditor.getColorValue());
            }
        });
        return appearanceComposite;
    }

    private Control createAnnotationsPage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 16384);
        label.setText(AntPreferencesMessages.getString("AntEditorPreferencePage.annotationPresentationOptions"));
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        Composite editorComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(1296);
        gd.horizontalSpan = 2;
        editorComposite.setLayoutData((Object)gd);
        this.fAnnotationList = new List(editorComposite, 2564);
        gd = new GridData(770);
        gd.heightHint = this.convertHeightInCharsToPixels(8);
        this.fAnnotationList.setLayoutData((Object)gd);
        Composite optionsComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        optionsComposite.setLayout((Layout)layout);
        optionsComposite.setLayoutData((Object)new GridData(1808));
        this.fShowInTextCheckBox = new Button(optionsComposite, 32);
        this.fShowInTextCheckBox.setText(AntPreferencesMessages.getString("AntEditorPreferencePage.annotations.showInText"));
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fShowInTextCheckBox.setLayoutData((Object)gd);
        this.fShowInOverviewRulerCheckBox = new Button(optionsComposite, 32);
        this.fShowInOverviewRulerCheckBox.setText(AntPreferencesMessages.getString("AntEditorPreferencePage.annotations.showInOverviewRuler"));
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fShowInOverviewRulerCheckBox.setLayoutData((Object)gd);
        label = new Label(optionsComposite, 16384);
        label.setText(AntPreferencesMessages.getString("AntEditorPreferencePage.annotations.color"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fAnnotationForegroundColorEditor = new ColorEditor(optionsComposite);
        Button foregroundColorButton = this.fAnnotationForegroundColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        this.fAnnotationList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AntEditorPreferencePage.this.handleAnnotationListSelection();
            }
        });
        this.fShowInTextCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = AntEditorPreferencePage.this.fAnnotationList.getSelectionIndex();
                String key = AntEditorPreferencePage.this.fAnnotationColorListModel[i][2];
                AntEditorPreferencePage.this.fOverlayStore.setValue(key, AntEditorPreferencePage.this.fShowInTextCheckBox.getSelection());
            }
        });
        this.fShowInOverviewRulerCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = AntEditorPreferencePage.this.fAnnotationList.getSelectionIndex();
                String key = AntEditorPreferencePage.this.fAnnotationColorListModel[i][3];
                AntEditorPreferencePage.this.fOverlayStore.setValue(key, AntEditorPreferencePage.this.fShowInOverviewRulerCheckBox.getSelection());
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = AntEditorPreferencePage.this.fAnnotationList.getSelectionIndex();
                String key = AntEditorPreferencePage.this.fAnnotationColorListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)AntEditorPreferencePage.this.fOverlayStore, (String)key, (RGB)AntEditorPreferencePage.this.fAnnotationForegroundColorEditor.getColorValue());
            }
        });
        return composite;
    }

    protected Control createContents(Composite parent) {
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        TabItem item = new TabItem(folder, 0);
        item.setText(AntPreferencesMessages.getString("AntEditorPreferencePage.general"));
        item.setControl(this.createAppearancePage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(AntPreferencesMessages.getString("AntEditorPreferencePage.annotationsTab.title"));
        item.setControl(this.createAnnotationsPage((Composite)folder));
        this.initialize();
        return folder;
    }

    private void initialize() {
        this.initializeFields();
        int i = 0;
        while (i < this.fAppearanceColorListModel.length) {
            this.fAppearanceColorList.add(this.fAppearanceColorListModel[i][0]);
            ++i;
        }
        this.fAppearanceColorList.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (AntEditorPreferencePage.this.fAppearanceColorList != null && !AntEditorPreferencePage.this.fAppearanceColorList.isDisposed()) {
                    AntEditorPreferencePage.this.fAppearanceColorList.select(0);
                    AntEditorPreferencePage.this.handleAppearanceColorListSelection();
                }
            }
        });
        i = 0;
        while (i < this.fAnnotationColorListModel.length) {
            this.fAnnotationList.add(this.fAnnotationColorListModel[i][0]);
            ++i;
        }
        this.fAnnotationList.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (AntEditorPreferencePage.this.fAnnotationList != null && !AntEditorPreferencePage.this.fAnnotationList.isDisposed()) {
                    AntEditorPreferencePage.this.fAnnotationList.select(0);
                    AntEditorPreferencePage.this.handleAnnotationListSelection();
                }
            }
        });
    }

    private void initializeFields() {
        String key;
        Iterator e = this.fCheckBoxes.keySet().iterator();
        while (e.hasNext()) {
            Button b = (Button)e.next();
            key = (String)this.fCheckBoxes.get(b);
            b.setSelection(this.fOverlayStore.getBoolean(key));
        }
        e = this.fTextFields.keySet().iterator();
        while (e.hasNext()) {
            Text t = (Text)e.next();
            key = (String)this.fTextFields.get(t);
            t.setText(this.fOverlayStore.getString(key));
        }
    }

    public boolean performOk() {
        this.fOverlayStore.propagate();
        ExternalToolsPlugin.getDefault().savePluginPreferences();
        return true;
    }

    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initializeFields();
        this.handleAppearanceColorListSelection();
        this.handleAnnotationListSelection();
        super.performDefaults();
    }

    public void dispose() {
        if (this.fOverlayStore != null) {
            this.fOverlayStore.stop();
            this.fOverlayStore = null;
        }
        super.dispose();
    }

    private Button addCheckBox(Composite parent, String label, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(checkBox, key);
        return checkBox;
    }

    private Control addTextField(Composite composite, String label, String key, int textLimit, int indentation, boolean isNumber) {
        Label labelControl = new Label(composite, 0);
        labelControl.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        labelControl.setLayoutData((Object)gd);
        Text textControl = new Text(composite, 2052);
        gd = new GridData(32);
        gd.widthHint = this.convertWidthInCharsToPixels(textLimit + 1);
        textControl.setLayoutData((Object)gd);
        textControl.setTextLimit(textLimit);
        this.fTextFields.put(textControl, key);
        if (isNumber) {
            this.fNumberFields.add(textControl);
            textControl.addModifyListener(this.fNumberFieldListener);
        } else {
            textControl.addModifyListener(this.fTextFieldListener);
        }
        return textControl;
    }

    private void numberFieldChanged(Text textControl) {
        String number = textControl.getText();
        IStatus status = this.validatePositiveNumber(number);
        if (!status.matches(4)) {
            this.fOverlayStore.setValue((String)this.fTextFields.get(textControl), number);
        }
        this.updateStatus(status);
    }

    private IStatus validatePositiveNumber(String number) {
        StatusInfo status = new StatusInfo();
        if (number.length() == 0) {
            status.setError(AntPreferencesMessages.getString("AntEditorPreferencePage.empty_input"));
        } else {
            try {
                int value = Integer.parseInt(number);
                if (value < 0) {
                    status.setError(AntPreferencesMessages.getFormattedString("AntEditorPreferencePage.invalid_input", number));
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.setError(AntPreferencesMessages.getFormattedString("AntEditorPreferencePage.invalid_input", number));
            }
        }
        return status;
    }

    void updateStatus(IStatus status) {
        if (!status.matches(4)) {
            int i = 0;
            while (i < this.fNumberFields.size()) {
                Text text = (Text)this.fNumberFields.get(i);
                IStatus s = this.validatePositiveNumber(text.getText());
                status = s.getSeverity() > status.getSeverity() ? s : status;
                ++i;
            }
        }
        this.setValid(!status.matches(4));
        this.applyToStatusLine((DialogPage)this, status);
    }

    public void applyToStatusLine(DialogPage page, IStatus status) {
        String message = status.getMessage();
        switch (status.getSeverity()) {
            case 0: {
                page.setMessage(message, 0);
                page.setErrorMessage(null);
                break;
            }
            case 2: {
                page.setMessage(message, 2);
                page.setErrorMessage(null);
                break;
            }
            case 1: {
                page.setMessage(message, 1);
                page.setErrorMessage(null);
                break;
            }
            default: {
                if (message.length() == 0) {
                    message = null;
                }
                page.setMessage(null);
                page.setErrorMessage(message);
            }
        }
    }
}

