/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.externaltools.internal.ant.preferences.AntClasspathBlock;
import org.eclipse.ui.externaltools.internal.ant.preferences.AntPreferencesMessages;
import org.eclipse.ui.externaltools.internal.ant.preferences.AntRuntimePreferencePage;
import org.eclipse.ui.externaltools.internal.ant.preferences.IAntBlockContainer;
import org.eclipse.ui.help.WorkbenchHelp;

public class AntClasspathPage
implements IAntBlockContainer {
    private AntClasspathBlock antClasspathBlock = new AntClasspathBlock();
    private AntRuntimePreferencePage preferencePage;

    public AntClasspathPage(AntRuntimePreferencePage preferencePage) {
        this.preferencePage = preferencePage;
    }

    protected List getUserURLs() {
        return this.antClasspathBlock.getUserURLs();
    }

    protected List getAntURLs() {
        return this.antClasspathBlock.getAntURLs();
    }

    protected String getAntHome() {
        return this.antClasspathBlock.getAntHome();
    }

    protected void initialize() {
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        this.antClasspathBlock.setAntTableInput(prefs.getAntURLs());
        this.antClasspathBlock.setUserTableInput(Arrays.asList(prefs.getCustomURLs()));
        this.antClasspathBlock.setEnabled(true);
        String antHomeString = prefs.getAntHome();
        if (antHomeString != null && antHomeString.length() == 0) {
            antHomeString = null;
        }
        this.antClasspathBlock.initializeAntHome(antHomeString);
        this.preferencePage.setErrorMessage(null);
        this.preferencePage.setValid(true);
    }

    protected void performDefaults() {
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        this.antClasspathBlock.setAntTableInput(Arrays.asList(prefs.getDefaultAntURLs()));
        this.antClasspathBlock.setUserTableInput(new ArrayList(0));
        this.antClasspathBlock.initializeAntHome(null);
        this.antClasspathBlock.setEnabled(true);
        this.update();
    }

    protected TabItem createTabItem(TabFolder folder) {
        TabItem item = new TabItem(folder, 0);
        item.setText(AntPreferencesMessages.getString("AntClasspathPage.title"));
        item.setImage(this.antClasspathBlock.getClasspathImage());
        item.setData((Object)this);
        item.setControl((Control)this.createContents((Composite)folder));
        return item;
    }

    protected Composite createContents(Composite parent) {
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.ui.externaltools.ant_classpath_page_context");
        Font font = parent.getFont();
        Composite top = new Composite(parent, 0);
        top.setFont(font);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(1808));
        this.antClasspathBlock.setContainer(this);
        this.antClasspathBlock.createContents(top);
        return top;
    }

    public void update() {
        this.setMessage(null);
        this.setErrorMessage(null);
        boolean valid = true;
        if (this.antClasspathBlock.isAntHomeEnabled()) {
            valid = this.antClasspathBlock.validateAntHome();
        }
        this.preferencePage.setValid(valid);
    }

    public void setMessage(String message) {
        this.preferencePage.setMessage(message);
    }

    public void setErrorMessage(String message) {
        this.preferencePage.setErrorMessage(message);
    }

    public Button createPushButton(Composite parent, String buttonText) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(buttonText);
        this.preferencePage.setButtonLayoutData(button);
        return button;
    }
}

