/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.preferences;

import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;

public class AntClasspathLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final String IMG_JAR_FILE = "icons/full/obj16/jar_l_obj.gif";
    private static final String IMG_CLASSPATH = "icons/full/obj16/classpath.gif";
    private Image classpathImage;
    private Image folderImage;
    private Image jarImage;

    public void dispose() {
        this.folderImage = null;
        if (this.jarImage != null) {
            this.jarImage.dispose();
            this.jarImage = null;
        }
        if (this.classpathImage != null) {
            this.classpathImage.dispose();
            this.classpathImage = null;
        }
    }

    public Image getColumnImage(Object element, int columnIndex) {
        URL url = (URL)element;
        if (url.getFile().endsWith("/")) {
            return this.getFolderImage();
        }
        return this.getJarImage();
    }

    public String getColumnText(Object element, int columnIndex) {
        return ((URL)element).getFile();
    }

    private Image getFolderImage() {
        if (this.folderImage == null) {
            this.folderImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        return this.folderImage;
    }

    private Image getJarImage() {
        if (this.jarImage == null) {
            ImageDescriptor desc = ExternalToolsPlugin.getDefault().getImageDescriptor(IMG_JAR_FILE);
            this.jarImage = desc.createImage();
        }
        return this.jarImage;
    }

    public Image getClasspathImage() {
        if (this.classpathImage == null) {
            ImageDescriptor desc = ExternalToolsPlugin.getDefault().getImageDescriptor(IMG_CLASSPATH);
            this.classpathImage = desc.createImage();
        }
        return this.classpathImage;
    }
}

