/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.preferences;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.externaltools.internal.ant.preferences.AntClasspathContentProvider;
import org.eclipse.ui.externaltools.internal.ant.preferences.AntClasspathLabelProvider;
import org.eclipse.ui.externaltools.internal.ant.preferences.AntPreferencesMessages;
import org.eclipse.ui.externaltools.internal.ant.preferences.IAntBlockContainer;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;
import org.eclipse.ui.externaltools.internal.ui.ExternalToolsContentProvider;

public class AntClasspathBlock {
    private TableViewer antTableViewer;
    private ExternalToolsContentProvider antContentProvider;
    private TableViewer userTableViewer;
    private ExternalToolsContentProvider userContentProvider;
    private Button upButton;
    private Button downButton;
    private Button removeButton;
    private Button upUserButton;
    private Button downUserButton;
    private Button removeUserButton;
    private final AntClasspathLabelProvider labelProvider = new AntClasspathLabelProvider();
    private Button addUserJarButton;
    private Button addUserFolderButtton;
    private Button addFolderButtton;
    private Button addJarButton;
    private Button antHomeButton;
    private Text antHome;
    private Button browseAntHomeButton;
    private final IDialogSettings dialogSettings = ExternalToolsPlugin.getDefault().getDialogSettings();
    private boolean initializing = true;
    private IAntBlockContainer container;
    private boolean tablesEnabled = true;

    public void setContainer(IAntBlockContainer container) {
        this.container = container;
    }

    private void addButtonsToButtonGroup(Composite parent) {
        if (this.addJarButton == null) {
            this.addJarButton = this.container.createPushButton(parent, AntPreferencesMessages.getString("AntClasspathBlock.addJarButtonTitle"));
            this.addJarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    AntClasspathBlock.this.addJars(AntClasspathBlock.this.antTableViewer);
                }
            });
            this.addFolderButtton = this.container.createPushButton(parent, AntPreferencesMessages.getString("AntClasspathBlock.addFolderButtonTitle"));
            this.addFolderButtton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    AntClasspathBlock.this.addFolder(AntClasspathBlock.this.antTableViewer, AntPreferencesMessages.getString("AntClasspathBlock.&Choose_a_folder_to_add_to_the_classpath__1"));
                }
            });
            this.upButton = this.container.createPushButton(parent, AntPreferencesMessages.getString("AntClasspathBlock.upButtonTitle"));
            this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    AntClasspathBlock.this.handleMove(-1, AntClasspathBlock.this.antTableViewer);
                }
            });
            this.downButton = this.container.createPushButton(parent, AntPreferencesMessages.getString("AntClasspathBlock.downButtonTitle"));
            this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    AntClasspathBlock.this.handleMove(1, AntClasspathBlock.this.antTableViewer);
                }
            });
            this.removeButton = this.container.createPushButton(parent, AntPreferencesMessages.getString("AntClasspathBlock.removeButtonTitle"));
            this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    AntClasspathBlock.this.remove(AntClasspathBlock.this.antTableViewer);
                }
            });
        } else {
            this.addUserJarButton = this.container.createPushButton(parent, AntPreferencesMessages.getString("AntClasspathBlock.addJarButtonTitle2"));
            this.addUserJarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    AntClasspathBlock.this.addJars(AntClasspathBlock.this.userTableViewer);
                }
            });
            this.addUserFolderButtton = this.container.createPushButton(parent, AntPreferencesMessages.getString("AntClasspathBlock.addFolderButtonTitle2"));
            this.addUserFolderButtton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    AntClasspathBlock.this.addFolder(AntClasspathBlock.this.userTableViewer, AntPreferencesMessages.getString("AntClasspathBlock.&Choose_a_folder_to_add_to_the_classpath__1"));
                }
            });
            this.upUserButton = this.container.createPushButton(parent, AntPreferencesMessages.getString("AntClasspathBlock.upButtonTitle2"));
            this.upUserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    AntClasspathBlock.this.handleMove(-1, AntClasspathBlock.this.userTableViewer);
                }
            });
            this.downUserButton = this.container.createPushButton(parent, AntPreferencesMessages.getString("AntClasspathBlock.downButtonTitle2"));
            this.downUserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    AntClasspathBlock.this.handleMove(1, AntClasspathBlock.this.userTableViewer);
                }
            });
            this.removeUserButton = this.container.createPushButton(parent, AntPreferencesMessages.getString("AntClasspathBlock.removeButtonTitle2"));
            this.removeUserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    AntClasspathBlock.this.remove(AntClasspathBlock.this.userTableViewer);
                }
            });
        }
    }

    private void handleMove(int direction, TableViewer viewer) {
        Object config;
        IStructuredSelection sel = (IStructuredSelection)viewer.getSelection();
        List selList = sel.toList();
        Object[] elements = ((ExternalToolsContentProvider)viewer.getContentProvider()).getElements(viewer.getInput());
        ArrayList<Object> contents = new ArrayList<Object>(elements.length);
        int i = 0;
        while (i < elements.length) {
            contents.add(elements[i]);
            ++i;
        }
        Object[] moved = new Object[contents.size()];
        Iterator current = selList.iterator();
        while (current.hasNext()) {
            config = current.next();
            int i2 = contents.indexOf(config);
            moved[i2 + direction] = config;
        }
        contents.removeAll(selList);
        int j = 0;
        while (j < moved.length) {
            config = moved[j];
            if (config != null) {
                contents.add(j, config);
            }
            ++j;
        }
        viewer.setInput(contents);
        viewer.setSelection(viewer.getSelection());
        this.container.update();
    }

    private void remove(TableViewer viewer) {
        ExternalToolsContentProvider antContentProvider = (ExternalToolsContentProvider)viewer.getContentProvider();
        IStructuredSelection sel = (IStructuredSelection)viewer.getSelection();
        Iterator iterator = sel.iterator();
        while (iterator.hasNext()) {
            antContentProvider.remove(iterator.next());
        }
        this.container.update();
    }

    private void addFolder(TableViewer viewer, String message) {
        String lastUsedPath = this.dialogSettings.get("org.eclipse.ui.externaltools.lastfolder");
        if (lastUsedPath == null) {
            lastUsedPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        }
        DirectoryDialog dialog = new DirectoryDialog(this.antTableViewer.getControl().getShell());
        dialog.setMessage(message);
        dialog.setFilterPath(lastUsedPath);
        String result = dialog.open();
        if (result != null) {
            try {
                URL url = new URL("file:" + result + "/");
                ((ExternalToolsContentProvider)viewer.getContentProvider()).add(url);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        viewer.setSelection(viewer.getSelection());
        this.dialogSettings.put("org.eclipse.ui.externaltools.lastfolder", result);
        this.container.update();
    }

    private void addJars(TableViewer viewer) {
        String lastUsedPath = this.dialogSettings.get("org.eclipse.ui.externaltools.lastextjar");
        if (lastUsedPath == null) {
            lastUsedPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        }
        FileDialog dialog = new FileDialog(this.antTableViewer.getControl().getShell(), 2);
        dialog.setFilterExtensions(new String[]{"*.jar"});
        dialog.setFilterPath(lastUsedPath);
        String result = dialog.open();
        if (result == null) {
            return;
        }
        Path filterPath = new Path(dialog.getFilterPath());
        String[] results = dialog.getFileNames();
        int i = 0;
        while (i < results.length) {
            String jarName = results[i];
            try {
                IPath path = filterPath.append(jarName).makeAbsolute();
                URL url = new URL("file:" + path.toOSString());
                ((ExternalToolsContentProvider)viewer.getContentProvider()).add(url);
            }
            catch (MalformedURLException malformedURLException) {}
            ++i;
        }
        viewer.setSelection(viewer.getSelection());
        this.dialogSettings.put("org.eclipse.ui.externaltools.lastextjar", filterPath.toOSString());
        this.container.update();
    }

    private void createButtonGroup(Composite top) {
        Composite buttonGroup = new Composite(top, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonGroup.setLayout((Layout)layout);
        buttonGroup.setLayoutData((Object)new GridData(1040));
        buttonGroup.setFont(top.getFont());
        this.addButtonsToButtonGroup(buttonGroup);
    }

    private void createAntTable(Composite parent) {
        Table table = new Table(parent, 67586);
        GridData data = new GridData(1808);
        data.widthHint = 200;
        data.heightHint = table.getItemHeight();
        data.horizontalSpan = 1;
        table.setLayoutData((Object)data);
        table.setFont(parent.getFont());
        this.antContentProvider = new AntClasspathContentProvider();
        this.antTableViewer = new TableViewer(table);
        this.antTableViewer.setContentProvider((IContentProvider)this.antContentProvider);
        this.antTableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.antTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (AntClasspathBlock.this.tablesEnabled) {
                    AntClasspathBlock.this.tableSelectionChanged((IStructuredSelection)event.getSelection(), (ExternalToolsContentProvider)AntClasspathBlock.this.antTableViewer.getContentProvider(), false);
                }
            }
        });
    }

    public void createContents(Composite parent) {
        Font font = parent.getFont();
        Label label = new Label(parent, 0);
        GridData gd = new GridData(32);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        label.setFont(font);
        label.setText(AntPreferencesMessages.getString("AntClasspathBlock.Run&time_classpath__8"));
        this.createAntTable(parent);
        this.createButtonGroup(parent);
        this.createSeparator(parent);
        this.createAntHome(parent);
        label = new Label(parent, 0);
        gd = new GridData(32);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        label.setFont(font);
        label.setText(AntPreferencesMessages.getString("AntClasspathBlock.Additional_classpath_entries__11"));
        this.createUserTable(parent);
        this.createButtonGroup(parent);
    }

    private void createUserTable(Composite top) {
        Table table = new Table(top, 67586);
        GridData data = new GridData(1808);
        data.widthHint = 200;
        data.heightHint = table.getItemHeight();
        data.horizontalSpan = 1;
        table.setLayoutData((Object)data);
        table.setFont(top.getFont());
        this.userContentProvider = new AntClasspathContentProvider();
        this.userTableViewer = new TableViewer(table);
        this.userTableViewer.setContentProvider((IContentProvider)this.userContentProvider);
        this.userTableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.userTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (AntClasspathBlock.this.tablesEnabled) {
                    AntClasspathBlock.this.tableSelectionChanged((IStructuredSelection)event.getSelection(), (ExternalToolsContentProvider)AntClasspathBlock.this.userTableViewer.getContentProvider(), true);
                }
            }
        });
    }

    private Label createSeparator(Composite parent) {
        Label separator = new Label(parent, 0);
        GridData gd = new GridData(258);
        gd.heightHint = 4;
        gd.horizontalSpan = 2;
        separator.setLayoutData((Object)gd);
        return separator;
    }

    private void createAntHome(Composite top) {
        Composite antHomeComposite = new Composite(top, 0);
        antHomeComposite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        antHomeComposite.setLayout((Layout)layout);
        antHomeComposite.setFont(top.getFont());
        this.antHomeButton = new Button(antHomeComposite, 32);
        this.antHomeButton.setFont(top.getFont());
        this.antHomeButton.setText(AntPreferencesMessages.getString("AntClasspathBlock.Set_ANT_HO&ME_9"));
        this.antHomeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                AntClasspathBlock.this.specifyAntHome();
            }
        });
        this.antHome = new Text(antHomeComposite, 2048);
        GridData gd = new GridData(768);
        gd.widthHint = 200;
        this.antHome.setLayoutData((Object)gd);
        this.antHome.setFont(top.getFont());
        this.antHome.setEnabled(false);
        this.antHome.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                File rootDir;
                if (AntClasspathBlock.this.initializing) {
                    return;
                }
                String path = AntClasspathBlock.this.antHome.getText();
                if (path.length() > 0 && (rootDir = new File(path, "lib")).exists()) {
                    AntClasspathBlock.this.setAntHome(rootDir);
                }
                AntClasspathBlock.this.container.update();
            }
        });
        this.browseAntHomeButton = this.container.createPushButton(top, AntPreferencesMessages.getString("AntClasspathBlock.&Browse..._10"));
        this.browseAntHomeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AntClasspathBlock.this.browseAntHome();
            }
        });
        this.browseAntHomeButton.setEnabled(false);
    }

    private void tableSelectionChanged(IStructuredSelection selection, ExternalToolsContentProvider contentProvider, boolean user) {
        Object[] elements = contentProvider.getElements(null);
        List<Object> urls = Arrays.asList(elements);
        boolean notEmpty = !selection.isEmpty();
        Iterator selected = selection.iterator();
        boolean first = false;
        boolean last = false;
        int lastUrl = urls.size() - 1;
        while (selected.hasNext()) {
            Object element = selected.next();
            if (!first && urls.indexOf(element) == 0) {
                first = true;
            }
            if (last || urls.indexOf(element) != lastUrl) continue;
            last = true;
        }
        if (user) {
            this.removeUserButton.setEnabled(notEmpty);
            this.upUserButton.setEnabled(notEmpty && !first);
            this.downUserButton.setEnabled(notEmpty && !last);
        } else {
            this.removeButton.setEnabled(notEmpty);
            this.upButton.setEnabled(notEmpty && !first);
            this.downButton.setEnabled(notEmpty && !last);
        }
    }

    private void specifyAntHome() {
        this.antHome.setEnabled(!this.antHome.getEnabled());
        this.browseAntHomeButton.setEnabled(!this.browseAntHomeButton.getEnabled());
        if (this.antHome.isEnabled()) {
            File rootDir = this.validateAntHome(this.antHome.getText());
            if (rootDir != null) {
                this.setAntHome(rootDir);
            }
        } else {
            this.container.setMessage(null);
            this.container.setErrorMessage(null);
        }
        this.container.update();
    }

    private File validateAntHome(String path) {
        File rootDir = null;
        if (path.length() > 0) {
            rootDir = new File(path, "lib");
            if (!rootDir.exists()) {
                this.container.setErrorMessage(AntPreferencesMessages.getString("AntClasspathBlock.Specified_ANT_HOME_does_not_contain_a___lib___directory_7"));
                return null;
            }
        } else {
            this.container.setErrorMessage(AntPreferencesMessages.getString("AntClasspathBlock.Specified_ANT_HOME_does_not_contain_a___lib___directory_7"));
            return null;
        }
        this.container.setErrorMessage(null);
        return rootDir;
    }

    private void browseAntHome() {
        String lastUsedPath = this.dialogSettings.get("org.eclipse.ui.externaltools.lastanthome");
        if (lastUsedPath == null) {
            lastUsedPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        }
        DirectoryDialog dialog = new DirectoryDialog(this.antTableViewer.getControl().getShell());
        dialog.setMessage(AntPreferencesMessages.getString("AntClasspathBlock.&Choose_a_folder_that_will_be_used_as_the_location_of_ANT_HOME_3"));
        dialog.setFilterPath(lastUsedPath);
        String path = dialog.open();
        if (path == null) {
            return;
        }
        this.antHome.setText(path);
        this.dialogSettings.put("org.eclipse.ui.externaltools.lastanthome", path);
        this.container.update();
    }

    private void setAntHome(File rootDir) {
        AntClasspathContentProvider contentProvider = (AntClasspathContentProvider)this.antTableViewer.getContentProvider();
        contentProvider.removeAll();
        String[] names = rootDir.list();
        int i = 0;
        while (i < names.length) {
            File file = new File(rootDir, names[i]);
            if (file.isFile() && file.getPath().endsWith(".jar")) {
                try {
                    Path jarPath = new Path(file.getAbsolutePath());
                    URL url = new URL("file:" + jarPath.toOSString());
                    contentProvider.add(url);
                }
                catch (MalformedURLException malformedURLException) {}
            }
            ++i;
        }
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        URL url = prefs.getToolsJarURL();
        if (url != null) {
            contentProvider.add(url);
        }
        this.container.update();
    }

    public List getAntURLs() {
        Object[] elements = this.antContentProvider.getElements(null);
        return Arrays.asList(elements);
    }

    public List getUserURLs() {
        Object[] elements = this.userContentProvider.getElements(null);
        return Arrays.asList(elements);
    }

    public String getAntHome() {
        String antHomeText = this.antHome.getText().trim();
        if (!this.antHomeButton.getSelection() || antHomeText.length() == 0) {
            antHomeText = null;
        }
        return antHomeText;
    }

    public void setEnabled(boolean enable) {
        this.setTablesEnabled(enable);
        this.antHomeButton.setEnabled(enable);
        this.addFolderButtton.setEnabled(enable);
        this.addJarButton.setEnabled(enable);
        this.addUserJarButton.setEnabled(enable);
        this.addUserFolderButtton.setEnabled(enable);
        if (enable) {
            this.antTableViewer.setSelection(this.antTableViewer.getSelection());
            this.userTableViewer.setSelection(this.userTableViewer.getSelection());
        } else {
            this.antHomeButton.setSelection(false);
            this.antHome.setEnabled(false);
            this.browseAntHomeButton.setEnabled(false);
            this.downButton.setEnabled(false);
            this.downUserButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.removeUserButton.setEnabled(false);
            this.upButton.setEnabled(false);
            this.upUserButton.setEnabled(false);
            AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
            this.antTableViewer.setInput((Object)prefs.getAntURLs());
            this.userTableViewer.setInput((Object)prefs.getCustomURLs());
        }
    }

    public void initializeAntHome(String antHomeString) {
        this.antHomeButton.setSelection(antHomeString != null);
        this.antHome.setEnabled(antHomeString != null);
        this.browseAntHomeButton.setEnabled(antHomeString != null);
        if (antHomeString != null) {
            this.antHome.setText(antHomeString);
        } else {
            this.antHome.setText("");
        }
        this.initializing = false;
    }

    public void setUserTableInput(Object input) {
        this.userTableViewer.setInput(input);
    }

    public void setAntTableInput(Object input) {
        this.antTableViewer.setInput(input);
    }

    public boolean isAntHomeEnabled() {
        return this.antHome.isEnabled();
    }

    public boolean validateAntHome() {
        return this.validateAntHome(this.antHome.getText()) != null;
    }

    public Image getClasspathImage() {
        return this.labelProvider.getClasspathImage();
    }

    public void setTablesEnabled(boolean tablesEnabled) {
        this.tablesEnabled = tablesEnabled;
    }
}

