/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.preferences;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.externaltools.internal.ant.preferences.AntPreferencesMessages;
import org.eclipse.ui.externaltools.internal.ant.preferences.MinimizedFileSystemElement;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;
import org.eclipse.ui.externaltools.internal.ui.StatusDialog;
import org.eclipse.ui.externaltools.internal.ui.StatusInfo;
import org.eclipse.ui.externaltools.internal.ui.TreeAndListGroup;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.model.WorkbenchViewerSorter;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;

public class AddCustomDialog
extends StatusDialog {
    private ZipFileStructureProvider providerCache;
    private IImportStructureProvider currentProvider;
    private boolean entryChanged = false;
    protected Combo sourceNameField;
    private String title;
    private String description;
    private List libraryUrls;
    private List existingNames;
    private TreeAndListGroup selectionGroup;
    protected Button sourceBrowseButton;
    private Text nameField;
    private String customLabel;
    private String name = "";
    private URL library = null;
    private String className = "";
    private boolean editing = false;

    public AddCustomDialog(Shell parent, List libraryUrls, List existingNames, String title, String description, String customLabel) {
        super(parent);
        this.title = title;
        this.description = description;
        this.libraryUrls = libraryUrls;
        this.existingNames = existingNames;
        this.customLabel = customLabel;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        dialogArea.setLayout((Layout)new GridLayout());
        dialogArea.setLayoutData((Object)new GridData(272));
        dialogArea.setSize(dialogArea.computeSize(-1, -1));
        dialogArea.setFont(parent.getFont());
        this.createNameGroup(dialogArea);
        new Label(dialogArea, 0);
        this.createRootDirectoryGroup(dialogArea);
        this.createFileSelectionGroup(dialogArea);
        if (this.library != null) {
            this.setSourceName(this.library.getFile());
        }
        return dialogArea;
    }

    private void createNameGroup(Composite dialogArea) {
        Composite nameContainerGroup = new Composite(dialogArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        nameContainerGroup.setLayout((Layout)layout);
        nameContainerGroup.setFont(dialogArea.getFont());
        nameContainerGroup.setLayoutData((Object)new GridData(768));
        Label label = new Label(nameContainerGroup, 0);
        label.setFont(dialogArea.getFont());
        label.setText(AntPreferencesMessages.getString("AddCustomDialog.&Name__3"));
        this.nameField = new Text(nameContainerGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.nameField.setLayoutData((Object)data);
        this.nameField.setFont(dialogArea.getFont());
        this.nameField.setText(this.name);
        this.nameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddCustomDialog.this.updateStatus();
            }
        });
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
        WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.ui.externaltools.add_custom_dialog_context");
    }

    protected void clearProviderCache() {
        if (this.providerCache != null) {
            this.closeZipFile(this.providerCache.getZipFile());
            this.providerCache = null;
        }
    }

    protected boolean closeZipFile(ZipFile file) {
        try {
            file.close();
        }
        catch (IOException e) {
            ExternalToolsPlugin.getDefault().log(MessageFormat.format(AntPreferencesMessages.getString("AddCustomDialog.Could_not_close_zip_file_{0}_4"), file.getName()), e);
            return false;
        }
        return true;
    }

    private void createRootDirectoryGroup(Composite parent) {
        Composite sourceContainerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        sourceContainerGroup.setLayout((Layout)layout);
        sourceContainerGroup.setFont(parent.getFont());
        sourceContainerGroup.setLayoutData((Object)new GridData(768));
        Label groupLabel = new Label(sourceContainerGroup, 0);
        groupLabel.setText(AntPreferencesMessages.getString("AddCustomDialog.&Location"));
        groupLabel.setFont(parent.getFont());
        this.sourceNameField = new Combo(sourceContainerGroup, 2056);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.sourceNameField.setLayoutData((Object)data);
        this.sourceNameField.setFont(parent.getFont());
        this.sourceNameField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddCustomDialog.this.updateFromSourceField();
            }
        });
        Iterator libraries = this.libraryUrls.iterator();
        while (libraries.hasNext()) {
            URL library = (URL)libraries.next();
            this.sourceNameField.add(library.getFile());
        }
        this.sourceNameField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                AddCustomDialog.this.entryChanged = true;
            }
        });
        this.sourceNameField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (AddCustomDialog.this.entryChanged) {
                    AddCustomDialog.this.entryChanged = false;
                    AddCustomDialog.this.updateFromSourceField();
                }
            }
        });
    }

    private void updateFromSourceField() {
        this.setSourceName(this.sourceNameField.getText());
        this.updateStatus();
    }

    private void updateStatus() {
        StatusInfo status = new StatusInfo();
        String name = this.nameField.getText().trim();
        if (name.length() == 0) {
            status.setError(MessageFormat.format(AntPreferencesMessages.getString("AddCustomDialog.name"), this.customLabel));
        } else if (!this.editing) {
            Iterator names = this.existingNames.iterator();
            while (names.hasNext()) {
                String aName = (String)names.next();
                if (!aName.equals(name)) continue;
                status.setError(MessageFormat.format(AntPreferencesMessages.getString("AddCustomDialog.exists"), this.customLabel, name));
                this.updateStatus(status);
                return;
            }
        }
        if (this.selectionGroup.getListTableSelection().isEmpty()) {
            status.setError(AntPreferencesMessages.getString("AddCustomDialog.mustSelect"));
        }
        this.updateStatus(status);
    }

    protected void setSourceName(String path) {
        if (path.length() > 0) {
            String[] currentItems = this.sourceNameField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(path)) {
                    selectionIndex = i;
                    break;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = path;
                this.sourceNameField.setItems(newItems);
                selectionIndex = oldLength;
            }
            this.sourceNameField.select(selectionIndex);
            this.resetSelection();
        }
    }

    protected void createFileSelectionGroup(Composite parent) {
        FileSystemElement dummyRoot = new FileSystemElement("Dummy", null, true);
        this.selectionGroup = new TreeAndListGroup(parent, dummyRoot, this.getFolderProvider(), (ILabelProvider)new WorkbenchLabelProvider(), (IStructuredContentProvider)this.getFileProvider(), (ILabelProvider)new WorkbenchLabelProvider(), 0, 400, 150);
        ISelectionChangedListener listener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddCustomDialog.this.updateStatus();
            }
        };
        WorkbenchViewerSorter sorter = new WorkbenchViewerSorter();
        this.selectionGroup.setTreeSorter((ViewerSorter)sorter);
        this.selectionGroup.setListSorter((ViewerSorter)sorter);
        this.selectionGroup.addSelectionChangedListener(listener);
        this.selectionGroup.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (AddCustomDialog.this.getButton(0).isEnabled()) {
                    AddCustomDialog.this.buttonPressed(0);
                }
            }
        });
    }

    protected boolean ensureSourceIsValid() {
        ZipFile specifiedFile = this.getSpecifiedSourceFile();
        if (specifiedFile == null) {
            return false;
        }
        return this.closeZipFile(specifiedFile);
    }

    protected MinimizedFileSystemElement getFileSystemTree() {
        ZipFileStructureProvider provider = null;
        MinimizedFileSystemElement element = null;
        ZipFile sourceFile = this.getSpecifiedSourceFile();
        if (sourceFile == null) {
            File file = new File(this.sourceNameField.getText());
            if (file.exists()) {
                provider = FileSystemStructureProvider.INSTANCE;
                element = this.selectFiles(file, (IImportStructureProvider)provider);
            }
        } else {
            provider = this.getStructureProvider(sourceFile);
            element = this.selectFiles(provider.getRoot(), (IImportStructureProvider)provider);
        }
        this.currentProvider = provider;
        return element;
    }

    protected MinimizedFileSystemElement selectFiles(final Object rootFileSystemObject, final IImportStructureProvider structureProvider) {
        final MinimizedFileSystemElement[] results = new MinimizedFileSystemElement[1];
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                results[0] = AddCustomDialog.this.createRootElement(rootFileSystemObject, structureProvider);
            }
        });
        return results[0];
    }

    protected MinimizedFileSystemElement createRootElement(Object fileSystemObject, IImportStructureProvider provider) {
        boolean isContainer = provider.isFolder(fileSystemObject);
        String elementLabel = provider.getLabel(fileSystemObject);
        MinimizedFileSystemElement dummyParent = new MinimizedFileSystemElement("", null, true);
        dummyParent.setPopulated();
        MinimizedFileSystemElement result = new MinimizedFileSystemElement(elementLabel, dummyParent, isContainer);
        result.setFileSystemObject(fileSystemObject);
        result.getFiles(provider);
        return dummyParent;
    }

    protected ZipFile getSpecifiedSourceFile() {
        try {
            return new ZipFile(this.sourceNameField.getText());
        }
        catch (ZipException zipException) {
            StatusInfo status = new StatusInfo();
            status.setError(AntPreferencesMessages.getString("AddCustomDialog.Bad_Format"));
            this.updateStatus(status);
        }
        catch (IOException iOException) {
            StatusInfo status = new StatusInfo();
            status.setError(AntPreferencesMessages.getString("AddCustomDialog.Unreadable"));
            this.updateStatus(status);
        }
        this.sourceNameField.setFocus();
        return null;
    }

    protected ZipFileStructureProvider getStructureProvider(ZipFile targetZip) {
        if (this.providerCache == null) {
            this.providerCache = new ZipFileStructureProvider(targetZip);
        } else if (!this.providerCache.getZipFile().getName().equals(targetZip.getName())) {
            this.clearProviderCache();
            this.providerCache = new ZipFileStructureProvider(targetZip);
        } else if (!this.providerCache.getZipFile().equals(targetZip)) {
            this.closeZipFile(targetZip);
        }
        return this.providerCache;
    }

    protected void resetSelection() {
        MinimizedFileSystemElement currentRoot = this.getFileSystemTree();
        this.selectionGroup.setRoot(currentRoot);
        if (this.className.length() != 0) {
            StringTokenizer tokenizer = new StringTokenizer(this.className, ".");
            this.selectClass(currentRoot, tokenizer);
        }
    }

    private void selectClass(MinimizedFileSystemElement currentParent, StringTokenizer tokenizer) {
        MinimizedFileSystemElement element;
        if (!tokenizer.hasMoreTokens()) {
            return;
        }
        List folders = currentParent.getFolders(this.currentProvider);
        if (folders.size() == 1 && (element = (MinimizedFileSystemElement)folders.get(0)).getLabel(null).equals("/")) {
            this.selectionGroup.selectAndRevealFolder(element);
            this.selectClass(element, tokenizer);
            return;
        }
        String currentName = tokenizer.nextToken();
        if (tokenizer.hasMoreTokens()) {
            Iterator allFolders = folders.iterator();
            while (allFolders.hasNext()) {
                MinimizedFileSystemElement folder = (MinimizedFileSystemElement)allFolders.next();
                if (!folder.getLabel(null).equals(currentName)) continue;
                this.selectionGroup.selectAndRevealFolder(folder);
                this.selectClass(folder, tokenizer);
                return;
            }
        } else {
            List files = currentParent.getFiles(this.currentProvider);
            Iterator iter = files.iterator();
            while (iter.hasNext()) {
                MinimizedFileSystemElement file = (MinimizedFileSystemElement)iter.next();
                if (!file.getLabel(null).equals(String.valueOf(currentName) + ".class")) continue;
                this.selectionGroup.selectAndRevealFile(file);
                return;
            }
        }
    }

    protected ITreeContentProvider getFileProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement element = (MinimizedFileSystemElement)o;
                    return element.getFiles(AddCustomDialog.this.currentProvider).toArray();
                }
                return new Object[0];
            }
        };
    }

    protected ITreeContentProvider getFolderProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement element = (MinimizedFileSystemElement)o;
                    return element.getFolders(AddCustomDialog.this.currentProvider).toArray();
                }
                return new Object[0];
            }

            public boolean hasChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement element = (MinimizedFileSystemElement)o;
                    if (element.isPopulated()) {
                        return this.getChildren(element).length > 0;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    protected void cancelPressed() {
        this.clearProviderCache();
        super.cancelPressed();
    }

    protected void okPressed() {
        this.clearProviderCache();
        this.name = this.nameField.getText().trim();
        this.library = (URL)this.libraryUrls.get(this.sourceNameField.getSelectionIndex());
        IStructuredSelection selection = this.selectionGroup.getListTableSelection();
        MinimizedFileSystemElement element = (MinimizedFileSystemElement)selection.getFirstElement();
        if (element == null) {
            super.okPressed();
            return;
        }
        Object file = element.getFileSystemObject();
        if (file instanceof ZipEntry) {
            this.className = ((ZipEntry)file).getName();
        } else {
            this.className = ((File)file).getAbsolutePath();
            Path classPath = new Path(this.className);
            Path libraryPath = new Path(this.library.getPath());
            int matching = classPath.matchingFirstSegments((IPath)libraryPath);
            classPath = classPath.removeFirstSegments(matching);
            classPath = classPath.setDevice(null);
            this.className = classPath.toString();
        }
        int index = this.className.lastIndexOf(46);
        this.className = this.className.substring(0, index);
        this.className = this.className.replace('/', '.');
        super.okPressed();
    }

    protected String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setLibrary(URL library) {
        this.library = library;
        this.editing = true;
    }

    protected URL getLibrary() {
        return this.library;
    }

    protected String getClassName() {
        return this.className;
    }

    protected void setClassName(String className) {
        this.className = className;
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(this.library != null);
    }
}

