/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.ant.core.AntRunner;
import org.eclipse.ant.core.TargetInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.externaltools.internal.ant.view.AntView;

public final class AntUtil {
    public static final String RUN_TARGETS_ATTRIBUTE = "antBuildType.runTargets";
    public static final String ATTRIBUTE_SEPARATOR = ",";

    private AntUtil() {
    }

    public static String combineStrings(String[] strings) {
        if (strings.length == 0) {
            return null;
        }
        if (strings.length == 1) {
            return strings[0];
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < strings.length - 1) {
            buf.append(strings[i]);
            buf.append(ATTRIBUTE_SEPARATOR);
            ++i;
        }
        buf.append(strings[strings.length - 1]);
        return buf.toString();
    }

    public static String[] getTargetsFromConfig(ILaunchConfiguration configuration) throws CoreException {
        String attribute = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", null);
        if (attribute == null) {
            return null;
        }
        return AntUtil.parseRunTargets(attribute);
    }

    public static Map getProperties(ILaunchConfiguration configuration) throws CoreException {
        Map map = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTIES", null);
        return map;
    }

    public static String getAntHome(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_HOME", null);
    }

    public static String[] getPropertyFiles(ILaunchConfiguration configuration) throws CoreException {
        String attribute = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTY_FILES", null);
        if (attribute == null) {
            return null;
        }
        return AntUtil.parseString(attribute, ATTRIBUTE_SEPARATOR);
    }

    public static TargetInfo[] getTargets(String path) throws CoreException {
        AntRunner runner = new AntRunner();
        runner.setBuildFileLocation(path);
        return runner.getAvailableTargets();
    }

    public static TargetInfo[] getTargets(String path, String[] arguments, ILaunchConfiguration config) throws CoreException {
        Map properties = AntUtil.getProperties(config);
        String[] propertyFiles = AntUtil.getPropertyFiles(config);
        AntRunner runner = new AntRunner();
        runner.setBuildFileLocation(path);
        if (properties != null) {
            runner.addUserProperties(properties);
        }
        if (propertyFiles != null && propertyFiles.length > 0) {
            runner.setPropertyFiles(propertyFiles);
        }
        if (arguments != null && arguments.length > 0) {
            runner.setArguments(arguments);
        }
        return runner.getAvailableTargets();
    }

    public static URL[] getCustomClasspath(ILaunchConfiguration config) throws CoreException {
        String classpathString = config.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_CUSTOM_CLASSPATH", null);
        if (classpathString == null) {
            return null;
        }
        ArrayList antURLs = new ArrayList();
        ArrayList userURLs = new ArrayList();
        AntUtil.getCustomClasspaths(config, antURLs, userURLs);
        URL[] custom = new URL[antURLs.size() + userURLs.size()];
        antURLs.addAll(userURLs);
        return antURLs.toArray(custom);
    }

    public static void getCustomClasspaths(ILaunchConfiguration config, List antURLs, List userURLs) {
        String classpathString = null;
        try {
            classpathString = config.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_CUSTOM_CLASSPATH", null);
        }
        catch (CoreException coreException) {}
        if (classpathString == null) {
            return;
        }
        String antString = null;
        String userString = null;
        int delim = classpathString.indexOf(42);
        if (delim == -1) {
            antString = classpathString;
        } else {
            antString = classpathString.substring(0, delim);
            userString = classpathString.substring(delim + 1);
        }
        String[] antStrings = AntUtil.parseString(antString, ATTRIBUTE_SEPARATOR);
        int i = 0;
        while (i < antStrings.length) {
            String string = antStrings[i];
            try {
                antURLs.add(new URL("file:" + string));
            }
            catch (MalformedURLException malformedURLException) {}
            ++i;
        }
        if (userString != null) {
            String[] userStrings = AntUtil.parseString(userString, ATTRIBUTE_SEPARATOR);
            int i2 = 0;
            while (i2 < userStrings.length) {
                String string = userStrings[i2];
                try {
                    userURLs.add(new URL("file:" + string));
                }
                catch (MalformedURLException malformedURLException) {}
                ++i2;
            }
        }
    }

    public static AntView getAntView() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            return (AntView)page.findView("org.eclipse.ui.externaltools.AntView");
        }
        return null;
    }

    public static boolean isSubTarget(TargetInfo info) {
        return info.getDescription() == null;
    }

    public static String[] parseRunTargets(String extraAttibuteValue) {
        return AntUtil.parseString(extraAttibuteValue, ATTRIBUTE_SEPARATOR);
    }

    public static String[] parseString(String attibuteValue, String delim) {
        if (attibuteValue == null) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(attibuteValue, delim);
        String[] results = new String[tokenizer.countTokens()];
        int i = 0;
        while (i < results.length) {
            results[i] = tokenizer.nextToken();
            ++i;
        }
        return results;
    }

    public static IFile getFile(String fullPath) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        return root.getFileForLocation((IPath)new Path(fullPath));
    }
}

