/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.launchConfigurations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleHyperlink;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;

public class TaskLinkManager {
    private static Map fgProcessTable;

    private TaskLinkManager() {
    }

    public static void addTaskHyperlink(IProcess process, IConsoleHyperlink link, IRegion region, String taskName) {
        ArrayList<HyperlinkEntry> queue;
        if (fgProcessTable == null) {
            fgProcessTable = new HashMap(10);
        }
        if ((queue = (ArrayList<HyperlinkEntry>)fgProcessTable.get(process)) == null) {
            queue = new ArrayList<HyperlinkEntry>(10);
            fgProcessTable.put(process, queue);
        }
        ArrayList<HyperlinkEntry> arrayList = queue;
        synchronized (arrayList) {
            queue.add(new HyperlinkEntry(link, region, taskName));
        }
    }

    public static void processNewLine(IConsole console, IRegion newLine) {
        if (fgProcessTable == null) {
            return;
        }
        IProcess process = console.getProcess();
        List queue = (List)fgProcessTable.get(process);
        if (queue == null) {
            return;
        }
        List list = queue;
        synchronized (list) {
            int i = 0;
            while (i < queue.size()) {
                String text;
                HyperlinkEntry entry = (HyperlinkEntry)queue.get(i);
                IRegion region = entry.getRegion();
                int offset = newLine.getOffset() + region.getOffset();
                int length = region.getLength();
                try {
                    text = console.getDocument().get(offset, length);
                }
                catch (BadLocationException badLocationException) {
                    return;
                }
                if (text.equals(entry.getTaskName())) {
                    console.addLink(entry.getLink(), offset, length);
                    queue.remove(i);
                    return;
                }
                ++i;
            }
        }
    }

    public static void dispose(IProcess process) {
        if (fgProcessTable != null) {
            fgProcessTable.remove(process);
        }
    }

    private static class HyperlinkEntry {
        private IConsoleHyperlink fLink;
        private IRegion fRegion;
        private String fTaskName;

        public HyperlinkEntry(IConsoleHyperlink link, IRegion region, String taskName) {
            this.fLink = link;
            this.fRegion = region;
            this.fTaskName = taskName;
        }

        public IRegion getRegion() {
            return this.fRegion;
        }

        public IConsoleHyperlink getLink() {
            return this.fLink;
        }

        public String getTaskName() {
            return this.fTaskName;
        }
    }
}

