/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.launchConfigurations;

import org.eclipse.ant.core.TargetInfo;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.externaltools.internal.ant.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.ui.externaltools.internal.model.AntImageDescriptor;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsImages;

public class TargetTableLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    public String getText(Object model) {
        TargetInfo target = (TargetInfo)model;
        StringBuffer result = new StringBuffer(target.getName());
        if (target.isDefault()) {
            result.append(" (");
            result.append(AntLaunchConfigurationMessages.getString("AntTargetLabelProvider.default_target_1"));
            result.append(")");
        }
        return result.toString();
    }

    public Image getImage(Object element) {
        TargetInfo target = (TargetInfo)element;
        ImageDescriptor base = null;
        int flags = 0;
        if (target.isDefault()) {
            flags |= 1;
            base = ExternalToolsImages.getImageDescriptor("org.eclipse.ui.externaltools.antDefaultTarget");
        } else {
            base = target.getDescription() == null ? ExternalToolsImages.getImageDescriptor("org.eclipse.ui.externaltools.antPrivateTarget") : ExternalToolsImages.getImageDescriptor("org.eclipse.ui.externaltools.antTarget");
        }
        return ExternalToolsImages.getImage(new AntImageDescriptor(base, flags));
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getText(element);
        }
        String desc = ((TargetInfo)element).getDescription();
        if (desc == null) {
            return "";
        }
        return desc;
    }

    public Color getForeground(Object element) {
        if (!(element instanceof TargetInfo)) {
            return null;
        }
        TargetInfo info = (TargetInfo)element;
        if (info.isDefault()) {
            return Display.getDefault().getSystemColor(9);
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

