/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.launchConfigurations;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.externaltools.internal.ant.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.ui.externaltools.internal.ant.launchConfigurations.AntTargetContentProvider;
import org.eclipse.ui.externaltools.internal.ant.launchConfigurations.TargetTableLabelProvider;
import org.eclipse.ui.help.WorkbenchHelp;

public class TargetOrderDialog
extends Dialog
implements ISelectionChangedListener {
    private Button fUp;
    private Button fDown;
    private TableViewer fViewer;
    private AntTargetContentProvider fContentProvider;
    private Object[] fTargets;

    public TargetOrderDialog(Shell parentShell, Object[] targets) {
        super(parentShell);
        this.fTargets = targets;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(AntLaunchConfigurationMessages.getString("TargetOrderDialog.Order_Targets_1"));
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        Label label = new Label(comp, 0);
        label.setText(AntLaunchConfigurationMessages.getString("TargetOrderDialog.&Specify_target_execution_order__2"));
        label.setFont(comp.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.createTargetList(comp);
        this.createButtons(comp);
        this.updateButtons();
        return comp;
    }

    private void createButtons(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        GridData gd = new GridData(256);
        gd.verticalAlignment = 1;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)gd);
        this.fUp = new Button(comp, 8);
        this.fUp.setFont(parent.getFont());
        this.fUp.setText(AntLaunchConfigurationMessages.getString("TargetOrderDialog.&Up_3"));
        this.setButtonLayoutData(this.fUp);
        this.fUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetOrderDialog.this.handleUpPressed();
            }
        });
        this.fDown = new Button(comp, 8);
        this.fDown.setFont(parent.getFont());
        this.fDown.setText(AntLaunchConfigurationMessages.getString("TargetOrderDialog.&Down_4"));
        this.setButtonLayoutData(this.fDown);
        this.fDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetOrderDialog.this.handleDownPressed();
            }
        });
    }

    protected void handleDownPressed() {
        int[] selections = this.fViewer.getTable().getSelectionIndices();
        int i = 0;
        while (i < selections.length) {
            this.fContentProvider.moveDownTarget(selections[i]);
            ++i;
        }
        this.fTargets = this.fContentProvider.getElements(null);
        this.fViewer.refresh();
        this.updateButtons();
    }

    protected void handleUpPressed() {
        int[] selections = this.fViewer.getTable().getSelectionIndices();
        int i = 0;
        while (i < selections.length) {
            this.fContentProvider.moveUpTarget(selections[i]);
            ++i;
        }
        this.fTargets = this.fContentProvider.getElements(null);
        this.fViewer.refresh();
        this.updateButtons();
    }

    private void createTargetList(Composite comp) {
        this.fViewer = new TableViewer(comp, 67586);
        this.fViewer.setLabelProvider((IBaseLabelProvider)new TargetTableLabelProvider());
        this.fContentProvider = new AntTargetContentProvider();
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fViewer.setInput((Object)this.fTargets);
        this.fViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Table table = this.fViewer.getTable();
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        gd.widthHint = 250;
        table.setLayoutData((Object)gd);
    }

    public Object[] getTargets() {
        return this.fTargets;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateButtons();
    }

    private void updateButtons() {
        int[] selections = this.fViewer.getTable().getSelectionIndices();
        int last = this.fTargets.length - 1;
        boolean up = selections.length > 0;
        boolean down = selections.length > 0;
        int i = 0;
        while (i < selections.length) {
            if (selections[i] == 0) {
                up = false;
            }
            if (selections[i] == last) {
                down = false;
            }
            ++i;
        }
        this.fUp.setEnabled(up);
        this.fDown.setEnabled(down);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        WorkbenchHelp.setHelp((Control)shell, (String)"org.eclipse.ui.externaltools.target_order_dialog_context");
    }
}

