/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.launchConfigurations;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ant.core.TargetInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.externaltools.internal.ant.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.ui.externaltools.internal.ant.launchConfigurations.AntTargetContentProvider;
import org.eclipse.ui.externaltools.internal.ant.launchConfigurations.TargetOrderDialog;
import org.eclipse.ui.externaltools.internal.ant.launchConfigurations.TargetTableLabelProvider;
import org.eclipse.ui.externaltools.internal.ant.model.AntUtil;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsUtil;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsImages;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;
import org.eclipse.ui.externaltools.internal.model.ToolUtil;
import org.eclipse.ui.externaltools.internal.variable.ExpandVariableContext;
import org.eclipse.ui.help.WorkbenchHelp;

public class AntTargetsTab
extends AbstractLaunchConfigurationTab {
    private TargetInfo fDefaultTarget = null;
    private TargetInfo[] fAllTargets = null;
    private List fOrderedTargets = null;
    private String fLocation = null;
    private CheckboxTableViewer fTableViewer = null;
    private Label fSelectionCountLabel = null;
    private Text fTargetOrderText = null;
    private Button fOrderButton = null;
    private ILaunchConfiguration fLaunchConfiguration;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.ui.externaltools.ant_targets_tab_context");
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        Label label = new Label(comp, 0);
        label.setFont(font);
        label.setText(AntLaunchConfigurationMessages.getString("AntTargetsTab.Check_targets_to_e&xecute__1"));
        this.createTargetsTable(comp);
        this.fSelectionCountLabel = new Label(comp, 0);
        this.fSelectionCountLabel.setFont(font);
        this.fSelectionCountLabel.setText(AntLaunchConfigurationMessages.getString("AntTargetsTab.0_out_of_0_selected_2"));
        gd = new GridData(768);
        this.fSelectionCountLabel.setLayoutData((Object)gd);
        label = new Label(comp, 0);
        label = new Label(comp, 0);
        label.setText(AntLaunchConfigurationMessages.getString("AntTargetsTab.Target_execution_order__3"));
        Composite orderComposite = new Composite(comp, 0);
        gd = new GridData(768);
        orderComposite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        orderComposite.setLayout((Layout)layout);
        this.fTargetOrderText = new Text(orderComposite, 2634);
        this.fTargetOrderText.setFont(font);
        gd = new GridData(768);
        gd.heightHint = 40;
        gd.widthHint = 200;
        this.fTargetOrderText.setLayoutData((Object)gd);
        this.fOrderButton = this.createPushButton(orderComposite, AntLaunchConfigurationMessages.getString("AntTargetsTab.&Order..._4"), null);
        gd = (GridData)this.fOrderButton.getLayoutData();
        gd.verticalAlignment = 1;
        this.fOrderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AntTargetsTab.this.handleOrderPressed();
            }
        });
    }

    private void handleOrderPressed() {
        TargetOrderDialog dialog = new TargetOrderDialog(this.getShell(), this.fOrderedTargets.toArray());
        int ok = dialog.open();
        if (ok == 0) {
            this.fOrderedTargets.clear();
            Object[] targets = dialog.getTargets();
            int i = 0;
            while (i < targets.length) {
                this.fOrderedTargets.add(targets[i]);
                this.updateSelectionCount();
                this.updateLaunchConfigurationDialog();
                ++i;
            }
        }
    }

    private void createTargetsTable(Composite parent) {
        Table table = new Table(parent, 67632);
        GridData data = new GridData(1808);
        data.heightHint = 200;
        data.widthHint = 250;
        table.setLayoutData((Object)data);
        table.setFont(parent.getFont());
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        ColumnWeightData weightData = new ColumnWeightData(40, true);
        tableLayout.addColumnData((ColumnLayoutData)weightData);
        weightData = new ColumnWeightData(60, true);
        tableLayout.addColumnData((ColumnLayoutData)weightData);
        table.setLayout((Layout)tableLayout);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(AntLaunchConfigurationMessages.getString("AntTargetsTab.Name_5"));
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(AntLaunchConfigurationMessages.getString("AntTargetsTab.Description_6"));
        this.fTableViewer = new CheckboxTableViewer(table);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new TargetTableLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new AntTargetContentProvider());
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection ss = (IStructuredSelection)selection;
                    Object element = ss.getFirstElement();
                    boolean checked = !AntTargetsTab.this.fTableViewer.getChecked(element);
                    AntTargetsTab.this.fTableViewer.setChecked(element, checked);
                    AntTargetsTab.this.updateOrderedTargets(element, checked);
                }
            }
        });
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                AntTargetsTab.this.updateOrderedTargets(event.getElement(), event.getChecked());
            }
        });
    }

    private void updateOrderedTargets(Object element, boolean checked) {
        if (checked) {
            this.fOrderedTargets.add(element);
        } else {
            this.fOrderedTargets.remove(element);
        }
        this.updateSelectionCount();
        this.updateLaunchConfigurationDialog();
    }

    private void updateSelectionCount() {
        Object[] checked = this.fTableViewer.getCheckedElements();
        String numSelected = Integer.toString(checked.length);
        int length = 0;
        if (this.fAllTargets != null) {
            length = this.fAllTargets.length;
        }
        String total = Integer.toString(length);
        this.fSelectionCountLabel.setText(MessageFormat.format(AntLaunchConfigurationMessages.getString("AntTargetsTab.{0}_out_of_{1}_selected_7"), numSelected, total));
        this.fOrderButton.setEnabled(checked.length > 1);
        StringBuffer buffer = new StringBuffer();
        Iterator iter = this.fOrderedTargets.iterator();
        while (iter.hasNext()) {
            buffer.append(((TargetInfo)iter.next()).getName());
            buffer.append(", ");
        }
        if (buffer.length() > 2) {
            buffer.setLength(buffer.length() - 2);
        }
        this.fTargetOrderText.setText(buffer.toString());
    }

    private TargetInfo[] getTargets() {
        if (this.fAllTargets == null) {
            this.setErrorMessage(null);
            MultiStatus status = new MultiStatus("org.eclipse.ui.externaltools", 0, "", null);
            String expandedLocation = ToolUtil.expandFileLocation(this.fLocation, ExpandVariableContext.EMPTY_CONTEXT, status);
            if (expandedLocation != null && status.isOK()) {
                try {
                    String[] arguments = ExternalToolsUtil.getArguments(this.fLaunchConfiguration, ExpandVariableContext.EMPTY_CONTEXT);
                    this.fAllTargets = AntUtil.getTargets(expandedLocation, arguments, this.fLaunchConfiguration);
                }
                catch (CoreException ce) {
                    this.setErrorMessage(ce.getMessage());
                    this.fAllTargets = null;
                    return this.fAllTargets;
                }
                int i = 0;
                while (i < this.fAllTargets.length) {
                    if (this.fAllTargets[i].isDefault()) {
                        this.fDefaultTarget = this.fAllTargets[i];
                        break;
                    }
                    ++i;
                }
            }
            if (this.fAllTargets != null) {
                Arrays.sort(this.fAllTargets, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        TargetInfo t1 = (TargetInfo)o1;
                        TargetInfo t2 = (TargetInfo)o2;
                        return t1.getName().compareToIgnoreCase(t2.getName());
                    }

                    public boolean equals(Object obj) {
                        return false;
                    }
                });
            }
        }
        return this.fAllTargets;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        TargetInfo[] allInfos;
        this.fLaunchConfiguration = configuration;
        this.setErrorMessage(null);
        this.setMessage(null);
        String configTargets = null;
        String newLocation = null;
        this.fOrderedTargets = new ArrayList();
        try {
            configTargets = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", null);
            newLocation = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", null);
        }
        catch (CoreException ce) {
            ExternalToolsPlugin.getDefault().log(AntLaunchConfigurationMessages.getString("AntTargetsTab.Error_reading_configuration_12"), ce);
        }
        if (newLocation == null) {
            this.fAllTargets = null;
            this.fLocation = newLocation;
            this.setExecuteInput(new TargetInfo[0]);
            this.fTableViewer.setInput((Object)new TargetInfo[0]);
            return;
        }
        if (!newLocation.equals(this.fLocation)) {
            this.fAllTargets = null;
            this.fLocation = newLocation;
        }
        if ((allInfos = this.getTargets()) == null) {
            this.setExecuteInput(new TargetInfo[0]);
            this.fTableViewer.setInput((Object)new TargetInfo[0]);
            return;
        }
        String[] targetNames = AntUtil.parseRunTargets(configTargets);
        if (targetNames.length == 0) {
            this.fOrderedTargets.add(this.fDefaultTarget);
            this.fTableViewer.setAllChecked(false);
            this.setExecuteInput(allInfos);
            if (this.fDefaultTarget != null) {
                this.fTableViewer.setChecked((Object)this.fDefaultTarget, true);
            }
            this.updateSelectionCount();
            return;
        }
        this.setExecuteInput(allInfos);
        this.fTableViewer.setAllChecked(false);
        int i = 0;
        while (i < targetNames.length) {
            int j = 0;
            while (j < this.fAllTargets.length) {
                if (targetNames[i].equals(this.fAllTargets[j].getName())) {
                    this.fOrderedTargets.add(this.fAllTargets[j]);
                    this.fTableViewer.setChecked((Object)this.fAllTargets[j], true);
                }
                ++j;
            }
            ++i;
        }
        this.updateSelectionCount();
    }

    private void setExecuteInput(Object input) {
        this.fTableViewer.setInput(input);
        this.updateSelectionCount();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fOrderedTargets.size() == 1) {
            TargetInfo item = (TargetInfo)this.fOrderedTargets.get(0);
            if (item.isDefault()) {
                configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", null);
                return;
            }
        } else if (this.fOrderedTargets.size() == 0) {
            return;
        }
        StringBuffer buff = new StringBuffer();
        Iterator iter = this.fOrderedTargets.iterator();
        String targets = null;
        while (iter.hasNext()) {
            TargetInfo item = (TargetInfo)iter.next();
            buff.append(item.getName());
            buff.append(',');
        }
        if (buff.length() > 0) {
            targets = buff.toString();
        }
        configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", targets);
    }

    public String getName() {
        return AntLaunchConfigurationMessages.getString("AntTargetsTab.Tar&gets_14");
    }

    public Image getImage() {
        return ExternalToolsImages.getImage("org.eclipse.ui.externaltools.IMG_TAB_ANT_TARGETS");
    }

    public boolean canSave() {
        return this.isValid(null);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (this.fAllTargets == null && this.getErrorMessage() != null) {
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.fAllTargets != null && this.fTableViewer.getCheckedElements().length == 0) {
            this.setErrorMessage(AntLaunchConfigurationMessages.getString("AntTargetsTab.No_targets"));
            return false;
        }
        return super.isValid(launchConfig);
    }
}

