/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.launchConfigurations;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.ui.externaltools.internal.ant.launchConfigurations.AntClasspathTab;
import org.eclipse.ui.externaltools.internal.ant.launchConfigurations.AntMainTab;
import org.eclipse.ui.externaltools.internal.ant.launchConfigurations.AntPropertiesTab;
import org.eclipse.ui.externaltools.internal.ant.launchConfigurations.AntTargetsTab;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsRefreshTab;
import org.eclipse.ui.externaltools.internal.model.ToolUtil;
import org.eclipse.ui.externaltools.internal.model.VariableContextManager;
import org.eclipse.ui.externaltools.internal.variable.ExpandVariableContext;

public class AntTabGroup
extends AbstractLaunchConfigurationTabGroup {
    public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
        ILaunchConfigurationTab[] tabs = new ILaunchConfigurationTab[]{new AntMainTab(), new ExternalToolsRefreshTab(), new AntTargetsTab(), new AntClasspathTab(), new AntPropertiesTab(), new CommonTab()};
        this.setTabs(tabs);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IFile file;
        String extension;
        super.setDefaults(configuration);
        VariableContextManager manager = VariableContextManager.getDefault();
        ExpandVariableContext context = manager.getVariableContext();
        IResource resource = context.getSelectedResource();
        if (resource != null && resource instanceof IFile && (extension = (file = (IFile)resource).getFileExtension()) != null && extension.equalsIgnoreCase("xml")) {
            StringBuffer buffer = new StringBuffer(file.getProject().getName());
            buffer.append(" ");
            buffer.append(file.getName());
            String name = buffer.toString().trim();
            name = DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(name);
            configuration.rename(name);
            StringBuffer buf = new StringBuffer();
            ToolUtil.buildVariableTag("workspace_loc", file.getFullPath().toString(), buf);
            String text = buf.toString();
            if (text != null) {
                configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", text);
            }
        }
    }
}

