/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.launchConfigurations;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ant.core.Property;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.externaltools.internal.ant.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.ui.externaltools.internal.ant.model.AntUtil;
import org.eclipse.ui.externaltools.internal.ant.preferences.AntPropertiesBlock;
import org.eclipse.ui.externaltools.internal.ant.preferences.IAntBlockContainer;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsImages;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;
import org.eclipse.ui.help.WorkbenchHelp;

public class AntPropertiesTab
extends AbstractLaunchConfigurationTab
implements IAntBlockContainer {
    private AntPropertiesBlock antPropertiesBlock = new AntPropertiesBlock(this);

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setFont(parent.getFont());
        this.setControl((Control)top);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.ui.externaltools.ant_properties_tab_context");
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        top.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        top.setLayoutData((Object)gridData);
        this.antPropertiesBlock.createControl(top, AntLaunchConfigurationMessages.getString("AntPropertiesTab.&Properties__6"), AntLaunchConfigurationMessages.getString("AntPropertiesTab.Property_f&iles__7"));
    }

    public Image getImage() {
        return ExternalToolsImages.getImage("org.eclipse.ui.externaltools.IMG_PROPERTY");
    }

    public String getName() {
        return AntLaunchConfigurationMessages.getString("AntPropertiesTab.P&roperties_8");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setErrorMessage(null);
        this.setMessage(null);
        Map properties = null;
        try {
            properties = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTIES", null);
        }
        catch (CoreException ce) {
            ExternalToolsPlugin.getDefault().log(AntLaunchConfigurationMessages.getString("AntPropertiesTab.Error_reading_configuration_9"), ce);
        }
        String propertyFiles = null;
        try {
            propertyFiles = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTY_FILES", null);
        }
        catch (CoreException ce) {
            ExternalToolsPlugin.getDefault().log(AntLaunchConfigurationMessages.getString("AntPropertiesTab.Error_reading_configuration_9"), ce);
        }
        this.antPropertiesBlock.populatePropertyViewer(properties);
        String[] files = AntUtil.parseString(propertyFiles, ",");
        this.antPropertiesBlock.setPropertyFilesInput(files);
        this.antPropertiesBlock.update();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        Object[] items = this.antPropertiesBlock.getProperties();
        HashMap<String, String> properties = null;
        if (items.length > 0) {
            properties = new HashMap<String, String>(items.length);
            int i = 0;
            while (i < items.length) {
                Property property = (Property)items[i];
                properties.put(property.getName(), property.getValue());
                ++i;
            }
        }
        configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTIES", properties);
        items = this.antPropertiesBlock.getPropertyFiles();
        String files = null;
        if (items.length > 0) {
            StringBuffer buff = new StringBuffer();
            int i = 0;
            while (i < items.length) {
                String path = (String)items[i];
                buff.append(path);
                buff.append(',');
                ++i;
            }
            files = buff.toString();
        }
        configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTY_FILES", files);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void setMessage(String message) {
        super.setMessage(message);
    }

    public void setErrorMessage(String message) {
        super.setErrorMessage(message);
    }

    public Button createPushButton(Composite parent, String buttonText) {
        return super.createPushButton(parent, buttonText, null);
    }

    public void update() {
        this.updateLaunchConfigurationDialog();
    }
}

