/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.launchConfigurations;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.externaltools.internal.ant.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsLaunchConfigurationMessages;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsMainTab;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;
import org.eclipse.ui.externaltools.internal.model.ToolUtil;
import org.eclipse.ui.externaltools.internal.ui.FileSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class AntMainTab
extends ExternalToolsMainTab {
    protected Button captureOutputButton;

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        this.updateCaptureOutput(configuration);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        this.setAttribute("org.eclipse.ui.externaltools.ATTR_CAPTURE_OUTPUT", configuration, this.captureOutputButton.getSelection(), true);
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        WorkbenchHelp.setHelp((Control)mainComposite, (String)"org.eclipse.ui.externaltools.ant_main_tab_context");
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData gridData = new GridData(768);
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)gridData);
        mainComposite.setFont(parent.getFont());
        this.createLocationComponent(mainComposite);
        this.createWorkDirectoryComponent(mainComposite);
        this.createArgumentComponent(mainComposite);
        this.createVerticalSpacer(mainComposite, 2);
        this.createRunBackgroundComponent(mainComposite);
        this.createCaptureOutputComponent(mainComposite);
    }

    protected void createCaptureOutputComponent(Composite parent) {
        this.captureOutputButton = new Button(parent, 32);
        this.captureOutputButton.setText(AntLaunchConfigurationMessages.getString("AntMainTab.Capture_&output_1"));
        GridData data = new GridData(256);
        data.horizontalSpan = 2;
        this.captureOutputButton.setLayoutData((Object)data);
        this.captureOutputButton.setFont(parent.getFont());
        this.captureOutputButton.addSelectionListener(this.getSelectionAdapter());
    }

    protected void updateCaptureOutput(ILaunchConfiguration configuration) {
        boolean captureOutput = true;
        try {
            captureOutput = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_CAPTURE_OUTPUT", true);
        }
        catch (CoreException ce) {
            ExternalToolsPlugin.getDefault().log(ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsMainTab.Error_reading_configuration_7"), ce);
        }
        this.captureOutputButton.setSelection(captureOutput);
    }

    protected void handleWorkspaceLocationButtonSelected() {
        FileSelectionDialog dialog = new FileSelectionDialog(this.getShell(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), AntLaunchConfigurationMessages.getString("AntMainTab.&Select_a_build_file__1"));
        dialog.setFileFilter("*.xml", true);
        dialog.open();
        IFile file = dialog.getResult();
        if (file == null) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        ToolUtil.buildVariableTag("workspace_loc", file.getFullPath().toString(), buf);
        String text = buf.toString();
        if (text != null) {
            this.locationField.setText(text);
        }
    }

    protected String getWorkingDirectoryLabel() {
        return AntLaunchConfigurationMessages.getString("AntMainTab.Base_&Directory__3");
    }
}

