/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.launchConfigurations;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.externaltools.internal.ant.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.ui.externaltools.internal.ant.model.AntUtil;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsUtil;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;
import org.eclipse.ui.externaltools.internal.model.ToolUtil;
import org.eclipse.ui.externaltools.internal.variable.ExpandVariableContext;

public class AntLaunchShortcut
implements ILaunchShortcut {
    private boolean fShowDialog = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void launch(ISelection selection, String mode) {
        IStructuredSelection structuredSelection;
        Object object;
        if (selection instanceof IStructuredSelection && (object = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable) {
            IResource resource;
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((resource = (IResource)iAdaptable.getAdapter((Class)clazz)) != null) {
                this.launch(resource, mode);
                return;
            }
        }
        this.antFileNotFound();
    }

    private void antFileNotFound() {
        AntLaunchShortcut.reportError(AntLaunchConfigurationMessages.getString("AntLaunchShortcut.Unable"), null);
    }

    protected void launch(IResource resource, String mode) {
        if (!"xml".equalsIgnoreCase(resource.getFileExtension())) {
            if (resource.getType() == 1) {
                resource = resource.getParent();
            }
            resource = this.findBuildFile((IContainer)resource);
        }
        if (resource != null) {
            this.launch((IFile)resource, mode, null);
        } else {
            this.antFileNotFound();
        }
    }

    public void launch(IFile file, String mode, String targetAttribute) {
        ILaunchConfiguration configuration = null;
        if (this.verifyMode(mode)) {
            List configurations = AntLaunchShortcut.findExistingLaunchConfigurations(file);
            if (configurations.isEmpty()) {
                configuration = AntLaunchShortcut.createDefaultLaunchConfiguration(file);
            } else if (configurations.size() == 1) {
                configuration = (ILaunchConfiguration)configurations.get(0);
            } else {
                configuration = AntLaunchShortcut.chooseConfig(configurations);
                if (configuration == null) {
                    return;
                }
            }
        }
        if (configuration != null) {
            if (this.fShowDialog) {
                Status status = new Status(1, "org.eclipse.ui.externaltools", 1000, "", null);
                DebugUITools.openLaunchConfigurationDialog((Shell)ExternalToolsPlugin.getActiveWorkbenchWindow().getShell(), (ILaunchConfiguration)configuration, (String)"org.eclipse.ui.externaltools.launchGroup", (IStatus)status);
            } else {
                if (targetAttribute != null) {
                    String newName = DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(configuration.getName());
                    try {
                        configuration = configuration.copy(newName);
                        ((ILaunchConfigurationWorkingCopy)configuration).setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", targetAttribute);
                    }
                    catch (CoreException exception) {
                        AntLaunchShortcut.reportError(MessageFormat.format(AntLaunchConfigurationMessages.getString("AntLaunchShortcut.Exception_launching"), file.getName()), exception);
                        return;
                    }
                }
                DebugUITools.launch((ILaunchConfiguration)configuration, (String)mode);
            }
            return;
        }
        this.antFileNotFound();
    }

    private IFile findBuildFile(IContainer parent) {
        String[] names = this.getBuildFileNames();
        if (names == null) {
            return null;
        }
        IResource file = null;
        while (file == null || file.getType() != 1) {
            int i = 0;
            while (i < names.length) {
                String string = names[i];
                file = parent.findMember(string);
                if (file != null && file.getType() == 1) break;
                ++i;
            }
            parent = parent.getParent();
            if (parent != null) continue;
            return null;
        }
        return (IFile)file;
    }

    private String[] getBuildFileNames() {
        IPreferenceStore prefs = ExternalToolsPlugin.getDefault().getPreferenceStore();
        String buildFileNames = prefs.getString("ant.findBuildFileNames");
        if (buildFileNames.length() == 0) {
            return null;
        }
        return AntUtil.parseString(buildFileNames, ",");
    }

    public static ILaunchConfiguration createDefaultLaunchConfiguration(IFile file) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.ant.AntLaunchConfigurationType");
        StringBuffer buffer = new StringBuffer(file.getProject().getName());
        buffer.append(" ");
        buffer.append(file.getName());
        String name = buffer.toString().trim();
        name = manager.generateUniqueLaunchConfigurationNameFrom(name);
        try {
            ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, name);
            StringBuffer buf = new StringBuffer();
            ToolUtil.buildVariableTag("workspace_loc", file.getFullPath().toString(), buf);
            workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", buf.toString());
            CommonTab tab = new CommonTab();
            tab.setDefaults(workingCopy);
            tab.dispose();
            return workingCopy.doSave();
        }
        catch (CoreException e) {
            AntLaunchShortcut.reportError(MessageFormat.format(AntLaunchConfigurationMessages.getString("AntLaunchShortcut.An_exception_occurred_while_creating_a_default_Ant_launch_configuration_for_{0}_2"), file.toString()), e);
            return null;
        }
    }

    public static List findExistingLaunchConfigurations(IFile file) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.ant.AntLaunchConfigurationType");
        ArrayList<ILaunchConfiguration> validConfigs = new ArrayList<ILaunchConfiguration>();
        if (type != null) {
            ILaunchConfiguration[] configs = null;
            try {
                configs = manager.getLaunchConfigurations(type);
            }
            catch (CoreException e) {
                AntLaunchShortcut.reportError(AntLaunchConfigurationMessages.getString("AntLaunchShortcut.An_exception_occurred_while_retrieving_Ant_launch_configurations._3"), e);
            }
            if (configs != null && configs.length > 0) {
                IPath filePath = file.getLocation();
                ExpandVariableContext context = ExternalToolsUtil.getVariableContext();
                int i = 0;
                while (i < configs.length) {
                    ILaunchConfiguration configuration = configs[i];
                    try {
                        IPath location = ExternalToolsUtil.getLocation(configuration, context);
                        if (filePath.equals((Object)location)) {
                            validConfigs.add(configuration);
                        }
                    }
                    catch (CoreException coreException) {}
                    ++i;
                }
            }
        }
        return validConfigs;
    }

    public static ILaunchConfiguration chooseConfig(List configs) {
        if (configs.isEmpty()) {
            return null;
        }
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)labelProvider);
        dialog.setElements((Object[])configs.toArray(new ILaunchConfiguration[configs.size()]));
        dialog.setTitle(AntLaunchConfigurationMessages.getString("AntLaunchShortcut.Ant_Configuration_Selection_4"));
        dialog.setMessage(AntLaunchConfigurationMessages.getString("AntLaunchShortcut.Choose_an_ant_configuration_to_run_5"));
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected boolean verifyMode(String mode) {
        if (!mode.equals("run")) {
            AntLaunchShortcut.reportError(AntLaunchConfigurationMessages.getString("AntLaunchShortcut.Ant_builds_only_support___run___mode._6"), null);
            return false;
        }
        return true;
    }

    public void launch(IEditorPart editor, String mode) {
        IFile file;
        IEditorInput input = editor.getEditorInput();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((file = (IFile)input.getAdapter((Class)clazz)) != null) {
            this.launch((IResource)file, mode);
            return;
        }
        this.antFileNotFound();
    }

    protected static void reportError(String message, Throwable throwable) {
        Object status = null;
        status = throwable instanceof CoreException ? ((CoreException)throwable).getStatus() : new Status(4, "org.eclipse.ui.externaltools", 0, message, throwable);
        ErrorDialog.openError((Shell)ExternalToolsPlugin.getActiveWorkbenchWindow().getShell(), (String)AntLaunchConfigurationMessages.getString("AntLaunchShortcut.Error_7"), (String)AntLaunchConfigurationMessages.getString("AntLaunchShortcut.Build_Failed_2"), (IStatus)status);
    }

    public void setShowDialog(boolean showDialog) {
        this.fShowDialog = showDialog;
    }
}

