/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.launchConfigurations;

import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.ant.core.AntRunner;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.ui.externaltools.internal.ant.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.ui.externaltools.internal.ant.launchConfigurations.AntProcess;
import org.eclipse.ui.externaltools.internal.ant.model.AntUtil;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsUtil;
import org.eclipse.ui.externaltools.internal.program.launchConfigurations.BackgroundResourceRefresher;
import org.eclipse.ui.externaltools.internal.variable.ExpandVariableContext;

public class AntLaunchDelegate
implements ILaunchConfigurationDelegate {
    private static final String ANT_LOGGER_CLASS = "org.eclipse.ui.externaltools.internal.ant.logger.AntProcessBuildLogger";
    private static final String NULL_LOGGER_CLASS = "org.eclipse.ui.externaltools.internal.ant.logger.NullBuildLogger";
    private static final String BASE_DIR_PREFIX = "-Dbasedir=";
    private static final String INPUT_HANDLER_CLASS = "org.eclipse.ui.externaltools.internal.ant.inputhandler.AntInputHandler";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String antHome;
        URL[] customClasspath;
        String[] targets;
        if (monitor.isCanceled()) {
            return;
        }
        if (ExternalToolsUtil.isBackground(configuration)) {
            monitor.beginTask(MessageFormat.format(AntLaunchConfigurationMessages.getString("AntLaunchDelegate.Launching_{0}_1"), configuration.getName()), 10);
        } else {
            monitor.beginTask(MessageFormat.format(AntLaunchConfigurationMessages.getString("AntLaunchDelegate.Running_{0}_2"), configuration.getName()), 100);
        }
        ExpandVariableContext resourceContext = ExternalToolsUtil.getVariableContext();
        monitor.worked(1);
        if (monitor.isCanceled()) {
            return;
        }
        IPath location = ExternalToolsUtil.getLocation(configuration, resourceContext);
        monitor.worked(1);
        if (monitor.isCanceled()) {
            return;
        }
        if (AntRunner.isBuildRunning()) {
            Status status = new Status(4, "org.eclipse.ui.externaltools", 1, MessageFormat.format(AntLaunchConfigurationMessages.getString("AntLaunchDelegate.Build_In_Progress"), location.toOSString()), null);
            throw new CoreException((IStatus)status);
        }
        IPath workingDirectory = ExternalToolsUtil.getWorkingDirectory(configuration, resourceContext);
        String baseDir = null;
        if (workingDirectory != null) {
            baseDir = workingDirectory.toOSString();
        }
        monitor.worked(1);
        if (monitor.isCanceled()) {
            return;
        }
        long timeStamp = System.currentTimeMillis();
        String idStamp = Long.toString(timeStamp);
        String idProperty = "-Dorg.eclipse.ui.externaltools.ATTR_ANT_PROCESS_ID=" + idStamp;
        String[] arguments = ExternalToolsUtil.getArguments(configuration, resourceContext);
        int argLength = 1;
        if (arguments != null) {
            argLength += arguments.length;
        }
        if (baseDir != null && baseDir.length() > 0) {
            ++argLength;
        }
        String[] runnerArgs = new String[argLength];
        if (arguments != null) {
            System.arraycopy(arguments, 0, runnerArgs, 0, arguments.length);
        }
        if (baseDir != null && baseDir.length() > 0) {
            runnerArgs[runnerArgs.length - 2] = BASE_DIR_PREFIX + baseDir;
        }
        runnerArgs[runnerArgs.length - 1] = idProperty;
        Map userProperties = AntUtil.getProperties(configuration);
        String[] propertyFiles = AntUtil.getPropertyFiles(configuration);
        final AntRunner runner = new AntRunner();
        runner.setBuildFileLocation(location.toOSString());
        if (ExternalToolsUtil.getCaptureOutput(configuration)) {
            runner.addBuildLogger(ANT_LOGGER_CLASS);
        } else {
            runner.addBuildLogger(NULL_LOGGER_CLASS);
        }
        runner.setInputHandler(INPUT_HANDLER_CLASS);
        runner.setArguments(runnerArgs);
        if (userProperties != null) {
            runner.addUserProperties(userProperties);
        }
        if (propertyFiles != null) {
            runner.setPropertyFiles(propertyFiles);
        }
        if ((targets = AntUtil.getTargetsFromConfig(configuration)) != null) {
            runner.setExecutionTargets(targets);
        }
        if ((customClasspath = AntUtil.getCustomClasspath(configuration)) != null) {
            runner.setCustomClasspath(customClasspath);
        }
        if ((antHome = AntUtil.getAntHome(configuration)) != null) {
            runner.setAntHome(antHome);
        }
        monitor.worked(1);
        if (monitor.isCanceled()) {
            return;
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(IProcess.ATTR_PROCESS_TYPE, "org.eclipse.ui.externaltools.ant");
        attributes.put("org.eclipse.ui.externaltools.ATTR_ANT_PROCESS_ID", idStamp);
        final AntProcess process = new AntProcess(location.toOSString(), launch, attributes);
        StringBuffer commandLine = this.generateCommandLine(location, arguments, userProperties, propertyFiles, targets, antHome);
        process.setAttribute(IProcess.ATTR_CMDLINE, commandLine.toString());
        if (ExternalToolsUtil.isBackground(configuration)) {
            Runnable r = new Runnable(){

                public void run() {
                    try {
                        runner.run((IProgressMonitor)process);
                    }
                    catch (CoreException coreException) {}
                    process.terminated();
                }
            };
            Thread background = new Thread(r);
            background.start();
            monitor.worked(1);
            if (ExternalToolsUtil.getRefreshScope(configuration) != null) {
                BackgroundResourceRefresher refresher = new BackgroundResourceRefresher(configuration, process, resourceContext);
                refresher.startBackgroundRefresh();
            }
        } else {
            try {
                runner.run(monitor);
            }
            catch (CoreException e) {
                process.terminated();
                throw e;
            }
            process.terminated();
            ExternalToolsUtil.refreshResources(configuration, resourceContext, monitor);
        }
        monitor.done();
    }

    private StringBuffer generateCommandLine(IPath location, String[] arguments, Map userProperties, String[] propertyFiles, String[] targets, String antHome) {
        int i;
        StringBuffer commandLine = new StringBuffer();
        if (antHome != null) {
            commandLine.append(antHome);
            commandLine.append(File.separator);
        }
        commandLine.append("ant");
        if (arguments != null) {
            i = 0;
            while (i < arguments.length) {
                String arg = arguments[i];
                commandLine.append(' ');
                commandLine.append(arg);
                ++i;
            }
        }
        if (propertyFiles != null) {
            i = 0;
            while (i < propertyFiles.length) {
                String path = propertyFiles[i];
                commandLine.append(" -propertyfile ");
                commandLine.append(path);
                ++i;
            }
        }
        if (userProperties != null) {
            Iterator keys = userProperties.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                commandLine.append(" -D");
                commandLine.append(key);
                commandLine.append('=');
                String value = (String)userProperties.get(key);
                commandLine.append(value);
            }
        }
        commandLine.append(" -inputhandler ");
        commandLine.append(INPUT_HANDLER_CLASS);
        commandLine.append(" -logger ");
        commandLine.append(ANT_LOGGER_CLASS);
        commandLine.append(" -buildfile ");
        commandLine.append(location.toOSString());
        if (targets != null) {
            int i2 = 0;
            while (i2 < targets.length) {
                commandLine.append(" ");
                commandLine.append(targets[i2]);
                ++i2;
            }
        }
        return commandLine;
    }
}

