/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.launchConfigurations;

import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.console.ConsoleColorProvider;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.externaltools.internal.ant.launchConfigurations.AntProcess;
import org.eclipse.ui.externaltools.internal.ant.launchConfigurations.AntStreamsProxy;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;

public class AntConsoleColorProvider
extends ConsoleColorProvider {
    public Color getColor(String streamIdentifer) {
        if (streamIdentifer.equals(IDebugUIConstants.ID_STANDARD_OUTPUT_STREAM)) {
            return ExternalToolsPlugin.getPreferenceColor("externaltools.console.infoColor");
        }
        if (streamIdentifer.equals(IDebugUIConstants.ID_STANDARD_ERROR_STREAM)) {
            return ExternalToolsPlugin.getPreferenceColor("externaltools.console.errorColor");
        }
        if (streamIdentifer.equals("org.eclipse.ui.externaltools.ANT_DEBUG_STREAM")) {
            return ExternalToolsPlugin.getPreferenceColor("externaltools.console.debugColor");
        }
        if (streamIdentifer.equals("org.eclipse.ui.externaltools.ANT_VERBOSE_STREAM")) {
            return ExternalToolsPlugin.getPreferenceColor("externaltools.console.verboseColor");
        }
        if (streamIdentifer.equals("org.eclipse.ui.externaltools.ANT_WARNING_STREAM")) {
            return ExternalToolsPlugin.getPreferenceColor("externaltools.console.warningColor");
        }
        return super.getColor(streamIdentifer);
    }

    public void connect(IProcess process, IConsole console) {
        AntStreamsProxy proxy = (AntStreamsProxy)process.getStreamsProxy();
        ((AntProcess)process).setConsole(console);
        console.connect(proxy.getDebugStreamMonitor(), "org.eclipse.ui.externaltools.ANT_DEBUG_STREAM");
        console.connect(proxy.getWarningStreamMonitor(), "org.eclipse.ui.externaltools.ANT_WARNING_STREAM");
        console.connect(proxy.getVerboseStreamMonitor(), "org.eclipse.ui.externaltools.ANT_VERBOSE_STREAM");
        super.connect(process, console);
    }
}

