/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.launchConfigurations;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.externaltools.internal.ant.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.ui.externaltools.internal.ant.model.AntUtil;
import org.eclipse.ui.externaltools.internal.ant.preferences.AntClasspathBlock;
import org.eclipse.ui.externaltools.internal.ant.preferences.IAntBlockContainer;
import org.eclipse.ui.help.WorkbenchHelp;

public class AntClasspathTab
extends AbstractLaunchConfigurationTab
implements IAntBlockContainer {
    private Button useDefaultButton;
    private AntClasspathBlock antClasspathBlock = new AntClasspathBlock();

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)top);
        WorkbenchHelp.setHelp((Control)top, (String)"org.eclipse.ui.externaltools.ant_classpath_tab_context");
        this.createChangeClasspath(top);
        this.antClasspathBlock.setContainer(this);
        this.antClasspathBlock.createContents(top);
    }

    private void createChangeClasspath(Composite top) {
        Composite changeClasspath = new Composite(top, 0);
        changeClasspath.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        changeClasspath.setLayout((Layout)layout);
        changeClasspath.setFont(top.getFont());
        this.useDefaultButton = new Button(changeClasspath, 32);
        this.useDefaultButton.setFont(top.getFont());
        this.useDefaultButton.setText(AntLaunchConfigurationMessages.getString("AntClasspathTab.Use_&global"));
        this.useDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                AntClasspathTab.this.toggleUseDefaultClasspath();
                AntClasspathTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void toggleUseDefaultClasspath() {
        boolean enable = !this.useDefaultButton.getSelection();
        this.antClasspathBlock.setEnabled(enable);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        String urlStrings = null;
        try {
            urlStrings = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_CUSTOM_CLASSPATH", null);
        }
        catch (CoreException coreException) {}
        if (urlStrings == null) {
            this.useDefaultButton.setSelection(true);
            this.antClasspathBlock.setTablesEnabled(false);
            this.antClasspathBlock.initializeAntHome(null);
        } else {
            String antHomeString = null;
            try {
                antHomeString = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_HOME", null);
            }
            catch (CoreException coreException) {}
            this.antClasspathBlock.initializeAntHome(antHomeString);
            this.useDefaultButton.setSelection(false);
            ArrayList userURLs = new ArrayList();
            ArrayList antURLs = new ArrayList();
            AntUtil.getCustomClasspaths(configuration, antURLs, userURLs);
            this.antClasspathBlock.setUserTableInput(userURLs);
            this.antClasspathBlock.setAntTableInput(antURLs);
            this.antClasspathBlock.setTablesEnabled(true);
        }
        this.toggleUseDefaultClasspath();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.useDefaultButton.getSelection()) {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_CUSTOM_CLASSPATH", null);
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_HOME", null);
            return;
        }
        List antUrls = this.antClasspathBlock.getAntURLs();
        List userUrls = this.antClasspathBlock.getUserURLs();
        StringBuffer urlString = new StringBuffer();
        Iterator antUrlsItr = antUrls.iterator();
        while (antUrlsItr.hasNext()) {
            URL url = (URL)antUrlsItr.next();
            urlString.append(url.getFile());
            urlString.append(',');
        }
        if (userUrls.size() > 0) {
            urlString.append('*');
        }
        Iterator userUrlsItr = userUrls.iterator();
        while (userUrlsItr.hasNext()) {
            URL url = (URL)userUrlsItr.next();
            urlString.append(url.getFile());
            urlString.append(',');
        }
        if (urlString.length() > 0) {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_CUSTOM_CLASSPATH", urlString.substring(0, urlString.length() - 1));
        } else {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_CUSTOM_CLASSPATH", null);
        }
        String antHomeText = this.antClasspathBlock.getAntHome();
        configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_HOME", antHomeText);
    }

    public String getName() {
        return AntLaunchConfigurationMessages.getString("AntClasspathTab.Classpath_6");
    }

    public Image getImage() {
        return this.antClasspathBlock.getClasspathImage();
    }

    public boolean canSave() {
        if (this.antClasspathBlock.isAntHomeEnabled()) {
            return this.antClasspathBlock.validateAntHome();
        }
        return super.canSave();
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.antClasspathBlock.isAntHomeEnabled()) {
            return this.antClasspathBlock.validateAntHome();
        }
        return super.isValid(launchConfig);
    }

    public void setMessage(String message) {
        super.setMessage(message);
    }

    public void setErrorMessage(String message) {
        super.setErrorMessage(message);
    }

    public Button createPushButton(Composite parent, String buttonText) {
        return super.createPushButton(parent, buttonText, null);
    }

    public void update() {
        this.updateLaunchConfigurationDialog();
    }
}

