/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.editor.xml;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.xerces.util.URI;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.externaltools.internal.ant.editor.PlantyException;
import org.eclipse.ui.externaltools.internal.ant.editor.xml.AntEditorXMLMessages;
import org.eclipse.ui.externaltools.internal.ant.editor.xml.XmlAttribute;
import org.eclipse.ui.externaltools.internal.ant.model.AntUtil;

public class XmlElement
implements IAdaptable {
    protected int offset;
    protected int length;
    protected XmlElement parent;
    protected List attributes = new ArrayList();
    protected List childNodes = new ArrayList();
    protected String name;
    protected int startingRow;
    protected int startingColumn;
    protected int endingRow;
    protected int endingColumn;
    private boolean isErrorNode;
    private String filePath;
    private boolean isExternal = false;
    private boolean isRootExternal = false;
    private String fElementPath;
    private String fElementIdentifier;
    static /* synthetic */ Class class$0;

    public XmlElement(String aName) {
        this.name = aName;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public List getChildNodes() {
        return this.childNodes;
    }

    public XmlElement getParentNode() {
        return this.parent;
    }

    public void addChildNode(XmlElement aChildElement) {
        if (aChildElement.getParentNode() != null) {
            throw new PlantyException(MessageFormat.format(AntEditorXMLMessages.getString("XmlElement.XmlElement_cannot_be_added_as_a_child"), aChildElement.toString(), aChildElement.getParentNode().toString()));
        }
        aChildElement.parent = this;
        this.childNodes.add(aChildElement);
    }

    public List getAttributes() {
        return this.attributes;
    }

    public void addAttribute(XmlAttribute anAttribute) {
        this.attributes.add(anAttribute);
    }

    public XmlAttribute getAttributeNamed(String anAttributeName) {
        Iterator i = this.attributes.iterator();
        while (i.hasNext()) {
            XmlAttribute anAttribute = (XmlAttribute)i.next();
            if (!anAttributeName.equals(anAttribute.name)) continue;
            return anAttribute;
        }
        return null;
    }

    public int getStartingColumn() {
        return this.startingColumn;
    }

    public int getStartingRow() {
        return this.startingRow;
    }

    public int getEndingRow() {
        return this.endingRow;
    }

    public void setEndingRow(int endingRow) {
        this.endingRow = endingRow;
    }

    public int getEndingColumn() {
        return this.endingColumn;
    }

    public void setFilePath(String path) {
        URI uri = null;
        try {
            uri = new URI(path);
        }
        catch (URI.MalformedURIException malformedURIException) {
            this.filePath = path;
            return;
        }
        this.filePath = new Path(new File(uri.getPath()).getAbsolutePath()).toString();
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setEndingColumn(int endingColumn) {
        this.endingColumn = endingColumn;
    }

    public void setStartingColumn(int startingColumn) {
        this.startingColumn = startingColumn;
    }

    public void setStartingRow(int startingRow) {
        this.startingRow = startingRow;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int anOffset) {
        this.offset = anOffset;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int aLength) {
        this.length = aLength;
    }

    public String toString() {
        return MessageFormat.format(AntEditorXMLMessages.getString("XmlElement.XmlElement_toString"), this.name, Integer.toString(this.startingRow), Integer.toString(this.startingColumn), Integer.toString(this.endingRow), Integer.toString(this.endingColumn));
    }

    public boolean isErrorNode() {
        return this.isErrorNode;
    }

    public void setIsErrorNode(boolean isErrorNode) {
        this.isErrorNode = isErrorNode;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public void setExternal(boolean isExternal) {
        this.isExternal = isExternal;
    }

    public void setRootExternal(boolean isExternal) {
        this.isRootExternal = isExternal;
    }

    public boolean isRootExternal() {
        return this.isRootExternal;
    }

    public String getElementPath() {
        if (this.fElementPath == null) {
            StringBuffer buffer = new StringBuffer(this.getParentNode() != null ? this.getParentNode().getElementPath() : "");
            buffer.append('/');
            buffer.append(this.getElementIdentifier());
            buffer.append('[');
            buffer.append(this.getParentNode() != null ? this.getParentNode().getElementIndexOf(this) : 0);
            buffer.append(']');
            this.fElementPath = buffer.toString();
        }
        return this.fElementPath;
    }

    private String getElementIdentifier() {
        if (this.fElementIdentifier == null) {
            StringBuffer buffer = this.escape(new StringBuffer(this.getName() != null ? this.getName() : ""), '\\', "$/[]\\");
            buffer.append('$');
            buffer.append(this.escape(new StringBuffer(this.getDisplayName() != null ? this.getDisplayName() : ""), '\\', "$/[]\\").toString());
            this.fElementIdentifier = buffer.toString();
        }
        return this.fElementIdentifier;
    }

    private StringBuffer escape(StringBuffer sb, char esc, String special) {
        int i = 0;
        while (i < sb.length()) {
            if (special.indexOf(sb.charAt(i)) >= 0) {
                sb.insert(i++, esc);
            }
            ++i;
        }
        return sb;
    }

    private int getElementIndexOf(XmlElement child) {
        if (this.getChildNodes() == null) {
            return -1;
        }
        int result = -1;
        Iterator iter = this.getChildNodes().iterator();
        XmlElement current = null;
        while (current != child && iter.hasNext()) {
            current = (XmlElement)iter.next();
            if (!child.getElementIdentifier().equals(current.getElementIdentifier())) continue;
            ++result;
        }
        if (current != child) {
            return -1;
        }
        return result;
    }

    public boolean equals(Object o2) {
        XmlElement o1 = this;
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (!(o1 instanceof XmlElement) && !(o2 instanceof XmlElement)) {
            return o2.equals(o1);
        }
        if (!(o1 instanceof XmlElement) || !(o2 instanceof XmlElement)) {
            return false;
        }
        XmlElement e1 = o1;
        XmlElement e2 = (XmlElement)o2;
        return e1.getElementPath().equals(e2.getElementPath());
    }

    public int hashCode() {
        XmlElement o1 = this;
        if (o1 == null) {
            return 0;
        }
        if (!(o1 instanceof XmlElement)) {
            return ((Object)o1).hashCode();
        }
        XmlElement e1 = o1;
        return e1.getElementPath().hashCode();
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz && this.getFilePath() != null) {
            return AntUtil.getFile(this.getFilePath());
        }
        return null;
    }
}

