/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.editor.text;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.externaltools.internal.ant.editor.derived.HTMLPrinter;
import org.eclipse.ui.externaltools.internal.ant.editor.text.IXMLAnnotation;
import org.eclipse.ui.externaltools.internal.ant.editor.text.XMLAnnotationIterator;

public class XMLTextHover
implements ITextHover {
    private String formatMessage(String message) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addPageProlog(buffer);
        HTMLPrinter.addParagraph(buffer, HTMLPrinter.convertToHTMLContent(message));
        HTMLPrinter.addPageEpilog(buffer);
        return buffer.toString();
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        if (!(textViewer instanceof ISourceViewer)) {
            return null;
        }
        ISourceViewer sourceViewer = (ISourceViewer)textViewer;
        IAnnotationModel model = sourceViewer.getAnnotationModel();
        if (model != null) {
            XMLAnnotationIterator e = new XMLAnnotationIterator(model, true);
            while (e.hasNext()) {
                String msg;
                Annotation a = (Annotation)e.next();
                Position p = model.getPosition(a);
                if (!p.overlapsWith(hoverRegion.getOffset(), hoverRegion.getLength()) || (msg = ((IXMLAnnotation)a).getMessage()) == null || msg.trim().length() <= 0) continue;
                return this.formatMessage(msg);
            }
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        int startOffset = offset > 0 ? offset - 1 : offset;
        int documentLength = textViewer.getDocument() != null ? textViewer.getDocument().getLength() : 0;
        int endOffset = offset < documentLength - 1 ? offset + 1 : offset;
        return new Region(startOffset, endOffset - startOffset);
    }
}

