/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.editor.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.externaltools.internal.ant.editor.outline.IProblem;
import org.eclipse.ui.externaltools.internal.ant.editor.text.AnnotationType;
import org.eclipse.ui.externaltools.internal.ant.editor.text.IXMLAnnotation;

public class XMLProblemAnnotation
extends Annotation
implements IXMLAnnotation {
    private List fOverlaids;
    private IProblem fProblem;
    private AnnotationType fType;

    public XMLProblemAnnotation(IProblem problem) {
        this.fProblem = problem;
        this.setLayer(6);
        this.fType = this.fProblem.isError() ? AnnotationType.ERROR : (this.fProblem.isWarning() ? AnnotationType.WARNING : AnnotationType.INFO);
    }

    public void paint(GC gc, Canvas canvas, Rectangle r) {
    }

    public Image getImage(Display display) {
        return null;
    }

    public String getMessage() {
        return this.fProblem.getMessage();
    }

    public boolean isTemporary() {
        return true;
    }

    public boolean isProblem() {
        return this.fType == AnnotationType.WARNING || this.fType == AnnotationType.ERROR;
    }

    public boolean isRelevant() {
        return true;
    }

    public boolean hasOverlay() {
        return false;
    }

    public void addOverlaid(IXMLAnnotation annotation) {
        if (this.fOverlaids == null) {
            this.fOverlaids = new ArrayList(1);
        }
        this.fOverlaids.add(annotation);
    }

    public void removeOverlaid(IXMLAnnotation annotation) {
        if (this.fOverlaids != null) {
            this.fOverlaids.remove(annotation);
            if (this.fOverlaids.size() == 0) {
                this.fOverlaids = null;
            }
        }
    }

    public Iterator getOverlaidIterator() {
        if (this.fOverlaids != null) {
            return this.fOverlaids.iterator();
        }
        return null;
    }

    public AnnotationType getAnnotationType() {
        return this.fType;
    }
}

