/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.editor.text;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.Assert;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.externaltools.internal.ant.editor.text.AnnotationType;
import org.eclipse.ui.externaltools.internal.ant.editor.text.IXMLAnnotation;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class XMLMarkerAnnotation
extends MarkerAnnotation
implements IXMLAnnotation {
    private static final int NO_IMAGE = 0;
    private static final int ORIGINAL_MARKER_IMAGE = 1;
    private static final int OVERLAY_IMAGE = 4;
    private static final int GRAY_IMAGE = 5;
    private static ImageRegistry fgGrayMarkersImageRegistry;
    private IXMLAnnotation fOverlay;
    private boolean fNotRelevant = false;
    private AnnotationType fType;
    private int fImageType;

    public XMLMarkerAnnotation(IMarker marker) {
        super(marker);
    }

    protected void initialize() {
        this.fImageType = 0;
        IMarker marker = this.getMarker();
        this.fType = AnnotationType.UNKNOWN;
        try {
            if (marker != null && marker.exists()) {
                if (marker.isSubtypeOf("org.eclipse.core.resources.bookmark")) {
                    this.fType = AnnotationType.BOOKMARK;
                } else if (marker.isSubtypeOf("org.eclipse.core.resources.taskmarker")) {
                    this.fType = AnnotationType.TASK;
                } else if (marker.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
                    int severity = marker.getAttribute("severity", -1);
                    switch (severity) {
                        case 2: {
                            this.fType = AnnotationType.ERROR;
                            break;
                        }
                        case 1: {
                            this.fType = AnnotationType.WARNING;
                            break;
                        }
                        case 0: {
                            this.fType = AnnotationType.INFO;
                        }
                    }
                }
            }
        }
        catch (CoreException e) {
            ExternalToolsPlugin.getDefault().log(e);
        }
        super.initialize();
    }

    public String getMessage() {
        IMarker marker = this.getMarker();
        if (marker == null || !marker.exists()) {
            return "";
        }
        return marker.getAttribute("message", "");
    }

    public boolean isTemporary() {
        return false;
    }

    public boolean isProblem() {
        return this.fType == AnnotationType.WARNING || this.fType == AnnotationType.ERROR;
    }

    public boolean isRelevant() {
        return !this.fNotRelevant;
    }

    public void setOverlay(IXMLAnnotation xmlAnnotation) {
        if (this.fOverlay != null) {
            this.fOverlay.removeOverlaid(this);
        }
        this.fOverlay = xmlAnnotation;
        boolean bl = this.fNotRelevant = this.fNotRelevant || this.fOverlay != null;
        if (xmlAnnotation != null) {
            xmlAnnotation.addOverlaid(this);
        }
    }

    public boolean hasOverlay() {
        return this.fOverlay != null;
    }

    public Image getImage(Display display) {
        int newImageType = 0;
        newImageType = this.hasOverlay() ? 4 : (this.isRelevant() ? 1 : 5);
        if (this.fImageType == newImageType && newImageType != 4) {
            return super.getImage(display);
        }
        Image newImage = null;
        switch (newImageType) {
            case 1: {
                newImage = null;
                break;
            }
            case 4: {
                newImage = this.fOverlay.getImage(display);
                break;
            }
            case 5: {
                ImageRegistry imageRegistry;
                Image originalImage;
                if (this.fImageType != 1) {
                    this.setImage(null);
                }
                if ((originalImage = super.getImage(display)) == null || (imageRegistry = this.getGrayMarkerImageRegistry(display)) == null) break;
                String key = Integer.toString(originalImage.hashCode());
                Image grayImage = imageRegistry.get(key);
                if (grayImage == null) {
                    grayImage = new Image((Device)display, originalImage, 2);
                    imageRegistry.put(key, grayImage);
                }
                newImage = grayImage;
                break;
            }
            default: {
                Assert.isLegal((boolean)false);
            }
        }
        this.fImageType = newImageType;
        this.setImage(newImage);
        return super.getImage(display);
    }

    private ImageRegistry getGrayMarkerImageRegistry(Display display) {
        if (fgGrayMarkersImageRegistry == null) {
            fgGrayMarkersImageRegistry = new ImageRegistry(display);
        }
        return fgGrayMarkersImageRegistry;
    }

    public void addOverlaid(IXMLAnnotation annotation) {
    }

    public void removeOverlaid(IXMLAnnotation annotation) {
    }

    public Iterator getOverlaidIterator() {
        return null;
    }

    public AnnotationType getAnnotationType() {
        return this.fType;
    }
}

