/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.editor.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.rules.DefaultPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.editors.text.StorageDocumentProvider;
import org.eclipse.ui.externaltools.internal.ant.editor.outline.AntModel;
import org.eclipse.ui.externaltools.internal.ant.editor.outline.IProblem;
import org.eclipse.ui.externaltools.internal.ant.editor.outline.IProblemRequestor;
import org.eclipse.ui.externaltools.internal.ant.editor.outline.LocationProvider;
import org.eclipse.ui.externaltools.internal.ant.editor.outline.XMLCore;
import org.eclipse.ui.externaltools.internal.ant.editor.text.PartiallySynchronizedDocument;
import org.eclipse.ui.externaltools.internal.ant.editor.text.PlantyPartitionScanner;
import org.eclipse.ui.externaltools.internal.ant.editor.text.XMLMarkerAnnotation;
import org.eclipse.ui.externaltools.internal.ant.editor.text.XMLProblemAnnotation;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class PlantyDocumentProvider
extends FileDocumentProvider {
    private XMLCore fCore;

    public PlantyDocumentProvider(XMLCore core) {
        this.fCore = core;
    }

    private IDocumentPartitioner createDocumentPartitioner() {
        DefaultPartitioner partitioner = new DefaultPartitioner((IPartitionTokenScanner)new PlantyPartitionScanner(), new String[]{"__xml_tag", "__xml_comment"});
        return partitioner;
    }

    public IDocument createDocument(Object element) throws CoreException {
        PartiallySynchronizedDocument document;
        if (element instanceof IEditorInput) {
            document = new PartiallySynchronizedDocument();
            if (this.setDocumentContent((IDocument)document, (IEditorInput)element, this.getEncoding(element))) {
                this.initializeDocument((IDocument)document);
            }
        } else {
            document = null;
        }
        return document;
    }

    protected void initializeDocument(IDocument document) {
        IDocumentPartitioner partitioner = this.createDocumentPartitioner();
        document.setDocumentPartitioner(partitioner);
        partitioner.connect(document);
    }

    public AntModel getAntModel(Object element) {
        AbstractDocumentProvider.ElementInfo info = this.getElementInfo(element);
        if (info instanceof XMLFileInfo) {
            XMLFileInfo xmlInfo = (XMLFileInfo)info;
            return xmlInfo.fModel;
        }
        return null;
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            return new XMLAnnotationModel(input);
        }
        return super.createAnnotationModel(element);
    }

    protected AntModel createAntModel(Object element, IDocument document, IAnnotationModel annotationModel) {
        IProblemRequestor requestor = annotationModel instanceof IProblemRequestor ? (IProblemRequestor)annotationModel : null;
        return new AntModel(this.fCore, document, requestor, new LocationProvider(element instanceof IFileEditorInput ? ((IFileEditorInput)element).getFile() : null));
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object element) throws CoreException {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            try {
                this.refreshFile(input.getFile());
            }
            catch (CoreException x) {
                this.handleCoreException(x, "XMLDocumentProvider.createElementInfo: Core exception");
            }
            IDocument d = null;
            IStatus s = null;
            try {
                d = this.createDocument(element);
            }
            catch (CoreException x) {
                s = x.getStatus();
                d = this.createEmptyDocument();
            }
            IAnnotationModel m = this.createAnnotationModel(element);
            AntModel o = this.createAntModel(element, d, m);
            o.install();
            FileDocumentProvider.FileSynchronizer f = new FileDocumentProvider.FileSynchronizer((FileDocumentProvider)this, input);
            f.install();
            XMLFileInfo info = new XMLFileInfo(d, m, f, o);
            info.fModificationStamp = this.computeModificationStamp((IResource)input.getFile());
            ((AbstractDocumentProvider.ElementInfo)info).fStatus = s;
            ((StorageDocumentProvider.StorageInfo)info).fEncoding = this.getPersistedEncoding(input);
            return info;
        }
        return super.createElementInfo(element);
    }

    protected void disposeElementInfo(Object element, AbstractDocumentProvider.ElementInfo info) {
        if (info instanceof XMLFileInfo) {
            XMLFileInfo xmlInfo = (XMLFileInfo)info;
            if (xmlInfo.fModel != null) {
                xmlInfo.fModel.dispose();
            }
        }
        super.disposeElementInfo(element, info);
    }

    protected class XMLAnnotationModel
    extends ResourceMarkerAnnotationModel
    implements IProblemRequestor {
        private IFileEditorInput fInput;
        private List fGeneratedAnnotations = new ArrayList();
        private List fCollectedProblems = new ArrayList();
        private ReverseMap fReverseMap = new ReverseMap();
        private List fPreviouslyOverlaid = null;
        private List fCurrentlyOverlaid = new ArrayList();

        public XMLAnnotationModel(IFileEditorInput input) {
            super((IResource)input.getFile());
            this.fInput = input;
        }

        protected MarkerAnnotation createMarkerAnnotation(IMarker marker) {
            return new XMLMarkerAnnotation(marker);
        }

        protected Position createPositionFromProblem(IProblem problem) {
            int length;
            int start = problem.getOffset();
            if (start >= 0 && (length = problem.getLength()) >= 0) {
                return new Position(start, length);
            }
            return null;
        }

        public void acceptProblem(IProblem problem) {
            this.fCollectedProblems.add(problem);
        }

        public void beginReporting() {
        }

        public void endReporting() {
            boolean temporaryProblemsChanged = false;
            this.fPreviouslyOverlaid = this.fCurrentlyOverlaid;
            this.fCurrentlyOverlaid = new ArrayList();
            Map map = ((AnnotationModel)this).fAnnotations;
            synchronized (map) {
                if (this.fGeneratedAnnotations.size() > 0) {
                    temporaryProblemsChanged = true;
                    this.removeAnnotations(this.fGeneratedAnnotations, false, true);
                    this.fGeneratedAnnotations.clear();
                }
                if (this.fCollectedProblems != null && this.fCollectedProblems.size() > 0) {
                    Iterator e = this.fCollectedProblems.iterator();
                    while (e.hasNext()) {
                        IProblem problem = (IProblem)e.next();
                        Position position = this.createPositionFromProblem(problem);
                        if (position == null) continue;
                        XMLProblemAnnotation annotation = new XMLProblemAnnotation(problem);
                        this.overlayMarkers(position, annotation);
                        this.fGeneratedAnnotations.add(annotation);
                        this.addAnnotation(annotation, position, false);
                        temporaryProblemsChanged = true;
                    }
                    this.fCollectedProblems.clear();
                }
                this.removeMarkerOverlays();
                this.fPreviouslyOverlaid.clear();
                this.fPreviouslyOverlaid = null;
            }
            if (temporaryProblemsChanged) {
                this.fireModelChanged(new AnnotationModelEvent((IAnnotationModel)this));
            }
        }

        private void removeMarkerOverlays() {
            Iterator e = this.fPreviouslyOverlaid.iterator();
            while (e.hasNext()) {
                XMLMarkerAnnotation annotation = (XMLMarkerAnnotation)e.next();
                annotation.setOverlay(null);
            }
        }

        private void setOverlay(Object value, XMLProblemAnnotation problemAnnotation) {
            XMLMarkerAnnotation annotation;
            if (value instanceof XMLMarkerAnnotation && (annotation = (XMLMarkerAnnotation)value).isProblem()) {
                annotation.setOverlay(problemAnnotation);
                this.fPreviouslyOverlaid.remove(annotation);
                this.fCurrentlyOverlaid.add(annotation);
            }
        }

        private void overlayMarkers(Position position, XMLProblemAnnotation problemAnnotation) {
            Object value = this.getAnnotations(position);
            if (value instanceof List) {
                List list = (List)value;
                Iterator e = list.iterator();
                while (e.hasNext()) {
                    this.setOverlay(e.next(), problemAnnotation);
                }
            } else {
                this.setOverlay(value, problemAnnotation);
            }
        }

        private Object getAnnotations(Position position) {
            return this.fReverseMap.get(position);
        }

        protected void addAnnotation(Annotation annotation, Position position, boolean fireModelChanged) {
            super.addAnnotation(annotation, position, fireModelChanged);
            Object cached = this.fReverseMap.get(position);
            if (cached == null) {
                this.fReverseMap.put(position, annotation);
            } else if (cached instanceof List) {
                List list = (List)cached;
                list.add(annotation);
            } else if (cached instanceof Annotation) {
                ArrayList<Object> list = new ArrayList<Object>(2);
                list.add(cached);
                list.add(annotation);
                this.fReverseMap.put(position, list);
            }
        }

        protected void removeAllAnnotations(boolean fireModelChanged) {
            super.removeAllAnnotations(fireModelChanged);
            this.fReverseMap.clear();
        }

        protected void removeAnnotation(Annotation annotation, boolean fireModelChanged) {
            Position position = this.getPosition(annotation);
            Object cached = this.fReverseMap.get(position);
            if (cached instanceof List) {
                List list = (List)cached;
                list.remove(annotation);
                if (list.size() == 1) {
                    this.fReverseMap.put(position, list.get(0));
                    list.clear();
                }
            } else if (cached instanceof Annotation) {
                this.fReverseMap.remove(position);
            }
            super.removeAnnotation(annotation, fireModelChanged);
        }
    }

    protected class XMLFileInfo
    extends FileDocumentProvider.FileInfo {
        public AntModel fModel;

        public XMLFileInfo(IDocument document, IAnnotationModel annotationModel, FileDocumentProvider.FileSynchronizer fileSynchronizer, AntModel model) {
            super((FileDocumentProvider)PlantyDocumentProvider.this, document, annotationModel, fileSynchronizer);
            this.fModel = model;
        }
    }

    protected static class ReverseMap {
        private List fList = new ArrayList(2);
        private int fAnchor = 0;

        public Object get(Position position) {
            Entry entry;
            int length = this.fList.size();
            int i = this.fAnchor;
            while (i < length) {
                entry = (Entry)this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    this.fAnchor = i;
                    return entry.fValue;
                }
                ++i;
            }
            i = 0;
            while (i < this.fAnchor) {
                entry = (Entry)this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    this.fAnchor = i;
                    return entry.fValue;
                }
                ++i;
            }
            return null;
        }

        private int getIndex(Position position) {
            int length = this.fList.size();
            int i = 0;
            while (i < length) {
                Entry entry = (Entry)this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public void put(Position position, Object value) {
            int index = this.getIndex(position);
            if (index == -1) {
                Entry entry = new Entry();
                entry.fPosition = position;
                entry.fValue = value;
                this.fList.add(entry);
            } else {
                Entry entry = (Entry)this.fList.get(index);
                entry.fValue = value;
            }
        }

        public void remove(Position position) {
            int index = this.getIndex(position);
            if (index > -1) {
                this.fList.remove(index);
            }
        }

        public void clear() {
            this.fList.clear();
        }

        static class Entry {
            Position fPosition;
            Object fValue;

            Entry() {
            }
        }
    }
}

