/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.editor.outline;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.externaltools.internal.ant.editor.outline.AntModel;
import org.eclipse.ui.externaltools.internal.ant.editor.outline.AntOutlineMessages;
import org.eclipse.ui.externaltools.internal.ant.editor.outline.DocumentModelChangeEvent;
import org.eclipse.ui.externaltools.internal.ant.editor.outline.IDocumentModelListener;
import org.eclipse.ui.externaltools.internal.ant.editor.outline.ILocationProvider;
import org.eclipse.ui.externaltools.internal.ant.editor.outline.XMLCore;
import org.eclipse.ui.externaltools.internal.ant.editor.xml.XmlAttribute;
import org.eclipse.ui.externaltools.internal.ant.editor.xml.XmlElement;
import org.eclipse.ui.externaltools.internal.ant.model.AntUtil;
import org.eclipse.ui.externaltools.internal.ant.view.actions.AntOpenWithMenu;
import org.eclipse.ui.externaltools.internal.model.AntImageDescriptor;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsImages;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class PlantyContentOutlinePage
extends ContentOutlinePage
implements IShowInSource,
IAdaptable {
    private static final int EXPAND_TO_LEVEL = 2;
    private Menu menu;
    private AntOpenWithMenu openWithMenu;
    private IDocumentModelListener fListener;
    private AntModel fModel;
    private XMLCore fCore;
    private ITextEditor fEditor;
    private ListenerList fPostSelectionChangedListeners = new ListenerList();
    private boolean fIsModelEmpty = true;
    static /* synthetic */ Class class$0;

    private boolean isDefaultTargetNode(XmlElement node) {
        XmlAttribute type = node.getAttributeNamed("type");
        if (type == null || !type.getValue().equals("target")) {
            return false;
        }
        XmlElement parent = node.getParentNode();
        if (parent != null) {
            type = parent.getAttributeNamed("type");
            while (!(parent == null || type != null && type.getValue().equals("project"))) {
                if ((parent = parent.getParentNode()) == null) continue;
                type = parent.getAttributeNamed("type");
            }
        }
        if (parent == null) {
            return false;
        }
        XmlAttribute defaultTarget = parent.getAttributeNamed("default");
        XmlAttribute nameAttribute = node.getAttributeNamed("name");
        return defaultTarget != null && nameAttribute != null && defaultTarget.getValue().equals(nameAttribute.getValue());
    }

    public PlantyContentOutlinePage(XMLCore core, ITextEditor editor) {
        this.fCore = core;
        this.fEditor = editor;
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
        }
        if (this.openWithMenu != null) {
            this.openWithMenu.dispose();
        }
        if (this.fListener != null) {
            this.fCore.removeDocumentModelListener(this.fListener);
            this.fListener = null;
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new PlantyContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new PlantyLabelProvider());
        if (this.fModel != null) {
            this.setViewerInput(this.fModel);
        }
        MenuManager manager = new MenuManager("#PopUp");
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                PlantyContentOutlinePage.this.contextMenuAboutToShow(manager);
            }
        });
        this.menu = manager.createContextMenu((Control)viewer.getTree());
        viewer.getTree().setMenu(this.menu);
        IPageSite site = this.getSite();
        site.registerContextMenu("org.eclipse.ui.externaltools.antEditorOutline", manager, (ISelectionProvider)viewer);
        this.openWithMenu = new AntOpenWithMenu(this.getSite().getPage());
        viewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PlantyContentOutlinePage.this.postSelectionChanged(event);
            }
        });
    }

    private void setViewerInput(Object newInput) {
        TreeViewer tree = this.getTreeViewer();
        Object oldInput = tree.getInput();
        boolean isAntModel = newInput instanceof AntModel;
        boolean wasAntModel = oldInput instanceof AntModel;
        if (isAntModel && !wasAntModel) {
            if (this.fListener == null) {
                this.fListener = this.createAntModelChangeListener();
            }
            this.fCore.addDocumentModelListener(this.fListener);
        } else if (!isAntModel && wasAntModel && this.fListener != null) {
            this.fCore.removeDocumentModelListener(this.fListener);
            this.fListener = null;
        }
        tree.setInput(newInput);
        if (isAntModel) {
            this.updateTreeExpansion();
        }
    }

    public void setPageInput(AntModel xmlModel) {
        this.fModel = xmlModel;
        if (this.getTreeViewer() != null) {
            this.setViewerInput(this.fModel);
        }
    }

    private IDocumentModelListener createAntModelChangeListener() {
        return new IDocumentModelListener(){

            public void documentModelChanged(DocumentModelChangeEvent event) {
                if (event.getModel() == PlantyContentOutlinePage.this.fModel && !PlantyContentOutlinePage.this.getControl().isDisposed()) {
                    PlantyContentOutlinePage.this.getControl().getDisplay().asyncExec(new Runnable(this){
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            Control ctrl = 3.access$0(this.this$1).getControl();
                            if (ctrl != null && !ctrl.isDisposed()) {
                                PlantyContentOutlinePage.access$3(3.access$0(this.this$1)).refresh();
                                PlantyContentOutlinePage.access$4(3.access$0(this.this$1));
                            }
                        }
                    });
                }
            }

            static /* synthetic */ PlantyContentOutlinePage access$0(3 var0) {
                return var0.PlantyContentOutlinePage.this;
            }
        };
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.fPostSelectionChangedListeners.add((Object)listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.fPostSelectionChangedListeners.remove((Object)listener);
    }

    private void updateTreeExpansion() {
        boolean wasModelEmpty = this.fIsModelEmpty;
        boolean bl = this.fIsModelEmpty = this.fModel == null || this.fModel.getRootElements() == null || this.fModel.getRootElements().length == 0;
        if (wasModelEmpty && !this.fIsModelEmpty) {
            this.getTreeViewer().expandToLevel(2);
        }
    }

    public void postSelectionChanged(SelectionChangedEvent event) {
        this.firePostSelectionChanged(event.getSelection());
    }

    private void firePostSelectionChanged(ISelection selection) {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Object[] listeners = this.fPostSelectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ISelectionChangedListener)listeners[i]).selectionChanged(event);
            ++i;
        }
    }

    private void contextMenuAboutToShow(IMenuManager menu) {
        if (this.shouldAddOpenWithMenu()) {
            this.addOpenWithMenu(menu);
        }
        menu.add((IContributionItem)new Separator("additions"));
    }

    private void addOpenWithMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        XmlElement element = (XmlElement)selection.getFirstElement();
        String path = this.getElementPath(element);
        if (path != null) {
            Path resourcePath = new Path(path);
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile resource = root.getFileForLocation((IPath)resourcePath);
            if (resource != null && resource.getType() == 1 && resource.exists()) {
                menu.add((IContributionItem)new Separator("group.open"));
                MenuManager submenu = new MenuManager(AntOutlineMessages.getString("PlantyContentOutlinePage.Open_With_1"));
                this.openWithMenu.setFile((IAdaptable)resource);
                submenu.add((IContributionItem)this.openWithMenu);
                menu.appendToGroup("group.open", (IContributionItem)submenu);
            }
        }
    }

    private String getElementPath(XmlElement element) {
        List children;
        String path = element.getFilePath();
        if (element.isRootExternal() && !(children = element.getChildNodes()).isEmpty()) {
            XmlElement child = (XmlElement)children.get(0);
            path = child.getFilePath();
        }
        return path;
    }

    private boolean shouldAddOpenWithMenu() {
        XmlElement element;
        Object selected;
        IStructuredSelection selection;
        ISelection iselection = this.getSelection();
        if (iselection instanceof IStructuredSelection && (selection = (IStructuredSelection)iselection).size() == 1 && (selected = selection.getFirstElement()) instanceof XmlElement && (element = (XmlElement)selected).isExternal()) {
            String path = this.getElementPath(element);
            if (path.length() == 0) {
                return false;
            }
            XmlElement parent = element.getParentNode();
            while (parent != null) {
                String parentPath = this.getElementPath(parent);
                if (path != null && !path.equals(parentPath)) {
                    return true;
                }
                parent = parent.getParentNode();
            }
        }
        return false;
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.part.IShowInSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz) {
            return this;
        }
        return null;
    }

    public ShowInContext getShowInContext() {
        if (this.fModel != null) {
            ILocationProvider locationProvider = this.fModel.getLocationProvider();
            IFile file = AntUtil.getFile(locationProvider.getLocation().toOSString());
            StructuredSelection selection = new StructuredSelection((Object)file);
            return new ShowInContext(null, (ISelection)selection);
        }
        return null;
    }

    static /* synthetic */ TreeViewer access$3(PlantyContentOutlinePage plantyContentOutlinePage) {
        return plantyContentOutlinePage.getTreeViewer();
    }

    static /* synthetic */ void access$4(PlantyContentOutlinePage plantyContentOutlinePage) {
        plantyContentOutlinePage.updateTreeExpansion();
    }

    private class PlantyContentProvider
    implements ITreeContentProvider {
        PlantyContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentNode) {
            XmlElement tempParentElement = (XmlElement)parentNode;
            List tempChilds = tempParentElement.getChildNodes();
            Object[] tempChildObjects = new Object[tempChilds.size()];
            int i = 0;
            while (i < tempChilds.size()) {
                tempChildObjects[i] = tempChilds.get(i);
                ++i;
            }
            return tempChildObjects;
        }

        public Object getParent(Object aNode) {
            XmlElement tempElement = (XmlElement)aNode;
            return tempElement.getParentNode();
        }

        public boolean hasChildren(Object aNode) {
            return ((XmlElement)aNode).getChildNodes().size() > 0;
        }

        public Object[] getElements(Object anInputElement) {
            return ((AntModel)anInputElement).getRootElements();
        }
    }

    private class PlantyLabelProvider
    implements ILabelProvider,
    IColorProvider {
        PlantyLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object anElement) {
            XmlElement tempElement = (XmlElement)anElement;
            if ("target".equals(tempElement.getName())) {
                ImageDescriptor base = null;
                int flags = 0;
                if (tempElement.isErrorNode()) {
                    flags |= 2;
                }
                if (PlantyContentOutlinePage.this.isDefaultTargetNode(tempElement)) {
                    flags |= 1;
                    base = ExternalToolsImages.getImageDescriptor("org.eclipse.ui.externaltools.antDefaultTarget");
                } else {
                    base = tempElement.getAttributeNamed("description") == null ? ExternalToolsImages.getImageDescriptor("org.eclipse.ui.externaltools.antPrivateTarget") : ExternalToolsImages.getImageDescriptor("org.eclipse.ui.externaltools.antTarget");
                }
                return ExternalToolsImages.getImage(new AntImageDescriptor(base, flags));
            }
            if ("project".equals(tempElement.getName())) {
                return this.getProjectImage(tempElement);
            }
            if ("property".equals(tempElement.getName())) {
                return ExternalToolsImages.getImage("org.eclipse.ui.externaltools.property");
            }
            XmlAttribute attribute = tempElement.getAttributeNamed("type");
            if (attribute != null && "external".equals(attribute.getValue())) {
                return this.getProjectImage(tempElement);
            }
            if (attribute != null && "unknown".equals(attribute.getValue())) {
                int flags = 0;
                ImageDescriptor base = ExternalToolsImages.getImageDescriptor("org.eclipse.ui.externaltools.html_tab_obj");
                if (tempElement.isErrorNode()) {
                    flags |= 2;
                }
                return ExternalToolsImages.getImage(new AntImageDescriptor(base, flags));
            }
            if (tempElement.isErrorNode()) {
                return ExternalToolsImages.getImage("org.eclipse.ui.externaltools.antTargetError");
            }
            return ExternalToolsImages.getImage("org.eclipse.ui.externaltools.html_tab_obj");
        }

        private Image getProjectImage(XmlElement tempElement) {
            int flags = 0;
            ImageDescriptor base = ExternalToolsImages.getImageDescriptor("org.eclipse.ui.externaltools.antProject");
            if (tempElement.isErrorNode()) {
                flags |= 2;
            }
            return ExternalToolsImages.getImage(new AntImageDescriptor(base, flags));
        }

        public String getText(Object aNode) {
            XmlElement element = (XmlElement)aNode;
            StringBuffer displayName = new StringBuffer(element.getDisplayName());
            if (element.isExternal() && (!element.isRootExternal() || element.getParentNode() != null && element.getParentNode().isExternal())) {
                displayName.append(AntOutlineMessages.getString("PlantyContentOutlinePage._[external]_1"));
            }
            return displayName.toString();
        }

        public Color getForeground(Object element) {
            if (PlantyContentOutlinePage.this.isDefaultTargetNode((XmlElement)element)) {
                return Display.getDefault().getSystemColor(9);
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }
}

