/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.editor.outline;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Stack;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.externaltools.internal.ant.editor.PlantyException;
import org.eclipse.ui.externaltools.internal.ant.editor.outline.AntOutlineMessages;
import org.eclipse.ui.externaltools.internal.ant.editor.outline.ILocationProvider;
import org.eclipse.ui.externaltools.internal.ant.editor.outline.IProblemRequestor;
import org.eclipse.ui.externaltools.internal.ant.editor.outline.XEErrorHandler;
import org.eclipse.ui.externaltools.internal.ant.editor.xml.XmlAttribute;
import org.eclipse.ui.externaltools.internal.ant.editor.xml.XmlElement;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class OutlinePreparingHandler
extends DefaultHandler
implements LexicalHandler {
    private Locator locator;
    private Stack stillOpenElements = new Stack();
    private XmlElement rootElement;
    private File mainFile;
    private XEErrorHandler errorHandler;
    private IDocument document;
    private boolean isTopLevelRootExternal;
    private boolean isInDTD;
    private int lastExternalEntityOffset = -1;

    public OutlinePreparingHandler(ILocationProvider locationProvider) {
        IPath location = locationProvider.getLocation();
        if (location != null) {
            this.mainFile = location.toFile();
        }
    }

    public void startElement(String aUri, String aLocalName, String aQualifiedName, Attributes anAttributes) throws SAXException {
        XmlElement tempElement = this.createXmlElement(aLocalName, aQualifiedName, anAttributes);
        if (this.rootElement == null) {
            this.rootElement = tempElement;
        } else {
            XmlElement tempLastOpenedElement = (XmlElement)this.stillOpenElements.peek();
            tempLastOpenedElement.addChildNode(tempElement);
            tempElement.setExternal(this.isExternal());
        }
        this.computeStartLocation(tempElement);
        this.stillOpenElements.push(tempElement);
        super.startElement(aUri, aLocalName, aQualifiedName, anAttributes);
    }

    private XmlElement createXmlElement(String aLocalName, String aQualifiedName, Attributes attributes) {
        String tempElementName = null;
        XmlElement tempElement = null;
        if (aLocalName.length() > 0) {
            tempElementName = aLocalName;
        } else if (aQualifiedName.length() > 0) {
            tempElementName = aQualifiedName;
        } else {
            throw new PlantyException(AntOutlineMessages.getString("OutlinePreparingHandler.Error_Name"));
        }
        String elementType = null;
        if (tempElementName.equalsIgnoreCase("target")) {
            elementType = "target";
            tempElement = new XmlElement(tempElementName){

                public String getDisplayName() {
                    XmlAttribute tempXmlAttr = this.getAttributeNamed("name");
                    if (tempXmlAttr != null) {
                        XmlAttribute defaultTarget;
                        StringBuffer name = new StringBuffer(tempXmlAttr.getValue());
                        XmlElement parent = this.getParentNode();
                        XmlAttribute type = parent != null ? parent.getAttributeNamed("type") : null;
                        while (!(parent == null || type != null && type.getValue().equals("project"))) {
                            if ((parent = parent.getParentNode()) == null) continue;
                            type = parent.getAttributeNamed("type");
                        }
                        if (parent != null && (defaultTarget = parent.getAttributeNamed("default")) != null && defaultTarget.getValue().equals(tempXmlAttr.getValue())) {
                            name.append(AntOutlineMessages.getString("OutlinePreparingHandler._[default]_2"));
                        }
                        return name.toString();
                    }
                    return super.getDisplayName();
                }
            };
        } else if (tempElementName.equalsIgnoreCase("project")) {
            elementType = "project";
            tempElement = new XmlElement(tempElementName){

                public String getDisplayName() {
                    XmlAttribute tempXmlAttr = this.getAttributeNamed("name");
                    if (tempXmlAttr != null) {
                        return tempXmlAttr.getValue();
                    }
                    return super.getDisplayName();
                }
            };
        } else if (tempElementName.equalsIgnoreCase("property")) {
            elementType = "property";
            tempElement = new XmlElement(tempElementName){

                public String getDisplayName() {
                    XmlAttribute tempXmlAttr = this.getAttributeNamed("name");
                    if (tempXmlAttr != null) {
                        return tempXmlAttr.getValue();
                    }
                    tempXmlAttr = this.getAttributeNamed("file");
                    if (tempXmlAttr != null) {
                        return "file=" + tempXmlAttr.getValue();
                    }
                    tempXmlAttr = this.getAttributeNamed("resource");
                    if (tempXmlAttr != null) {
                        return "resource=" + tempXmlAttr.getValue();
                    }
                    tempXmlAttr = this.getAttributeNamed("environment");
                    if (tempXmlAttr != null) {
                        return "environment=" + tempXmlAttr.getValue();
                    }
                    return super.getDisplayName();
                }
            };
        } else if (tempElementName.equalsIgnoreCase("antcall")) {
            elementType = "antcall";
            tempElement = new XmlElement(tempElementName){

                public String getDisplayName() {
                    String tempDisplayName = "antcall ";
                    XmlAttribute tempXmlAttr = this.getAttributeNamed("target");
                    if (tempXmlAttr != null) {
                        tempDisplayName = String.valueOf(tempDisplayName) + tempXmlAttr.getValue();
                    }
                    return tempDisplayName;
                }
            };
        } else if (tempElementName.equalsIgnoreCase("mkdir")) {
            elementType = "mkdir";
            tempElement = new XmlElement(tempElementName){

                public String getDisplayName() {
                    String tempDisplayName = "mkdir ";
                    XmlAttribute tempXmlAttr = this.getAttributeNamed("dir");
                    if (tempXmlAttr != null) {
                        tempDisplayName = String.valueOf(tempDisplayName) + tempXmlAttr.getValue();
                    }
                    return tempDisplayName;
                }
            };
        } else if (tempElementName.equalsIgnoreCase("copy")) {
            elementType = "copy";
            tempElement = new XmlElement(tempElementName){

                public String getDisplayName() {
                    String tempDisplayName = "copy ";
                    XmlAttribute tempXmlAttr = this.getAttributeNamed("file");
                    if (tempXmlAttr != null) {
                        tempDisplayName = String.valueOf(tempDisplayName) + tempXmlAttr.getValue();
                    }
                    return tempDisplayName;
                }
            };
        } else if (tempElementName.equalsIgnoreCase("tar") || tempElementName.equalsIgnoreCase("jar") || tempElementName.equalsIgnoreCase("war") || tempElementName.equalsIgnoreCase("zip")) {
            elementType = "archive";
            tempElement = new XmlElement(tempElementName){

                public String getDisplayName() {
                    String tempDisplayName = super.getDisplayName();
                    XmlAttribute tempXmlAttr = this.getAttributeNamed("destfile");
                    if (tempXmlAttr != null) {
                        tempDisplayName = String.valueOf(tempDisplayName) + " " + tempXmlAttr.getValue();
                    }
                    return tempDisplayName;
                }
            };
        } else if (tempElementName.equalsIgnoreCase("untar") || tempElementName.equalsIgnoreCase("unjar") || tempElementName.equalsIgnoreCase("unwar") || tempElementName.equalsIgnoreCase("gunzip") || tempElementName.equalsIgnoreCase("bunzip2") || tempElementName.equalsIgnoreCase("unzip")) {
            elementType = "decompress";
            tempElement = new XmlElement(tempElementName){

                public String getDisplayName() {
                    String tempDisplayName = super.getDisplayName();
                    XmlAttribute tempXmlAttr = this.getAttributeNamed("src");
                    if (tempXmlAttr != null) {
                        tempDisplayName = String.valueOf(tempDisplayName) + " " + tempXmlAttr.getValue();
                    }
                    return tempDisplayName;
                }
            };
        } else if (tempElementName.equalsIgnoreCase("gzip") || tempElementName.equalsIgnoreCase("bzip2")) {
            elementType = "compress";
            tempElement = new XmlElement(tempElementName){

                public String getDisplayName() {
                    String tempDisplayName = super.getDisplayName();
                    XmlAttribute tempXmlAttr = this.getAttributeNamed("zipfile");
                    if (tempXmlAttr != null) {
                        tempDisplayName = String.valueOf(tempDisplayName) + " " + tempXmlAttr.getValue();
                    }
                    return tempDisplayName;
                }
            };
        } else if (tempElementName.equalsIgnoreCase("exec")) {
            elementType = "exec";
            tempElement = new XmlElement(tempElementName){

                public String getDisplayName() {
                    String tempDisplayName = "exec ";
                    XmlAttribute tempXmlAttr = this.getAttributeNamed("command");
                    if (tempXmlAttr != null) {
                        tempDisplayName = String.valueOf(tempDisplayName) + tempXmlAttr.getValue();
                    }
                    if ((tempXmlAttr = this.getAttributeNamed("executable")) != null) {
                        tempDisplayName = String.valueOf(tempDisplayName) + tempXmlAttr.getValue();
                    }
                    return tempDisplayName;
                }
            };
        } else if (tempElementName.equalsIgnoreCase("delete")) {
            elementType = "delete";
            tempElement = new XmlElement(tempElementName){

                public String getDisplayName() {
                    String tempDisplayName = "delete ";
                    XmlAttribute tempXmlAttr = this.getAttributeNamed("file");
                    if (tempXmlAttr != null) {
                        return String.valueOf(tempDisplayName) + tempXmlAttr.getValue();
                    }
                    tempXmlAttr = this.getAttributeNamed("dir");
                    if (tempXmlAttr != null) {
                        return String.valueOf(tempDisplayName) + tempXmlAttr.getValue();
                    }
                    return tempDisplayName;
                }
            };
        } else {
            elementType = "unknown";
            tempElement = new XmlElement(tempElementName);
        }
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                String tempAttrName = attributes.getLocalName(i);
                if (tempAttrName == null || tempAttrName.length() == 0) {
                    tempAttrName = attributes.getQName(i);
                }
                String tempAttrValue = attributes.getValue(i);
                tempElement.addAttribute(new XmlAttribute(tempAttrName, tempAttrValue));
                ++i;
            }
        }
        tempElement.addAttribute(new XmlAttribute("type", elementType));
        tempElement.setFilePath(this.locator.getSystemId());
        return tempElement;
    }

    public void endElement(String aUri, String aLocalName, String aQualifiedName) throws SAXException {
        String tempTagName = aLocalName.length() > 0 ? aLocalName : aQualifiedName;
        XmlElement tempLastStillOpenElement = (XmlElement)this.stillOpenElements.peek();
        if (tempLastStillOpenElement != null && tempLastStillOpenElement.getName().equalsIgnoreCase(tempTagName)) {
            this.computeEndLocation(tempLastStillOpenElement);
            this.stillOpenElements.pop();
        }
    }

    public void setDocumentLocator(Locator aLocator) {
        this.locator = aLocator;
        super.setDocumentLocator(aLocator);
        if (this.errorHandler != null) {
            this.errorHandler.setDocumentLocator(aLocator);
        }
    }

    public XmlElement getRootElement() {
        return this.rootElement;
    }

    public void warning(SAXParseException anException) throws SAXException {
        if (this.errorHandler != null) {
            XmlElement element = this.createProblemElement(anException);
            this.errorHandler.warning(anException, element);
        }
    }

    public void error(SAXParseException anException) throws SAXException {
        this.generateErrorElementHierarchy();
        if (this.errorHandler != null) {
            XmlElement errorElement = this.createProblemElement(anException);
            this.errorHandler.error(anException, errorElement);
        }
    }

    public void fatalError(SAXParseException anException) throws SAXException {
        this.generateErrorElementHierarchy();
        if (this.errorHandler != null) {
            XmlElement errorElement = this.createProblemElement(anException);
            this.errorHandler.fatalError(anException, errorElement);
        }
    }

    private XmlElement createProblemElement(SAXParseException exception) {
        int lineNumber = exception.getLineNumber();
        StringBuffer message = new StringBuffer(exception.getMessage());
        if (lineNumber != -1) {
            message.append(String.valueOf(AntOutlineMessages.getString("OutlinePreparingHandler._line___2")) + lineNumber);
        }
        XmlElement errorNode = new XmlElement(message.toString());
        errorNode.setFilePath(exception.getSystemId());
        errorNode.setExternal(this.isExternal());
        errorNode.setIsErrorNode(true);
        this.computeErrorLocation(errorNode, exception);
        return errorNode;
    }

    private void generateErrorElementHierarchy() {
        XmlElement openElement = this.getLastOpenElement();
        while (openElement != null) {
            openElement.setIsErrorNode(true);
            openElement = openElement.getParentNode();
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        int index = systemId.indexOf(58);
        if (index > 0) {
            systemId = systemId.substring(index + 1, systemId.length());
        }
        File resolvedFile = null;
        Path filePath = new Path(systemId);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)filePath);
        if (file == null || !file.exists()) {
            try {
                resolvedFile = FileUtils.newFileUtils().resolveFile(this.mainFile.getParentFile(), systemId);
            }
            catch (BuildException buildException) {
                return null;
            }
        } else {
            resolvedFile = file.getLocation().toFile();
        }
        if (resolvedFile != null && resolvedFile.exists()) {
            try {
                InputSource inputSource = new InputSource(new FileReader(resolvedFile));
                inputSource.setSystemId(resolvedFile.getAbsolutePath());
                return inputSource;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        return super.resolveEntity(publicId, systemId);
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.isInDTD || this.isExternal()) {
            return;
        }
        try {
            this.lastExternalEntityOffset = this.getOffset(this.locator.getLineNumber(), this.locator.getColumnNumber()) - 1;
        }
        catch (BadLocationException e) {
            ExternalToolsPlugin.getDefault().log(e);
        }
    }

    public void endCDATA() throws SAXException {
    }

    public void endDTD() throws SAXException {
        this.isInDTD = false;
    }

    public void endEntity(String name) throws SAXException {
        boolean isNestedRootExternal;
        if (this.isInDTD) {
            return;
        }
        XmlElement element = this.getLastOpenElement();
        boolean bl = isNestedRootExternal = element == null || element.getParentNode() == null || element.getParentNode().isExternal();
        if (!isNestedRootExternal) {
            this.isTopLevelRootExternal = true;
        }
        this.endElement(null, name, "");
        if (!isNestedRootExternal) {
            this.isTopLevelRootExternal = false;
        }
    }

    public void startCDATA() throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.isInDTD = true;
    }

    public void startEntity(String name) throws SAXException {
        if (this.isInDTD) {
            return;
        }
        boolean isNestedRootExternal = this.isExternal();
        if (!isNestedRootExternal) {
            this.isTopLevelRootExternal = true;
        }
        this.startElement(null, name, "", null);
        XmlElement external = (XmlElement)this.stillOpenElements.peek();
        external.setExternal(true);
        external.setRootExternal(true);
        external.getAttributes().removeAll(external.getAttributes());
        external.addAttribute(new XmlAttribute("type", "external"));
        if (!isNestedRootExternal) {
            this.isTopLevelRootExternal = false;
        }
    }

    private void computeStartLocation(XmlElement element) {
        if (element.isExternal()) {
            return;
        }
        try {
            int offset;
            if (this.isTopLevelRootExternal) {
                String source = "&" + element.getName() + ";";
                this.lastExternalEntityOffset = offset = this.document.search(this.lastExternalEntityOffset + 1, source, true, true, false);
            } else {
                int locatorLine = this.locator.getLineNumber();
                int locatorColumn = this.locator.getColumnNumber();
                String prefix = "<";
                if (locatorColumn <= 0) {
                    offset = this.getOffset(locatorLine, this.getLastCharColumn(locatorLine));
                    this.lastExternalEntityOffset = offset = this.document.search(offset, String.valueOf(prefix) + element.getName(), false, false, false);
                } else {
                    offset = this.getOffset(locatorLine, locatorColumn);
                    this.lastExternalEntityOffset = offset - 1;
                    offset = this.document.search(offset - 1, prefix, false, true, false);
                }
            }
            int line = this.getLine(offset);
            int column = this.getColumn(offset, line);
            element.setOffset(offset);
            element.setStartingRow(line);
            element.setStartingColumn(column);
        }
        catch (BadLocationException badLocationException) {}
    }

    private void computeEndLocation(XmlElement element) {
        if (element.isExternal() && !this.isTopLevelRootExternal) {
            return;
        }
        try {
            int column;
            int line;
            int length;
            if (this.isTopLevelRootExternal) {
                length = element.getName().length() + 2;
                line = element.getStartingRow();
                column = element.getStartingColumn() + length;
            } else {
                int offset;
                line = this.locator.getLineNumber();
                column = this.locator.getColumnNumber();
                if (column <= 0) {
                    String endDelimiter;
                    int lineOffset = this.getOffset(line, 1);
                    offset = this.document.search(lineOffset, element.getName(), true, false, false);
                    if (offset < 0 || this.getLine(offset) != line) {
                        offset = lineOffset;
                    }
                    if ((offset = this.document.search(lineOffset, endDelimiter = ">", true, true, false)) < 0 || this.getLine(offset) != line) {
                        offset = lineOffset;
                        column = 1;
                    } else {
                        column = this.getColumn(++offset, line);
                    }
                } else {
                    offset = this.getOffset(line, column);
                }
                length = offset - element.getOffset();
                this.lastExternalEntityOffset = offset - 1;
            }
            element.setLength(length);
            element.setEndingRow(line);
            element.setEndingColumn(column);
        }
        catch (BadLocationException badLocationException) {}
    }

    private void computeErrorLocation(XmlElement element, SAXParseException exception) {
        if (element.isExternal()) {
            return;
        }
        try {
            int endColumn;
            int line = exception.getLineNumber();
            int startColumn = exception.getColumnNumber();
            if (line <= 0) {
                line = this.locator.getLineNumber();
                startColumn = this.locator.getColumnNumber();
                if (line <= 0) {
                    line = 1;
                    startColumn = 1;
                }
            }
            if (startColumn <= 0) {
                startColumn = 1;
                endColumn = this.getLastCharColumn(line) + 1;
            } else {
                if (startColumn > 1) {
                    --startColumn;
                }
                endColumn = startColumn;
                if (startColumn <= this.getLastCharColumn(line)) {
                    ++endColumn;
                }
            }
            int offset = this.getOffset(line, startColumn);
            element.setStartingRow(line);
            element.setStartingColumn(startColumn);
            element.setOffset(offset);
            element.setEndingRow(line);
            element.setEndingColumn(endColumn);
            element.setLength(endColumn - startColumn);
        }
        catch (BadLocationException badLocationException) {}
    }

    public void fixEndLocations() {
        this.fixEndLocations(null);
    }

    public void fixEndLocations(SAXParseException e) {
        XmlElement lastOpenElement = this.getLastOpenElement();
        if (lastOpenElement == null) {
            return;
        }
        boolean recoverFromExternal = lastOpenElement.isExternal();
        while (lastOpenElement.isExternal() && (!lastOpenElement.isRootExternal() || lastOpenElement.getParentNode() != null && lastOpenElement.getParentNode().isExternal())) {
            this.stillOpenElements.pop();
            lastOpenElement = this.getLastOpenElement();
        }
        try {
            int column;
            int line;
            int offset;
            XmlElement element;
            if (recoverFromExternal) {
                element = (XmlElement)this.stillOpenElements.peek();
                int length = element.getName().length() + 2;
                offset = element.getOffset() + length;
                line = element.getStartingRow();
                column = element.getStartingColumn() + length;
            } else if (e == null) {
                element = (XmlElement)this.stillOpenElements.peek();
                offset = element.getOffset();
                line = element.getStartingRow();
                column = element.getStartingColumn();
            } else {
                line = e.getLineNumber();
                column = e.getColumnNumber();
                if (line <= 0) {
                    line = 1;
                }
                if (column <= 0) {
                    column = 1;
                }
                offset = this.getOffset(line, column);
            }
            while (!this.stillOpenElements.empty()) {
                element = (XmlElement)this.stillOpenElements.pop();
                element.setLength(offset - element.getOffset());
                element.setEndingRow(line);
                element.setEndingColumn(column);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    public XmlElement getLastOpenElement() {
        if (!this.stillOpenElements.empty()) {
            return (XmlElement)this.stillOpenElements.peek();
        }
        return null;
    }

    private boolean isExternal() {
        if (!this.stillOpenElements.empty()) {
            return ((XmlElement)this.stillOpenElements.peek()).isExternal();
        }
        return false;
    }

    private int getLastCharColumn(int line) throws BadLocationException {
        String lineDelimiter = this.document.getLineDelimiter(line - 1);
        int lineDelimiterLength = lineDelimiter != null ? lineDelimiter.length() : 0;
        return this.document.getLineLength(line - 1) - lineDelimiterLength;
    }

    private int getOffset(int line, int column) throws BadLocationException {
        return this.document.getLineOffset(line - 1) + column - 1;
    }

    private int getLine(int offset) throws BadLocationException {
        return this.document.getLineOfOffset(offset) + 1;
    }

    private int getColumn(int offset, int line) throws BadLocationException {
        return offset - this.document.getLineOffset(line - 1) + 1;
    }

    public void begin() {
        if (this.errorHandler != null) {
            this.errorHandler.beginReporting();
        }
    }

    public void end() {
        if (this.errorHandler != null) {
            this.errorHandler.endReporting();
        }
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public void setProblemRequestor(IProblemRequestor requestor) {
        this.errorHandler = requestor != null ? new XEErrorHandler(requestor) : null;
    }
}

