/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.editor.outline;

import java.io.IOException;
import java.io.StringReader;
import org.apache.xerces.parsers.SAXParser;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.ui.externaltools.internal.ant.editor.outline.DocumentModelChangeEvent;
import org.eclipse.ui.externaltools.internal.ant.editor.outline.ILocationProvider;
import org.eclipse.ui.externaltools.internal.ant.editor.outline.IProblemRequestor;
import org.eclipse.ui.externaltools.internal.ant.editor.outline.OutlinePreparingHandler;
import org.eclipse.ui.externaltools.internal.ant.editor.outline.XMLCore;
import org.eclipse.ui.externaltools.internal.ant.editor.xml.XmlElement;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AntModel {
    private XMLCore fCore;
    private IDocument fDocument;
    private IProblemRequestor fProblemRequestor;
    private ILocationProvider fLocationProvider;
    private XmlElement[] fRootElements = new XmlElement[0];
    private Object fRootElementLock = new Object();
    private final Object fDirtyLock = new Object();
    private boolean fIsDirty = true;
    private IDocumentListener fListener;

    public AntModel(XMLCore core, IDocument document, IProblemRequestor problemRequestor, ILocationProvider locationProvider) {
        this.fCore = core;
        this.fDocument = document;
        this.fProblemRequestor = problemRequestor;
        this.fLocationProvider = locationProvider;
    }

    public void install() {
        this.fListener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
                Object object = AntModel.this.fDirtyLock;
                synchronized (object) {
                    AntModel.this.fIsDirty = true;
                }
            }

            public void documentChanged(DocumentEvent event) {
            }
        };
        this.fDocument.addDocumentListener(this.fListener);
        this.reconcile();
    }

    public void dispose() {
        if (this.fDocument != null) {
            this.fDocument.removeDocumentListener(this.fListener);
        }
        AntModel antModel = this;
        synchronized (antModel) {
            this.fDocument = null;
            this.fCore = null;
        }
    }

    public void reconcile() {
        Object object = this.fDirtyLock;
        synchronized (object) {
            if (!this.fIsDirty) {
                return;
            }
            this.fIsDirty = false;
        }
        object = this;
        synchronized (object) {
            XmlElement rootElement;
            if (this.fCore == null) {
                return;
            }
            XmlElement[] rootElements = this.fDocument == null ? new XmlElement[]{} : ((rootElement = this.parseDocument(this.fDocument)) == null ? new XmlElement[]{} : new XmlElement[]{rootElement});
            this.setRootElements(rootElements);
            this.fCore.notifyDocumentModelListeners(new DocumentModelChangeEvent(this));
        }
    }

    private void setRootElements(XmlElement[] rootElements) {
        Object object = this.fRootElementLock;
        synchronized (object) {
            this.fRootElements = rootElements;
        }
    }

    public XmlElement[] getRootElements() {
        Object object = this.fRootElementLock;
        synchronized (object) {
            return this.fRootElements;
        }
    }

    private XmlElement parseDocument(IDocument input) {
        SAXParser tempParser;
        String tempWholeDocumentString = input.get();
        try {
            tempParser = new SAXParser();
            tempParser.setFeature("http://xml.org/sax/features/namespaces", false);
        }
        catch (SAXException e) {
            ExternalToolsPlugin.getDefault().log(e);
            return null;
        }
        OutlinePreparingHandler tempHandler = null;
        tempHandler = new OutlinePreparingHandler(this.fLocationProvider);
        tempHandler.setProblemRequestor(this.fProblemRequestor);
        tempHandler.setDocument(input);
        tempParser.setContentHandler((ContentHandler)tempHandler);
        tempParser.setDTDHandler((DTDHandler)tempHandler);
        tempParser.setEntityResolver((EntityResolver)tempHandler);
        tempParser.setErrorHandler((ErrorHandler)tempHandler);
        try {
            try {
                tempHandler.begin();
                InputSource tempInputSource = new InputSource(new StringReader(tempWholeDocumentString));
                IPath location = this.fLocationProvider.getLocation();
                if (location != null) {
                    tempInputSource.setSystemId(location.toOSString());
                }
                tempParser.setProperty("http://xml.org/sax/properties/lexical-handler", (Object)tempHandler);
                tempParser.parse(tempInputSource);
            }
            catch (SAXParseException e) {
                tempHandler.fixEndLocations(e);
            }
            catch (SAXException e) {
                ExternalToolsPlugin.getDefault().log(e);
                Object var7_10 = null;
                tempHandler.end();
                return null;
            }
            catch (IOException iOException) {
                XmlElement tempElement = tempHandler.getLastOpenElement();
                tempHandler.fixEndLocations();
                this.generateExceptionOutline(tempElement);
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            tempHandler.end();
            throw throwable;
        }
        Object var7_12 = null;
        tempHandler.end();
        XmlElement tempRootElement = tempHandler.getRootElement();
        return tempRootElement;
    }

    private void generateExceptionOutline(XmlElement openElement) {
        while (openElement != null) {
            openElement.setIsErrorNode(true);
            openElement = openElement.getParentNode();
        }
    }

    public ILocationProvider getLocationProvider() {
        return this.fLocationProvider;
    }
}

