/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.editor;

import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.externaltools.internal.ant.editor.PlantyCompletionProcessor;
import org.eclipse.ui.externaltools.internal.ant.editor.PlantyEditor;
import org.eclipse.ui.externaltools.internal.ant.editor.derived.HTMLTextPresenter;
import org.eclipse.ui.externaltools.internal.ant.editor.text.NonRuleBasedDamagerRepairer;
import org.eclipse.ui.externaltools.internal.ant.editor.text.NotifyingReconciler;
import org.eclipse.ui.externaltools.internal.ant.editor.text.PlantyProcInstrScanner;
import org.eclipse.ui.externaltools.internal.ant.editor.text.PlantyTagScanner;
import org.eclipse.ui.externaltools.internal.ant.editor.text.XMLAnnotationHover;
import org.eclipse.ui.externaltools.internal.ant.editor.text.XMLReconcilingStrategy;
import org.eclipse.ui.externaltools.internal.ant.editor.text.XMLTextHover;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;
import org.eclipse.ui.texteditor.ITextEditor;

public class PlantySourceViewerConfiguration
extends SourceViewerConfiguration {
    private PlantyTagScanner tagScanner;
    private PlantyProcInstrScanner instructionScanner;
    private NonRuleBasedDamagerRepairer damageRepairer;
    private PlantyEditor fEditor;
    private XMLTextHover fTextHover;

    public PlantySourceViewerConfiguration(PlantyEditor editor) {
        this.fEditor = editor;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        PlantyCompletionProcessor tempProcessor = new PlantyCompletionProcessor();
        assistant.setContentAssistProcessor((IContentAssistProcessor)tempProcessor, "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)tempProcessor, "__xml_tag");
        assistant.enableAutoActivation(true);
        IInformationControlCreator creator = this.getInformationControlCreator(true);
        assistant.setInformationControlCreator(creator);
        return assistant;
    }

    protected IInformationControlCreator getInformationControlCreator(final boolean cutDown) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int style = cutDown ? 0 : 768;
                return new DefaultInformationControl(parent, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(cutDown));
            }
        };
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__xml_comment", "__xml_tag"};
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        return 4;
    }

    private PlantyProcInstrScanner getDefaultScanner() {
        if (this.instructionScanner == null) {
            this.instructionScanner = new PlantyProcInstrScanner();
            this.instructionScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(ExternalToolsPlugin.getPreferenceColor("planty.color.default"))));
        }
        return this.instructionScanner;
    }

    private PlantyTagScanner getTagScanner() {
        if (this.tagScanner == null) {
            this.tagScanner = new PlantyTagScanner();
            this.tagScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(ExternalToolsPlugin.getPreferenceColor("planty.color.tag"))));
        }
        return this.tagScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getDefaultScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_tag");
        this.damageRepairer = new NonRuleBasedDamagerRepairer(new TextAttribute(ExternalToolsPlugin.getPreferenceColor("planty.color.xml_comment")));
        reconciler.setDamager((IPresentationDamager)this.damageRepairer, "__xml_comment");
        reconciler.setRepairer((IPresentationRepairer)this.damageRepairer, "__xml_comment");
        return reconciler;
    }

    public void updateScanners() {
        this.tagScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(ExternalToolsPlugin.getPreferenceColor("planty.color.tag"))));
        this.instructionScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(ExternalToolsPlugin.getPreferenceColor("planty.color.default"))));
        this.damageRepairer.setDefaultTextAttribute(new TextAttribute(ExternalToolsPlugin.getPreferenceColor("planty.color.xml_comment")));
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        NotifyingReconciler reconciler = new NotifyingReconciler(new XMLReconcilingStrategy((ITextEditor)this.fEditor), false);
        reconciler.setDelay(500);
        return reconciler;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new XMLAnnotationHover();
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return this.getInformationControlCreator(true);
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        if (this.fTextHover == null) {
            this.fTextHover = new XMLTextHover();
        }
        return this.fTextHover;
    }
}

