/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.editor;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.text.MessageFormat;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.externaltools.internal.ant.editor.AntEditorMessages;
import org.eclipse.ui.externaltools.internal.ant.editor.PlantyException;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class PlantySaxDefaultHandler
extends DefaultHandler {
    protected Locator locator;
    protected Stack stillOpenElements = new Stack();
    protected Element parentElement;
    protected boolean parsingFinished;
    protected Document document;
    protected int rowOfCursorPosition = -1;
    protected int columnOfCursorPosition = -1;
    public String rootElementName;
    private File mainFileContainer;

    public PlantySaxDefaultHandler(File mainFileContainer, int aRowOfCursorPosition, int aColumnOfCursorPosition) throws ParserConfigurationException {
        if (ExternalToolsPlugin.getDefault() != null && ExternalToolsPlugin.getDefault().isDebugging()) {
            ExternalToolsPlugin.getDefault().log("PlantySaxDefaultHandler(" + aRowOfCursorPosition + ", " + aColumnOfCursorPosition + ")", null);
        }
        if (aRowOfCursorPosition < 0 || aColumnOfCursorPosition < 0) {
            throw new IllegalArgumentException(MessageFormat.format(AntEditorMessages.getString("PlantySaxDefaultHandler.Invalid_cursor_position"), Integer.toString(aRowOfCursorPosition), Integer.toString(aColumnOfCursorPosition)));
        }
        this.rowOfCursorPosition = aRowOfCursorPosition;
        this.columnOfCursorPosition = aColumnOfCursorPosition;
        this.mainFileContainer = mainFileContainer;
        this.initialize();
    }

    protected void initialize() throws ParserConfigurationException {
        DocumentBuilder tempDocumentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.document = tempDocumentBuilder.newDocument();
    }

    protected boolean checkForParentElement() {
        if (this.parentElement == null) {
            if (this.locator != null) {
                int tempLineNr = this.locator.getLineNumber() - 1;
                int tempColumnNr = this.locator.getColumnNumber() - 1;
                if (tempLineNr > this.rowOfCursorPosition || tempLineNr == this.rowOfCursorPosition && tempColumnNr > this.columnOfCursorPosition && !this.stillOpenElements.isEmpty()) {
                    this.parentElement = (Element)this.stillOpenElements.peek();
                    if (ExternalToolsPlugin.getDefault() != null && ExternalToolsPlugin.getDefault().isDebugging()) {
                        ExternalToolsPlugin.getDefault().log("PlantySaxDefaultHandler.checkForParentElement(): Parent element found: " + this.parentElement, null);
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public void startElement(String aUri, String aLocalName, String aQualifiedName, Attributes anAttributes) throws SAXException {
        String tempTagName;
        if (ExternalToolsPlugin.getDefault() != null && ExternalToolsPlugin.getDefault().isDebugging()) {
            ExternalToolsPlugin.getDefault().log("PlantySaxDefaultHandler.startElement(" + aUri + ", " + aLocalName + ", " + aQualifiedName + ", " + anAttributes + ")", null);
        }
        if (this.parsingFinished) {
            return;
        }
        this.checkForParentElement();
        String string = tempTagName = aLocalName.length() > 0 ? aLocalName : aQualifiedName;
        if (tempTagName == null || tempTagName.length() == 0) {
            throw new PlantyException(AntEditorMessages.getString("PlantySaxDefaultHandler.Error_parsing"));
        }
        if (this.rootElementName == null) {
            this.rootElementName = tempTagName;
        }
        Element tempElement = this.document.createElement(tempTagName);
        this.stillOpenElements.push(tempElement);
        super.startElement(aUri, aLocalName, aQualifiedName, anAttributes);
    }

    public void endElement(String aUri, String aLocalName, String aQualifiedName) throws SAXException {
        Element tempLastStillOpenElement;
        String tempTagName;
        if (ExternalToolsPlugin.getDefault() != null && ExternalToolsPlugin.getDefault().isDebugging()) {
            ExternalToolsPlugin.getDefault().log("PlantySaxDefaultHandler.endElement(" + aUri + ", " + aLocalName + ", " + aQualifiedName + ")", null);
        }
        if (this.parsingFinished) {
            return;
        }
        boolean tempParentKnown = this.checkForParentElement();
        String string = tempTagName = aLocalName.length() > 0 ? aLocalName : aQualifiedName;
        if (!this.stillOpenElements.isEmpty() && (tempLastStillOpenElement = (Element)this.stillOpenElements.peek()) != null && tempLastStillOpenElement.getTagName().equals(tempTagName)) {
            this.stillOpenElements.pop();
            if (!this.stillOpenElements.empty()) {
                Element tempSecondLastStillOpenElement = (Element)this.stillOpenElements.peek();
                tempSecondLastStillOpenElement.appendChild(tempLastStillOpenElement);
            }
            if (tempParentKnown && this.parentElement != null && this.parentElement.getTagName().equals(tempTagName)) {
                this.parsingFinished = true;
            }
        }
    }

    public void setDocumentLocator(Locator aLocator) {
        this.locator = aLocator;
        super.setDocumentLocator(aLocator);
    }

    public Element getParentElement(boolean aGuessParentFlag) {
        if (this.parentElement != null) {
            return this.parentElement;
        }
        if (aGuessParentFlag && !this.stillOpenElements.empty()) {
            return (Element)this.stillOpenElements.peek();
        }
        return null;
    }

    public void error(SAXParseException anException) throws SAXException {
        super.error(anException);
    }

    public void fatalError(SAXParseException anException) throws SAXException {
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        int index = systemId.indexOf(58);
        if (index > 0) {
            systemId = systemId.substring(index + 1, systemId.length());
        }
        File resolvedFile = null;
        Path filePath = new Path(systemId);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)filePath);
        if (file == null || !file.exists()) {
            try {
                resolvedFile = FileUtils.newFileUtils().resolveFile(this.mainFileContainer, systemId);
            }
            catch (BuildException buildException) {
                return null;
            }
        } else {
            resolvedFile = file.getLocation().toFile();
        }
        if (resolvedFile != null && resolvedFile.exists()) {
            try {
                return new InputSource(new FileReader(resolvedFile));
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        return super.resolveEntity(publicId, systemId);
    }
}

