/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.editor;

import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.externaltools.internal.ant.editor.PlantySourceViewerConfiguration;
import org.eclipse.ui.externaltools.internal.ant.editor.outline.AntModel;
import org.eclipse.ui.externaltools.internal.ant.editor.outline.PlantyContentOutlinePage;
import org.eclipse.ui.externaltools.internal.ant.editor.outline.XMLCore;
import org.eclipse.ui.externaltools.internal.ant.editor.text.AnnotationAccess;
import org.eclipse.ui.externaltools.internal.ant.editor.text.AnnotationType;
import org.eclipse.ui.externaltools.internal.ant.editor.text.PlantyDocumentProvider;
import org.eclipse.ui.externaltools.internal.ant.editor.xml.XmlAttribute;
import org.eclipse.ui.externaltools.internal.ant.editor.xml.XmlElement;
import org.eclipse.ui.externaltools.internal.model.ColorManager;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public class PlantyEditor
extends TextEditor {
    public static final int TAB_WIDTH = 4;
    protected SelectionChangedListener selectionChangedListener = new SelectionChangedListener();
    protected PlantyContentOutlinePage page;
    private static final String ERROR_INDICATION_IN_OVERVIEW_RULER = "errorIndicationInOverviewRuler";
    private static final String WARNING_INDICATION_IN_OVERVIEW_RULER = "warningIndicationInOverviewRuler";
    private static final String INFO_INDICATION_IN_OVERVIEW_RULER = "infoIndicationInOverviewRuler";
    private static final String TASK_INDICATION_IN_OVERVIEW_RULER = "taskIndicationInOverviewRuler";
    private static final String BOOKMARK_INDICATION_IN_OVERVIEW_RULER = "bookmarkIndicationInOverviewRuler";
    private static final String SEARCH_RESULT_INDICATION_IN_OVERVIEW_RULER = "searchResultIndicationInOverviewRuler";
    private static final String UNKNOWN_INDICATION_IN_OVERVIEW_RULER = "othersIndicationInOverviewRuler";
    private static final String ERROR_INDICATION = "problemIndication";
    private static final String ERROR_INDICATION_COLOR = "problemIndicationColor";
    private static final String WARNING_INDICATION = "warningIndication";
    private static final String WARNING_INDICATION_COLOR = "warningIndicationColor";
    private static final String INFO_INDICATION = "infoIndication";
    private static final String INFO_INDICATION_COLOR = "infoIndicationColor";
    private static final String TASK_INDICATION = "taskIndication";
    private static final String TASK_INDICATION_COLOR = "taskIndicationColor";
    private static final String BOOKMARK_INDICATION = "bookmarkIndication";
    private static final String BOOKMARK_INDICATION_COLOR = "bookmarkIndicationColor";
    private static final String SEARCH_RESULT_INDICATION = "searchResultIndication";
    private static final String SEARCH_RESULT_INDICATION_COLOR = "searchResultIndicationColor";
    private static final String UNKNOWN_INDICATION = "othersIndication";
    private static final String UNKNOWN_INDICATION_COLOR = "othersIndicationColor";
    private static final String CURRENT_LINE = "currentLine";
    private static final String CURRENT_LINE_COLOR = "currentLineColor";
    private static final String PRINT_MARGIN = "printMargin";
    private static final String PRINT_MARGIN_COLOR = "printMarginColor";
    private static final String PRINT_MARGIN_COLUMN = "printMarginColumn";
    static /* synthetic */ Class class$0;

    public PlantyEditor() {
        this.setDocumentProvider((IDocumentProvider)new PlantyDocumentProvider(XMLCore.getDefault()));
        this.setPreferenceStore(ExternalToolsPlugin.getDefault().getPreferenceStore());
    }

    protected void createActions() {
        super.createActions();
        ContentAssistAction action = new ContentAssistAction(ResourceBundle.getBundle("org.eclipse.ui.externaltools.internal.ant.editor.AntEditorMessages"), "ContentAssistProposal.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
    }

    public void initializeEditor() {
        this.setSourceViewerConfiguration(new PlantySourceViewerConfiguration(this));
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.setCompatibilityMode(false);
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz)) {
            return this.getOutlinePage();
        }
        return super.getAdapter(key);
    }

    private PlantyContentOutlinePage getOutlinePage() {
        if (this.page == null) {
            this.page = new PlantyContentOutlinePage(XMLCore.getDefault(), (ITextEditor)this);
            this.page.addPostSelectionChangedListener(this.selectionChangedListener);
            this.setOutlinePageInput(this.page, this.getEditorInput());
        }
        return this.page;
    }

    private void doSelectionChanged(SelectionChangedEvent aSelectionChangedEvent) {
        XmlElement tempSelectedXmlElement;
        IStructuredSelection selection = (IStructuredSelection)aSelectionChangedEvent.getSelection();
        if (!this.isActivePart() && ExternalToolsPlugin.getActivePage() != null) {
            ExternalToolsPlugin.getActivePage().bringToTop((IWorkbenchPart)this);
        }
        if ((tempSelectedXmlElement = (XmlElement)selection.getFirstElement()) != null) {
            this.setSelection(tempSelectedXmlElement, !this.isActivePart());
        }
    }

    private boolean isActivePart() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IPartService service = window.getPartService();
        IWorkbenchPart part = service.getActivePart();
        return part != null && part.equals((Object)this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setSelection(XmlElement reference, boolean moveCursor) {
        StyledText textWidget;
        block16: {
            block15: {
                block14: {
                    if (reference == null) {
                        if (!moveCursor) return;
                        this.resetHighlightRange();
                        return;
                    }
                    if (reference.isExternal()) {
                        while (!reference.isRootExternal() || reference.getParentNode() != null && reference.getParentNode().isExternal()) {
                            reference = reference.getParentNode();
                        }
                    }
                    textWidget = null;
                    ISourceViewer sourceViewer = this.getSourceViewer();
                    if (sourceViewer != null) {
                        textWidget = sourceViewer.getTextWidget();
                    }
                    if (textWidget == null) {
                        return;
                    }
                    try {
                        try {
                            int offset = reference.getOffset();
                            int length = reference.getLength();
                            if (offset < 0) {
                                Object var8_8 = null;
                                if (textWidget == null) return;
                                break block14;
                            }
                            textWidget.setRedraw(false);
                            if (length > 0) {
                                this.setHighlightRange(offset, length, moveCursor);
                            }
                            if (!moveCursor) {
                                break block15;
                            }
                            XmlAttribute attrType = reference.getAttributeNamed("type");
                            if (!reference.isErrorNode() || attrType != null && "project".equalsIgnoreCase(attrType.getValue())) {
                                offset = reference.getOffset() + 1;
                                length = reference.getName().length();
                            }
                            if (offset > -1 && length > 0) {
                                sourceViewer.revealRange(offset, length);
                                sourceViewer.setSelectedRange(offset, length);
                            }
                            break block16;
                        }
                        catch (IllegalArgumentException x) {
                            ExternalToolsPlugin.getDefault().log(x);
                        }
                        break block16;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        if (textWidget == null) throw throwable;
                        textWidget.setRedraw(true);
                        throw throwable;
                    }
                }
                textWidget.setRedraw(true);
                return;
            }
            Object var8_9 = null;
            if (textWidget == null) return;
            textWidget.setRedraw(true);
            return;
        }
        Object var8_11 = null;
        if (textWidget == null) return;
        textWidget.setRedraw(true);
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        String property = event.getProperty();
        return property.equals("planty.color.default") || property.equals("planty.color.instr") || property.equals("planty.color.string") || property.equals("planty.color.tag") || property.equals("planty.color.xml_comment");
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        if (this.affectsTextPresentation(event)) {
            ((PlantySourceViewerConfiguration)this.getSourceViewerConfiguration()).updateScanners();
        }
        super.handlePreferenceStoreChanged(event);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        this.setOutlinePageInput(this.page, input);
    }

    protected void setOutlinePageInput(PlantyContentOutlinePage page, IEditorInput input) {
        IDocumentProvider provider;
        if (page != null && (provider = this.getDocumentProvider()) instanceof PlantyDocumentProvider) {
            PlantyDocumentProvider documentProvider = (PlantyDocumentProvider)provider;
            AntModel model = documentProvider.getAntModel(input);
            page.setPageInput(model);
        }
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.createAnnotationAccess();
        ColorManager sharedColors = ColorManager.getDefault();
        this.fOverviewRuler = new OverviewRuler(this.fAnnotationAccess, 12, (ISharedTextColors)sharedColors);
        this.fOverviewRuler.addHeaderAnnotationType((Object)AnnotationType.WARNING);
        this.fOverviewRuler.addHeaderAnnotationType((Object)AnnotationType.ERROR);
        SourceViewer sourceViewer = new SourceViewer(parent, ruler, this.fOverviewRuler, this.isOverviewRulerVisible(), styles);
        this.fSourceViewerDecorationSupport = new SourceViewerDecorationSupport((ISourceViewer)sourceViewer, this.fOverviewRuler, this.fAnnotationAccess, (ISharedTextColors)sharedColors);
        this.configureSourceViewerDecorationSupport();
        return sourceViewer;
    }

    protected IAnnotationAccess createAnnotationAccess() {
        return new AnnotationAccess();
    }

    protected void configureSourceViewerDecorationSupport() {
        this.fSourceViewerDecorationSupport.setAnnotationPainterPreferenceKeys((Object)AnnotationType.UNKNOWN, UNKNOWN_INDICATION_COLOR, UNKNOWN_INDICATION, UNKNOWN_INDICATION_IN_OVERVIEW_RULER, 0);
        this.fSourceViewerDecorationSupport.setAnnotationPainterPreferenceKeys((Object)AnnotationType.BOOKMARK, BOOKMARK_INDICATION_COLOR, BOOKMARK_INDICATION, BOOKMARK_INDICATION_IN_OVERVIEW_RULER, 1);
        this.fSourceViewerDecorationSupport.setAnnotationPainterPreferenceKeys((Object)AnnotationType.TASK, TASK_INDICATION_COLOR, TASK_INDICATION, TASK_INDICATION_IN_OVERVIEW_RULER, 2);
        this.fSourceViewerDecorationSupport.setAnnotationPainterPreferenceKeys((Object)AnnotationType.SEARCH, SEARCH_RESULT_INDICATION_COLOR, SEARCH_RESULT_INDICATION, SEARCH_RESULT_INDICATION_IN_OVERVIEW_RULER, 3);
        this.fSourceViewerDecorationSupport.setAnnotationPainterPreferenceKeys((Object)AnnotationType.INFO, INFO_INDICATION_COLOR, INFO_INDICATION, INFO_INDICATION_IN_OVERVIEW_RULER, 4);
        this.fSourceViewerDecorationSupport.setAnnotationPainterPreferenceKeys((Object)AnnotationType.WARNING, WARNING_INDICATION_COLOR, WARNING_INDICATION, WARNING_INDICATION_IN_OVERVIEW_RULER, 5);
        this.fSourceViewerDecorationSupport.setAnnotationPainterPreferenceKeys((Object)AnnotationType.ERROR, ERROR_INDICATION_COLOR, ERROR_INDICATION, ERROR_INDICATION_IN_OVERVIEW_RULER, 6);
        this.fSourceViewerDecorationSupport.setCursorLinePainterPreferenceKeys(CURRENT_LINE, CURRENT_LINE_COLOR);
        this.fSourceViewerDecorationSupport.setMarginPainterPreferenceKeys(PRINT_MARGIN, PRINT_MARGIN_COLOR, PRINT_MARGIN_COLUMN);
        this.fSourceViewerDecorationSupport.setSymbolicFontName(this.getFontPropertyPreferenceKey());
    }

    class SelectionChangedListener
    implements ISelectionChangedListener {
        SelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            PlantyEditor.this.doSelectionChanged(event);
        }
    }
}

