/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.editor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Available;
import org.apache.tools.ant.taskdefs.Parallel;
import org.apache.tools.ant.taskdefs.PathConvert;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.taskdefs.Sequential;
import org.apache.tools.ant.taskdefs.UpToDate;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.externaltools.internal.ant.dtd.IAttribute;
import org.eclipse.ui.externaltools.internal.ant.dtd.IDfm;
import org.eclipse.ui.externaltools.internal.ant.dtd.IElement;
import org.eclipse.ui.externaltools.internal.ant.dtd.ISchema;
import org.eclipse.ui.externaltools.internal.ant.dtd.ParseError;
import org.eclipse.ui.externaltools.internal.ant.dtd.Parser;
import org.eclipse.ui.externaltools.internal.ant.editor.AntEditorMessages;
import org.eclipse.ui.externaltools.internal.ant.editor.EnclosingTargetSearchingHandler;
import org.eclipse.ui.externaltools.internal.ant.editor.PlantyException;
import org.eclipse.ui.externaltools.internal.ant.editor.PlantySaxDefaultHandler;
import org.eclipse.ui.externaltools.internal.ant.editor.TaskDescriptionProvider;
import org.eclipse.ui.externaltools.internal.ant.editor.utils.ProjectHelper;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsImages;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;
import org.eclipse.ui.part.FileEditorInput;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class PlantyCompletionProcessor
implements IContentAssistProcessor {
    protected static final int PROPOSAL_MODE_NONE = 0;
    protected static final int PROPOSAL_MODE_TASK_PROPOSAL = 1;
    protected static final int PROPOSAL_MODE_ATTRIBUTE_PROPOSAL = 2;
    protected static final int PROPOSAL_MODE_TASK_PROPOSAL_CLOSING = 3;
    protected static final int PROPOSAL_MODE_ATTRIBUTE_VALUE_PROPOSAL = 4;
    protected static final int PROPOSAL_MODE_PROPERTY_PROPOSAL = 5;
    protected static final String REQUIRED = "#REQUIRED";
    protected int lineNumber = -1;
    protected int columnNumber = -1;
    public static final String ANT_1_5_DTD_FILENAME = "/ant1.5b.dtd";
    protected static ISchema dtd;
    protected int cursorPosition = -1;
    protected ITextViewer viewer;
    private char[] autoActivationChars = new char[]{'<', '$', '{'};
    protected TaskDescriptionProvider descriptionProvider = new TaskDescriptionProvider();
    private PlantySaxDefaultHandler lastDefaultHandler;

    public PlantyCompletionProcessor() {
        if (dtd == null) {
            try {
                dtd = this.parseDtd();
            }
            catch (IOException e) {
                ExternalToolsPlugin.getDefault().log(e);
            }
            catch (ParseError e) {
                ExternalToolsPlugin.getDefault().log(e);
            }
        }
    }

    private ISchema parseDtd() throws ParseError, IOException {
        InputStream tempStream = this.getClass().getResourceAsStream(ANT_1_5_DTD_FILENAME);
        InputStreamReader tempReader = new InputStreamReader(tempStream, "UTF-8");
        Parser parser = new Parser();
        return parser.parseDTD(tempReader, "project");
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        this.viewer = viewer;
        return this.determineProposals();
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        return new IContextInformation[0];
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.autoActivationChars;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return AntEditorMessages.getString("PlantyCompletionProcessor.No_Text_Completions_2");
    }

    private ICompletionProposal[] determineProposals() {
        String prefix = this.getCurrentPrefix();
        this.cursorPosition = ((ITextSelection)this.viewer.getSelectionProvider().getSelection()).getOffset();
        IDocument tempDocument = this.viewer.getDocument();
        try {
            this.lineNumber = tempDocument.getLineOfOffset(this.cursorPosition);
            this.columnNumber = this.cursorPosition - tempDocument.getLineOffset(this.lineNumber);
        }
        catch (BadLocationException e) {
            ExternalToolsPlugin.getDefault().log(e);
        }
        if (prefix == null || this.cursorPosition == -1) {
            IWorkbenchWindow window;
            if (ExternalToolsPlugin.getDefault().isDebugging()) {
                ExternalToolsPlugin.getDefault().log(AntEditorMessages.getString("PlantyCompletionProcessor.Could_not_do_completion_3"), null);
            }
            if ((window = ExternalToolsPlugin.getActiveWorkbenchWindow()) != null) {
                window.getShell().getDisplay().beep();
            }
            return null;
        }
        ICompletionProposal[] proposals = this.getProposalsFromDocument(tempDocument.get(), prefix);
        return proposals;
    }

    protected ICompletionProposal[] getProposalsFromDocument(String aDocumentString, String aPrefix) {
        String tempTaskString = null;
        switch (this.determineProposalMode(aDocumentString, this.cursorPosition, aPrefix)) {
            case 0: {
                break;
            }
            case 2: {
                tempTaskString = this.getTaskStringFromDocumentStringToPrefix(aDocumentString.substring(0, this.cursorPosition - aPrefix.length()));
                return this.getAttributeProposals(tempTaskString, aPrefix);
            }
            case 1: {
                return this.getTaskProposals(aDocumentString, this.findParentElement(aDocumentString, this.lineNumber, this.columnNumber), aPrefix);
            }
            case 3: {
                return this.getClosingTaskProposals(this.findNotClosedParentElement(aDocumentString, this.lineNumber, this.columnNumber), aPrefix);
            }
            case 4: {
                tempTaskString = this.getTaskStringFromDocumentStringToPrefix(aDocumentString.substring(0, this.cursorPosition - aPrefix.length()));
                String tempAttributeString = this.getAttributeStringFromDocumentStringToPrefix(aDocumentString.substring(0, this.cursorPosition - aPrefix.length()));
                return this.getAttributeValueProposals(tempTaskString, tempAttributeString, aPrefix);
            }
            case 5: {
                return this.getPropertyProposals(aDocumentString, aPrefix, this.cursorPosition);
            }
        }
        return new ICompletionProposal[0];
    }

    protected ICompletionProposal[] getAttributeProposals(String aTaskName, String aPrefix) {
        ArrayList<CompletionProposal> tempProposals = new ArrayList<CompletionProposal>();
        IElement tempElement = dtd.getElement(aTaskName);
        if (tempElement != null) {
            Iterator tempKeys = tempElement.getAttributes().keySet().iterator();
            while (tempKeys.hasNext()) {
                String tempDescription;
                String tempAttrName = (String)tempKeys.next();
                if (!tempAttrName.startsWith(aPrefix)) continue;
                IAttribute tempDTDAttribute = (IAttribute)tempElement.getAttributes().get(tempAttrName);
                String tempReplacementString = String.valueOf(tempAttrName) + "=\"\"";
                String tempDisplayString = tempAttrName;
                String[] tempItems = tempDTDAttribute.getEnum();
                if (tempItems != null) {
                    if (tempItems.length > 1) {
                        tempDisplayString = String.valueOf(tempDisplayString) + " - (";
                    }
                    int i = 0;
                    while (i < tempItems.length) {
                        tempDisplayString = String.valueOf(tempDisplayString) + tempItems[i];
                        tempDisplayString = i + 1 < tempItems.length ? String.valueOf(tempDisplayString) + " | " : String.valueOf(tempDisplayString) + ")";
                        ++i;
                    }
                }
                String tempProposalInfo = null;
                String tempRequired = this.descriptionProvider.getRequiredAttributeForTaskAttribute(aTaskName, tempAttrName);
                if (tempRequired != null && tempRequired.length() > 0) {
                    tempProposalInfo = String.valueOf(AntEditorMessages.getString("PlantyCompletionProcessor.Required___4")) + tempRequired;
                    tempProposalInfo = String.valueOf(tempProposalInfo) + "<BR><BR>";
                }
                if ((tempDescription = this.descriptionProvider.getDescriptionForTaskAttribute(aTaskName, tempAttrName)) != null) {
                    tempProposalInfo = tempProposalInfo == null ? "" : tempProposalInfo;
                    tempProposalInfo = String.valueOf(tempProposalInfo) + tempDescription;
                }
                CompletionProposal tempProposal = new CompletionProposal(tempReplacementString, this.cursorPosition - aPrefix.length(), aPrefix.length(), tempAttrName.length() + 2, null, tempDisplayString, null, tempProposalInfo);
                tempProposals.add(tempProposal);
            }
        }
        return tempProposals.toArray(new ICompletionProposal[tempProposals.size()]);
    }

    protected ICompletionProposal[] getAttributeValueProposals(String aTaskName, String anAttributeName, String aPrefix) {
        String[] tempItems;
        IAttribute tempAttribute;
        ArrayList<CompletionProposal> tempProposals = new ArrayList<CompletionProposal>();
        IElement tempElement = dtd.getElement(aTaskName);
        if (tempElement != null && (tempAttribute = (IAttribute)tempElement.getAttributes().get(anAttributeName)) != null && (tempItems = tempAttribute.getEnum()) != null) {
            int i = 0;
            while (i < tempItems.length) {
                String tempItem = tempItems[i];
                if (tempItem.startsWith(aPrefix)) {
                    CompletionProposal tempProposal = new CompletionProposal(tempItem, this.cursorPosition - aPrefix.length(), aPrefix.length(), tempItem.length(), null, tempItem, null, null);
                    tempProposals.add(tempProposal);
                }
                ++i;
            }
        }
        return tempProposals.toArray(new ICompletionProposal[tempProposals.size()]);
    }

    protected ICompletionProposal[] getPropertyProposals(String aDocumentText, String aPrefix, int aCursorPosition) {
        CompletionSet tempProposals = new CompletionSet();
        Map tempProperties = this.findPropertiesFromDocument(aDocumentText);
        Iterator i = tempProperties.keySet().iterator();
        while (i.hasNext()) {
            String tempPropertyValue;
            String tempPropertyName = (String)i.next();
            if (!tempPropertyName.startsWith(aPrefix)) continue;
            String tempAdditPropInfo = tempPropertyValue = (String)tempProperties.get(tempPropertyName);
            int tempReplacementLength = aPrefix.length();
            int tempReplacementOffset = 0;
            String tempStringToPrefix = aDocumentText.substring(0, aCursorPosition - aPrefix.length());
            String tempLastTwoCharacters = tempStringToPrefix.substring(tempStringToPrefix.length() - 2, tempStringToPrefix.length());
            if (tempLastTwoCharacters.equals("${")) {
                tempReplacementLength += 2;
                tempReplacementOffset = aCursorPosition - aPrefix.length() - 2;
            } else if (tempLastTwoCharacters.endsWith("$")) {
                ++tempReplacementLength;
                tempReplacementOffset = aCursorPosition - aPrefix.length() - 1;
            } else {
                throw new PlantyException(AntEditorMessages.getString("PlantyCompletionProcessor.Error"));
            }
            if (aDocumentText.length() > aCursorPosition && aDocumentText.charAt(aCursorPosition) == '}') {
                ++tempReplacementLength;
            }
            String tempReplacementString = "${" + tempPropertyName + '}';
            Image tempImage = ExternalToolsImages.getImage("org.eclipse.ui.externaltools.property");
            CompletionProposal tempProposal = new CompletionProposal(tempReplacementString, tempReplacementOffset, tempReplacementLength, tempReplacementString.length(), tempImage, tempPropertyName, null, tempAdditPropInfo);
            tempProposals.add(tempProposal);
        }
        return tempProposals.toArray(new ICompletionProposal[tempProposals.size()]);
    }

    protected ICompletionProposal[] getTaskProposals(String aWholeDocumentString, Element aParentTaskElement, String aPrefix) {
        LinkedList<CompletionProposal> tempProposals = new LinkedList<CompletionProposal>();
        Image tempImage = ExternalToolsImages.getImage("org.eclipse.ui.externaltools.html_tab_obj");
        if (aParentTaskElement == null) {
            IElement tempRootElement;
            String tempRootElementName = null;
            if (this.lastDefaultHandler != null) {
                tempRootElementName = this.lastDefaultHandler.rootElementName;
            }
            if (tempRootElementName == null) {
                tempRootElementName = String.valueOf(aPrefix) + "project";
            }
            if ((tempRootElement = dtd.getElement(tempRootElementName)) != null && tempRootElementName.startsWith(aPrefix)) {
                String tempProposalInfo = null;
                String tempDescription = this.descriptionProvider.getDescriptionForTask(tempRootElementName);
                if (tempDescription != null) {
                    tempProposalInfo = tempDescription;
                }
                String tempReplacementString = this.getTaskProposalReplacementString(tempRootElementName);
                int tempReplacementOffset = this.cursorPosition - aPrefix.length();
                int tempReplacementLength = aPrefix.length();
                if (tempReplacementOffset > 0 && tempReplacementOffset - 1 < aWholeDocumentString.length() && aWholeDocumentString.charAt(tempReplacementOffset - 1) == '<') {
                    --tempReplacementOffset;
                    ++tempReplacementLength;
                }
                CompletionProposal tempProposal = new CompletionProposal(tempReplacementString, tempReplacementOffset, tempReplacementLength, tempRootElementName.length() + 2, tempImage, tempRootElementName, null, tempProposalInfo);
                tempProposals.add(tempProposal);
            }
        } else {
            IElement parent = dtd.getElement(aParentTaskElement.getTagName());
            if (parent != null) {
                IDfm dfm = parent.getDfm();
                String[] accepts = dfm.getAccepts();
                int i = 0;
                while (i < accepts.length) {
                    String tempElementName = accepts[i];
                    if (tempElementName.startsWith(aPrefix)) {
                        String tempProposalInfo = null;
                        String tempDescription = this.descriptionProvider.getDescriptionForTask(tempElementName);
                        if (tempDescription != null) {
                            tempProposalInfo = tempDescription;
                        }
                        String tempReplacementString = this.getTaskProposalReplacementString(tempElementName);
                        int tempReplacementOffset = this.cursorPosition - aPrefix.length();
                        int tempReplacementLength = aPrefix.length();
                        if (tempReplacementOffset > 0 && aWholeDocumentString.charAt(tempReplacementOffset - 1) == '<') {
                            --tempReplacementOffset;
                            ++tempReplacementLength;
                        }
                        CompletionProposal tempProposal = new CompletionProposal(tempReplacementString, tempReplacementOffset, tempReplacementLength, tempElementName.length() + 2, tempImage, tempElementName, null, tempProposalInfo);
                        tempProposals.add(tempProposal);
                    }
                    ++i;
                }
            }
        }
        return tempProposals.toArray(new ICompletionProposal[tempProposals.size()]);
    }

    private ICompletionProposal[] getClosingTaskProposals(Element aUnclosedTaskElement, String aPrefix) {
        CompletionSet tempProposals = new CompletionSet();
        if (aUnclosedTaskElement != null && aUnclosedTaskElement.getTagName().startsWith(aPrefix)) {
            String tempReplaceString = aUnclosedTaskElement.getTagName();
            tempProposals.add(new CompletionProposal(String.valueOf(tempReplaceString) + '>', this.cursorPosition - aPrefix.length(), aPrefix.length(), tempReplaceString.length() + 1, null, tempReplaceString, null, null));
        }
        return tempProposals.toArray(new ICompletionProposal[tempProposals.size()]);
    }

    private String getTaskProposalReplacementString(String aTaskName) {
        StringBuffer tempReplacement = new StringBuffer("<");
        tempReplacement.append(aTaskName);
        if (this.isEmpty(aTaskName)) {
            tempReplacement.append(" />");
        } else {
            tempReplacement.append(" ></");
            tempReplacement.append(aTaskName);
            tempReplacement.append('>');
        }
        return tempReplacement.toString();
    }

    private boolean isEmpty(String aDTDElementName) {
        IElement element = dtd.getElement(aDTDElementName);
        return element.isEmpty();
    }

    protected Element findChildElementNamedOf(Element anElement, String aChildElementName) {
        NodeList tempNodeList = anElement.getChildNodes();
        int i = 0;
        while (i < tempNodeList.getLength()) {
            Node tempChildNode = tempNodeList.item(i);
            if (tempChildNode.getNodeType() == 1 && tempChildNode.getNodeName().equals(aChildElementName)) {
                return (Element)tempChildNode;
            }
            ++i;
        }
        return null;
    }

    private String getCurrentPrefix() {
        ITextSelection selection = (ITextSelection)this.viewer.getSelectionProvider().getSelection();
        if (selection.getLength() > 0) {
            return null;
        }
        IDocument doc = this.viewer.getDocument();
        return this.getPrefixFromDocument(doc.get(), selection.getOffset()).toLowerCase();
    }

    protected String getPrefixFromDocument(String aDocumentText, int anOffset) {
        int startOfWordToken = anOffset;
        while (startOfWordToken > 0 && (Character.isJavaIdentifierPart(aDocumentText.charAt(startOfWordToken - 1)) || '.' == aDocumentText.charAt(startOfWordToken - 1)) && '$' != aDocumentText.charAt(startOfWordToken - 1)) {
            --startOfWordToken;
        }
        if (startOfWordToken != anOffset) {
            return aDocumentText.substring(startOfWordToken, anOffset);
        }
        return "";
    }

    protected int determineProposalMode(String aWholeDocumentString, int aCursorPosition, String aPrefix) {
        String tempLastTwoCharacters;
        String tempStringToPrefix = aWholeDocumentString.substring(0, aCursorPosition - aPrefix.length());
        String tempTrimmedString = tempStringToPrefix.trim();
        char tempLastChar = '\u0000';
        if (tempTrimmedString.length() <= 0) {
            return 1;
        }
        tempLastChar = tempTrimmedString.charAt(tempTrimmedString.length() - 1);
        if (tempStringToPrefix.charAt(tempStringToPrefix.length() - 1) != tempLastChar && tempLastChar != '>') {
            String tempTaskString;
            if (tempLastChar != '>' && tempLastChar != '<' && (tempTaskString = this.getTaskStringFromDocumentStringToPrefix(tempTrimmedString)) != null && this.isNamedTaskKnown(tempTaskString)) {
                return 2;
            }
        } else if (tempStringToPrefix.charAt(tempStringToPrefix.length() - 1) == '\"') {
            String tempTaskString = this.getTaskStringFromDocumentStringToPrefix(tempTrimmedString);
            if (tempTaskString != null && this.isNamedTaskKnown(tempTaskString)) {
                return 4;
            }
        } else {
            int tempSpaceIndex = tempStringToPrefix.lastIndexOf(32);
            int tempLessThanIndex = tempStringToPrefix.lastIndexOf(60);
            int tempGreaterThanIndex = tempStringToPrefix.lastIndexOf(62);
            if (tempLessThanIndex > tempSpaceIndex && tempGreaterThanIndex < tempLessThanIndex) {
                int tempSlashIndex = tempStringToPrefix.lastIndexOf(47);
                if (tempSlashIndex == tempLessThanIndex + 1) {
                    return 3;
                }
                return 1;
            }
            if (tempLessThanIndex < tempGreaterThanIndex && "".equals(aPrefix)) {
                char tempChar;
                int tempActIndex = aCursorPosition;
                while (((tempChar = tempStringToPrefix.charAt(--tempActIndex)) == ' ' || tempChar == '\t' || tempChar == '\n' || tempChar == '\r') && tempActIndex > tempGreaterThanIndex) {
                }
                if (tempActIndex == tempGreaterThanIndex) {
                    return 1;
                }
            }
        }
        if (tempStringToPrefix.length() >= 2 && ((tempLastTwoCharacters = tempStringToPrefix.substring(tempStringToPrefix.length() - 2, tempStringToPrefix.length())).equals("${") || tempStringToPrefix.charAt(tempStringToPrefix.length() - 1) == '$')) {
            return 5;
        }
        return 0;
    }

    private String getTaskStringFromDocumentStringToPrefix(String aDocumentStringToPrefix) {
        int tempLessThanIndex = aDocumentStringToPrefix.lastIndexOf(60);
        if (tempLessThanIndex > -1) {
            String tempTaskString = aDocumentStringToPrefix.trim();
            int tempIndex = (tempTaskString = tempTaskString.substring(tempLessThanIndex + 1, tempTaskString.length())).indexOf(32);
            if (tempIndex > 0) {
                tempTaskString = tempTaskString.substring(0, tempIndex);
            }
            if ((tempIndex = tempTaskString.indexOf(10)) > 0) {
                tempTaskString = tempTaskString.substring(0, tempIndex);
            }
            if ((tempIndex = tempTaskString.indexOf(13)) > 0) {
                tempTaskString = tempTaskString.substring(0, tempIndex);
            }
            return tempTaskString;
        }
        return null;
    }

    private String getAttributeStringFromDocumentStringToPrefix(String aDocumentStringToPrefix) {
        int tempIndex = aDocumentStringToPrefix.lastIndexOf(61);
        String tempSubString = aDocumentStringToPrefix.substring(0, tempIndex);
        tempIndex = (tempSubString = tempSubString.trim()).lastIndexOf(32);
        if (tempIndex > 0) {
            tempSubString = tempSubString.substring(tempIndex + 1, tempSubString.length());
        }
        if ((tempIndex = tempSubString.lastIndexOf(10)) > 0) {
            tempSubString = tempSubString.substring(tempIndex + 1, tempSubString.length());
        }
        if ((tempIndex = tempSubString.lastIndexOf(13)) > 0) {
            tempSubString = tempSubString.substring(tempIndex + 1, tempSubString.length());
        }
        return tempSubString;
    }

    private boolean isNamedTaskKnown(String aTaskName) {
        return dtd.getElement(aTaskName) != null;
    }

    protected Element findParentElement(String aWholeDocumentString, int aLineNumber, int aColumnNumber) {
        return this.parseEditedFileSearchingForParent(aWholeDocumentString, aLineNumber, aColumnNumber).getParentElement(true);
    }

    protected PlantySaxDefaultHandler parseEditedFileSearchingForParent(String aWholeDocumentString, int aLineNumber, int aColumnNumber) {
        SAXParser tempParser = null;
        try {
            tempParser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (ParserConfigurationException e) {
            ExternalToolsPlugin.getDefault().log(e);
            return null;
        }
        catch (SAXException e) {
            ExternalToolsPlugin.getDefault().log(e);
            return null;
        }
        PlantySaxDefaultHandler tempHandler = null;
        File editedFile = this.getEditedFile();
        try {
            File parent = null;
            if (editedFile != null) {
                parent = editedFile.getParentFile();
            }
            tempHandler = new PlantySaxDefaultHandler(parent, aLineNumber, aColumnNumber);
        }
        catch (ParserConfigurationException e) {
            ExternalToolsPlugin.getDefault().log(e);
        }
        InputSource tempInputSource = new InputSource(new StringReader(aWholeDocumentString));
        if (editedFile != null) {
            tempInputSource.setSystemId(editedFile.getAbsolutePath());
        }
        try {
            tempParser.parse(tempInputSource, (DefaultHandler)tempHandler);
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (SAXException e) {
            ExternalToolsPlugin.getDefault().log(e);
        }
        catch (IOException iOException) {}
        this.lastDefaultHandler = tempHandler;
        return tempHandler;
    }

    protected Map findPropertiesFromDocument(String aWholeDocumentString) {
        Target curtarget;
        Project tempProject = new Project();
        tempProject.init();
        File tempFile = this.getEditedFile();
        String filePath = "";
        if (tempFile != null) {
            filePath = tempFile.getAbsolutePath();
        }
        tempProject.setUserProperty("ant.file", filePath);
        try {
            ProjectHelper.configureProject(tempProject, tempFile, aWholeDocumentString);
        }
        catch (BuildException buildException) {}
        Hashtable properties = tempProject.getProperties();
        Element tempElement = this.findEnclosingTargetElement(aWholeDocumentString, this.lineNumber, this.columnNumber);
        String tempTargetName = null;
        if (tempElement == null || (tempTargetName = tempElement.getAttribute("name")) == null || tempTargetName.length() == 0) {
            return properties;
        }
        Vector tempSortedTargets = null;
        try {
            tempSortedTargets = tempProject.topoSort(tempTargetName, tempProject.getTargets());
        }
        catch (BuildException buildException) {
            return tempProject.getProperties();
        }
        int curidx = 0;
        do {
            curtarget = (Target)tempSortedTargets.get(curidx++);
            Task[] tempTasks = curtarget.getTasks();
            int i = 0;
            while (i < tempTasks.length) {
                Task tempTask = tempTasks[i];
                boolean cfr_ignored_0 = tempTask instanceof Sequential;
                boolean cfr_ignored_1 = tempTask instanceof Parallel;
                if (tempTask instanceof Property || tempTask instanceof PathConvert || tempTask instanceof Available || tempTask instanceof UpToDate || tempTask instanceof Condition) {
                    tempTask.perform();
                }
                ++i;
            }
        } while (!curtarget.getName().equals(tempTargetName));
        return tempProject.getProperties();
    }

    protected File getEditedFile() {
        IWorkbenchPage page = ExternalToolsPlugin.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor == null) {
            return null;
        }
        FileEditorInput tempInput = (FileEditorInput)editor.getEditorInput();
        String tempProjectPath = tempInput.getFile().getProject().getLocation().toFile().getAbsolutePath();
        String tempProjectRelativeFilePath = tempInput.getFile().getFullPath().removeFirstSegments(1).makeRelative().toString();
        File tempFile = new File(String.valueOf(tempProjectPath) + File.separator + tempProjectRelativeFilePath);
        return tempFile;
    }

    protected Element findNotClosedParentElement(String aWholeDocumentString, int aLineNumber, int aColumnNumber) {
        PlantySaxDefaultHandler tempHandler = this.parseEditedFileSearchingForParent(aWholeDocumentString, aLineNumber, aColumnNumber);
        if (tempHandler != null && tempHandler.getParentElement(false) == null) {
            return tempHandler.getParentElement(true);
        }
        return null;
    }

    protected Element findEnclosingTargetElement(String aWholeDocumentString, int aLineNumber, int aColumnNumber) {
        SAXParser tempParser = null;
        try {
            tempParser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (ParserConfigurationException e) {
            ExternalToolsPlugin.getDefault().log(e);
            return null;
        }
        catch (SAXException e) {
            ExternalToolsPlugin.getDefault().log(e);
            return null;
        }
        EnclosingTargetSearchingHandler tempHandler = null;
        File editedFile = this.getEditedFile();
        try {
            File parent = null;
            if (editedFile != null) {
                parent = editedFile.getParentFile();
            }
            tempHandler = new EnclosingTargetSearchingHandler(parent, aLineNumber, aColumnNumber);
        }
        catch (ParserConfigurationException e) {
            ExternalToolsPlugin.getDefault().log(e);
        }
        InputSource tempInputSource = new InputSource(new StringReader(aWholeDocumentString));
        if (editedFile != null) {
            tempInputSource.setSystemId(editedFile.getAbsolutePath());
        }
        try {
            tempParser.parse(tempInputSource, (DefaultHandler)tempHandler);
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (SAXException e) {
            ExternalToolsPlugin.getDefault().log(e);
        }
        catch (IOException e) {
            ExternalToolsPlugin.getDefault().log(e);
        }
        return tempHandler.getParentElement(true);
    }

    public class CompletionComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            String tempString1 = ((ICompletionProposal)o1).getDisplayString();
            String tempString2 = ((ICompletionProposal)o2).getDisplayString();
            return tempString1.compareTo(tempString2);
        }
    }

    protected class CompletionSet
    extends TreeSet {
        private Map displayStringToProposal = new HashMap();

        public CompletionSet() {
            super(new Comparator(){

                public int compare(Object o1, Object o2) {
                    String tempString1 = ((ICompletionProposal)o1).getDisplayString();
                    String tempString2 = ((ICompletionProposal)o2).getDisplayString();
                    return tempString1.compareTo(tempString2);
                }
            });
        }

        public boolean add(Object o) {
            ICompletionProposal tempProposal = (ICompletionProposal)o;
            if (!this.displayStringToProposal.containsKey(tempProposal.getDisplayString())) {
                boolean tempResult = super.add(o);
                if (tempResult) {
                    this.displayStringToProposal.put(tempProposal.getDisplayString(), tempProposal);
                }
                return tempResult;
            }
            return false;
        }

        public boolean contains(Object o) {
            ICompletionProposal tempProposal = (ICompletionProposal)o;
            return !this.displayStringToProposal.containsKey(tempProposal.getDisplayString());
        }

        public boolean remove(Object o) {
            Object tempObject;
            ICompletionProposal tempProposal = (ICompletionProposal)o;
            boolean tempResult = super.remove(o);
            if (tempResult && (tempObject = this.displayStringToProposal.remove(tempProposal.getDisplayString())) == null) {
                throw new NoSuchElementException(AntEditorMessages.getString("PlantyCompletionProcessor.Serious_Error"));
            }
            return tempResult;
        }
    }
}

