/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.editor;

import java.io.File;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ui.externaltools.internal.ant.editor.AntEditorMessages;
import org.eclipse.ui.externaltools.internal.ant.editor.PlantyException;
import org.eclipse.ui.externaltools.internal.ant.editor.PlantySaxDefaultHandler;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class EnclosingTargetSearchingHandler
extends PlantySaxDefaultHandler {
    protected boolean enclosingTargetElementDetermined;

    public EnclosingTargetSearchingHandler(File mainFileContainer, int aRowOfCursorPosition, int aColumnOfCursorPosition) throws ParserConfigurationException {
        super(mainFileContainer, aRowOfCursorPosition, aColumnOfCursorPosition);
    }

    public void endElement(String aUri, String aLocalName, String aQualifiedName) throws SAXException {
        Element tempLastStillOpenElement;
        String tempTagName;
        if (ExternalToolsPlugin.getDefault() != null && ExternalToolsPlugin.getDefault().isDebugging()) {
            ExternalToolsPlugin.getDefault().log("PlantySaxDefaultHandler.endElement(" + aUri + ", " + aLocalName + ", " + aQualifiedName + ")", null);
        }
        if (this.parsingFinished) {
            return;
        }
        boolean tempParentKnown = this.checkForParentElement();
        String string = tempTagName = aLocalName.length() > 0 ? aLocalName : aQualifiedName;
        if (tempTagName.equals("target") && !this.stillOpenElements.isEmpty() && (tempLastStillOpenElement = (Element)this.stillOpenElements.peek()) != null && tempLastStillOpenElement.getTagName().equals(tempTagName)) {
            this.stillOpenElements.pop();
            if (!this.stillOpenElements.empty()) {
                Element tempSecondLastStillOpenElement = (Element)this.stillOpenElements.peek();
                tempSecondLastStillOpenElement.appendChild(tempLastStillOpenElement);
            }
            if (tempParentKnown && this.parentElement != null && this.parentElement.getTagName().equals(tempTagName)) {
                this.parsingFinished = true;
            }
        }
    }

    public void startElement(String aUri, String aLocalName, String aQualifiedName, Attributes anAttributes) throws SAXException {
        String tempTagName;
        if (ExternalToolsPlugin.getDefault() != null && ExternalToolsPlugin.getDefault().isDebugging()) {
            ExternalToolsPlugin.getDefault().log("PlantySaxDefaultHandler.startElement(" + aUri + ", " + aLocalName + ", " + aQualifiedName + ", " + anAttributes + ")", null);
        }
        if (this.parsingFinished) {
            return;
        }
        this.checkForParentElement();
        String string = tempTagName = aLocalName.length() > 0 ? aLocalName : aQualifiedName;
        if (tempTagName == null || tempTagName.length() == 0) {
            throw new PlantyException(AntEditorMessages.getString("EnclosingTargetSearchingHandler.Error_parsing"));
        }
        if (tempTagName.equals("target")) {
            Element tempElement = this.document.createElement(tempTagName);
            String tempTargetName = anAttributes.getValue("name");
            if (tempTargetName != null && tempTargetName.length() > 0) {
                tempElement.setAttribute("name", tempTargetName);
            }
            this.stillOpenElements.push(tempElement);
        }
    }

    protected boolean checkForParentElement() {
        if (this.parentElement == null && !this.enclosingTargetElementDetermined) {
            if (this.locator != null) {
                int tempLineNr = this.locator.getLineNumber() - 1;
                int tempColumnNr = this.locator.getColumnNumber() - 1;
                if (tempLineNr > this.rowOfCursorPosition || tempLineNr == this.rowOfCursorPosition && tempColumnNr > this.columnOfCursorPosition) {
                    this.determineEnclosingTargetTaskElement();
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    protected void determineEnclosingTargetTaskElement() {
        while (this.parentElement == null && !this.stillOpenElements.empty()) {
            Element tempElement = (Element)this.stillOpenElements.pop();
            if (!tempElement.getTagName().equals("target")) continue;
            this.parentElement = tempElement;
            if (ExternalToolsPlugin.getDefault() == null || !ExternalToolsPlugin.getDefault().isDebugging()) continue;
            ExternalToolsPlugin.getDefault().log("EnclosingTargetSearchingHandler.checkForParentElement(): Enclosing target element found: " + this.parentElement, null);
        }
        this.enclosingTargetElementDetermined = true;
    }

    public Element getParentElement(boolean aGuessParentFlag) {
        if (this.enclosingTargetElementDetermined) {
            return this.parentElement;
        }
        if (aGuessParentFlag && !this.stillOpenElements.empty()) {
            this.determineEnclosingTargetTaskElement();
            return this.parentElement;
        }
        return null;
    }
}

