/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.dtd.util;

import java.util.Comparator;
import org.eclipse.ui.externaltools.internal.ant.dtd.util.Factory;
import org.eclipse.ui.externaltools.internal.ant.dtd.util.IMapHolder;
import org.eclipse.ui.externaltools.internal.ant.dtd.util.SortedMap;

public class SortedMapFactory {
    private static final StringComparator fStringComp = new StringComparator();
    private static final IndirectStringComparator fIndirectStringComp = new IndirectStringComparator();
    private static final Factory fFactory = new Factory();

    public static SortedMap getMap(IMapHolder holder, Comparator comp) {
        SortedMap map = (SortedMap)fFactory.getFree();
        if (map == null) {
            map = new SortedMap();
        }
        map.setMapHolder(holder);
        map.setComparator(comp);
        return map;
    }

    public static SortedMap getStringMap(IMapHolder holder) {
        return SortedMapFactory.getMap(holder, fStringComp);
    }

    public static SortedMap getIndirectStringMap(IMapHolder holder) {
        return SortedMapFactory.getMap(holder, fIndirectStringComp);
    }

    public static SortedMap getCaseInsensitiveStringMap(IMapHolder holder) {
        return SortedMapFactory.getMap(holder, String.CASE_INSENSITIVE_ORDER);
    }

    public static void freeMap(SortedMap map) {
        map.setComparator(null);
        map.setMapHolder(null);
        fFactory.setFree(map);
    }

    private static class StringComparator
    implements Comparator {
        StringComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((String)o1).compareTo(o2);
        }
    }

    private static class IndirectStringComparator
    implements Comparator {
        IndirectStringComparator() {
        }

        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }
}

