/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.dtd.schema;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.ui.externaltools.internal.ant.dtd.IModel;
import org.eclipse.ui.externaltools.internal.ant.dtd.ISchema;
import org.eclipse.ui.externaltools.internal.ant.dtd.schema.AntDTDSchemaMessages;
import org.eclipse.ui.externaltools.internal.ant.dtd.schema.Attribute;
import org.eclipse.ui.externaltools.internal.ant.dtd.schema.Element;
import org.eclipse.ui.externaltools.internal.ant.dtd.schema.Model;
import org.eclipse.ui.externaltools.internal.ant.dtd.schema.Schema;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;

public class SchemaFactory
implements DeclHandler {
    private char[] fBuf;
    private int fLen;
    private int fPos;
    private Element fElement;
    private Schema fSchema = new Schema();
    private static HashSet fTypes = new HashSet();
    private Exception fErrorException;

    static {
        fTypes.add("CDATA");
        fTypes.add("ID");
        fTypes.add("IDREF");
        fTypes.add("IDREFS");
        fTypes.add("NMTOKEN");
        fTypes.add("NMTOKENS");
        fTypes.add("ENTITY");
        fTypes.add("ENTITIES");
    }

    public ISchema getSchema() {
        this.fSchema.setErrorException(this.fErrorException);
        return this.fSchema;
    }

    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
        Element element = this.getElement(eName);
        Attribute attr = (Attribute)element.getAttributes().get(aName);
        if (attr == null) {
            attr = new Attribute(aName, element);
            element.addAttribute(attr);
            String[] stringArray = null;
            if (fTypes.contains(type)) {
                attr.setType(type);
            } else if (type.startsWith("NOTATION")) {
                stringArray = this.parseValues(type.substring("NOTATION".length() + 1), ',');
            } else {
                type = this.stripSurroundingParentheses(type);
                stringArray = this.parseValues(type, '|');
            }
            attr.setEnum(stringArray);
            attr.setRequired(valueDefault == null || !valueDefault.equals("#IMPLIED"));
            attr.setFixed(valueDefault != null && valueDefault.equals("#FIXED"));
            attr.setDefault(value);
        }
    }

    private String stripSurroundingParentheses(String aString) {
        if (aString.startsWith("(")) {
            aString = aString.substring(1);
        }
        if (aString.endsWith(")")) {
            aString = aString.substring(0, aString.length() - 1);
        }
        return aString;
    }

    private Element getElement(String eName) {
        Element element = (Element)this.fSchema.getElement(eName);
        if (element == null) {
            element = new Element(eName);
            this.fSchema.addElement(element);
        }
        return element;
    }

    private String[] parseValues(String type, char separator) {
        int start = 0;
        int len = type.length();
        LinkedList<String> values = new LinkedList<String>();
        while (start < len) {
            int pos = type.indexOf(separator, start);
            if (pos < 0) {
                pos = len;
            }
            String term = type.substring(start, pos);
            start = pos + 1;
            values.add(term);
        }
        return values.toArray(new String[values.size()]);
    }

    public void elementDecl(String name, String model) throws SAXException {
        Element element = this.getElement(name);
        if (!element.isUndefined()) {
            throw new SAXException(MessageFormat.format(AntDTDSchemaMessages.getString("SchemaFactory.Doubly_defined"), name));
        }
        this.fElement = element;
        if (model.equals("ANY")) {
            element.setAny(true);
        } else if (model.equals("EMPTY")) {
            element.setEmpty(true);
        } else if (model.equals("(#PCDATA)")) {
            element.setText(true);
        } else if (model.startsWith("(#PCDATA")) {
            element.setMixed(true);
        } else {
            element.setContentModel(this.parseModel(model));
        }
    }

    private IModel parseModel(String model) throws SAXException {
        IModel emodel;
        this.fBuf = model.toCharArray();
        this.fLen = this.fBuf.length;
        if (this.fBuf[0] != '(') {
            throw new SAXException(MessageFormat.format(AntDTDSchemaMessages.getString("SchemaFactory.Start_with_left_parenthesis"), this.fElement.getName()));
        }
        boolean ortext = model.startsWith("(#PCDATA|");
        if (ortext) {
            this.fPos = "(#PCDATA".length() + 1;
            emodel = this.scanExpr();
        } else {
            this.fPos = 0;
            emodel = this.scanExpr();
        }
        return emodel;
    }

    private IModel scanExpr() throws SAXException {
        ++this.fPos;
        return this.scanExpr(this.scanElement());
    }

    private IModel scanExpr(IModel term) throws SAXException {
        this.checkLen();
        if (this.fBuf[this.fPos] != ')') {
            char op = this.fBuf[this.fPos];
            if (op != '|' && op != ',') {
                throw new SAXException(MessageFormat.format(AntDTDSchemaMessages.getString("SchemaFactory.Expecting_operator_or_right_parenthesis"), this.fElement.getName(), String.valueOf(this.fBuf)));
            }
            Model model = new Model(op == '|' ? 2 : 1);
            model.addModel(term);
            term = model;
            while (this.fBuf[this.fPos] == op) {
                ++this.fPos;
                IModel next = this.scanElement();
                model.addModel(next);
            }
            if (this.fBuf[this.fPos] != ')') {
                throw new SAXException(MessageFormat.format(AntDTDSchemaMessages.getString("SchemaFactory.Expecting_operator_or_right_parenthesis"), this.fElement.getName(), String.valueOf(this.fBuf)));
            }
            ++this.fPos;
        }
        return term;
    }

    private IModel scanElement() throws SAXException {
        this.checkLen();
        if (this.fBuf[this.fPos] == '(') {
            return this.scanExpr();
        }
        StringBuffer sb = new StringBuffer();
        while (this.fBuf[this.fPos] != '|' && this.fBuf[this.fPos] != ',' && this.fBuf[this.fPos] != ')' && this.fBuf[this.fPos] != '*' && this.fBuf[this.fPos] != '+' && this.fBuf[this.fPos] != '?') {
            sb.append(this.fBuf[this.fPos++]);
            this.checkLen();
        }
        String name = sb.toString();
        Element element = this.getElement(name);
        Model model = new Model(4);
        model.setLeaf(element);
        return model;
    }

    private void checkLen() throws SAXException {
        if (this.fPos == this.fLen) {
            throw new SAXException(MessageFormat.format(AntDTDSchemaMessages.getString("SchemaFactory.Unexpected_end"), this.fElement.getName(), String.valueOf(this.fBuf)));
        }
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
    }

    public void setErrorException(Exception e) {
        this.fErrorException = e;
    }
}

