/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.dtd.schema;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.ui.externaltools.internal.ant.dtd.IAtom;
import org.eclipse.ui.externaltools.internal.ant.dtd.IModel;
import org.eclipse.ui.externaltools.internal.ant.dtd.schema.AntDTDSchemaMessages;
import org.eclipse.ui.externaltools.internal.ant.dtd.schema.Nfm;

public class Model
implements IModel {
    protected int fKind;
    protected int fMin = 1;
    protected int fMax = 1;
    protected int fNum = 0;
    protected IModel[] fContents;
    protected List fContentsList;
    protected IAtom fLeaf;
    protected boolean fMixed;
    protected static IModel[] fEmptyContents = new IModel[0];
    protected static final String[] fOps = new String[]{"?", ",", "|", "&", "!!!"};

    public Model(int kind) {
        this.fKind = kind;
    }

    public Model() {
        this.fKind = 0;
    }

    public void setKind(int kind) {
        this.fKind = kind;
    }

    public void setMinOccurs(int min) {
        this.fMin = min;
    }

    public void setMaxOccurs(int max) {
        this.fMax = max;
    }

    public void setContents(IModel[] contents) {
        this.fContents = contents;
    }

    public void addModel(IModel model) {
        if (this.fContents != null) {
            throw new IllegalStateException(AntDTDSchemaMessages.getString("Model.model_may_not_be_changed"));
        }
        if (this.fContentsList == null) {
            this.fContentsList = new LinkedList();
        }
        this.fContentsList.add(model);
    }

    public void setLeaf(IAtom leaf) {
        this.fLeaf = leaf;
    }

    private Nfm qualifyNfm(Nfm nfm) {
        if (nfm == null) {
            return null;
        }
        if (this.fMin == 1 && this.fMax == 1) {
            return nfm;
        }
        if (this.fMin == 0 && this.fMax == 1) {
            return Nfm.getQuestion(nfm);
        }
        if (this.fMin == 0 && this.fMax == Integer.MAX_VALUE) {
            return Nfm.getStar(nfm);
        }
        if (this.fMin == 1 && this.fMax == Integer.MAX_VALUE) {
            return Nfm.getPlus(nfm);
        }
        if (this.fMax == 0) {
            return Nfm.getNfm(null);
        }
        if (this.fMax == Integer.MAX_VALUE) {
            return Nfm.getUnbounded(nfm, this.fMin);
        }
        return Nfm.getMinMax(nfm, this.fMin, this.fMax);
    }

    public Model shallowCopy() {
        Model copy;
        block3: {
            block2: {
                copy = new Model(this.getKind());
                copy.fMixed = this.fMixed;
                copy.fLeaf = this.fLeaf;
                if (this.fContents == null) break block2;
                copy.fContentsList = new LinkedList();
                int i = 0;
                while (i < this.fContents.length) {
                    copy.fContentsList.add(this.fContents[i]);
                    ++i;
                }
                break block3;
            }
            if (this.fContentsList == null) break block3;
            copy.fContentsList = new LinkedList();
            Iterator it = this.fContentsList.iterator();
            while (it.hasNext()) {
                copy.fContentsList.add(it.next());
            }
        }
        return copy;
    }

    public int getKind() {
        return 0;
    }

    public int getMinOccurs() {
        return this.fMin;
    }

    public int getMaxOccurs() {
        return this.fMax;
    }

    public IModel[] getContents() {
        if (this.fContents == null) {
            if (this.fContentsList != null) {
                this.fContents = this.fContentsList.toArray(new IModel[this.fContentsList.size()]);
                this.fContentsList = null;
            } else {
                this.fContents = fEmptyContents;
            }
        }
        return this.fContents;
    }

    public IAtom getLeaf() {
        return this.fLeaf;
    }

    public String getOperator() {
        return fOps[this.fKind];
    }

    public String stringRep() {
        StringBuffer buf = new StringBuffer();
        this.stringRep(buf);
        return buf.toString();
    }

    private void stringRep(StringBuffer buf) {
        switch (this.getKind()) {
            case 1: 
            case 2: {
                buf.append('(');
                Iterator it = this.fContentsList.iterator();
                while (it.hasNext()) {
                    Model model = (Model)it.next();
                    model.stringRep(buf);
                    if (!it.hasNext()) continue;
                    buf.append(this.getOperator());
                }
                buf.append(')');
                buf.append(this.getQualifier());
                break;
            }
            case 4: {
                IAtom atom = this.getLeaf();
                buf.append(atom.getName());
                break;
            }
            default: {
                buf.append(AntDTDSchemaMessages.getString("Model.***UNKNOWN***_2"));
            }
        }
    }

    public String getQualifier() {
        return this.fMin == 1 ? (this.fMax == Integer.MAX_VALUE ? "+" : "") : (this.fMax == Integer.MAX_VALUE ? "*" : "?");
    }

    public Nfm toNfm() {
        Nfm nfm = null;
        switch (this.fKind) {
            case 1: 
            case 2: {
                IModel[] contents = this.getContents();
                if (contents == null || contents.length == 0) {
                    nfm = null;
                    break;
                }
                nfm = contents[0].toNfm();
                int i = 1;
                while (i < contents.length) {
                    Nfm tmp = contents[i].toNfm();
                    nfm = this.fKind == 1 ? Nfm.getComma(nfm, tmp) : Nfm.getOr(nfm, tmp);
                    ++i;
                }
                break;
            }
            case 4: {
                nfm = Nfm.getNfm(this.fLeaf);
            }
        }
        return this.qualifyNfm(nfm);
    }
}

