/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.dtd.schema;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.externaltools.internal.ant.dtd.IAttribute;
import org.eclipse.ui.externaltools.internal.ant.dtd.IDfm;
import org.eclipse.ui.externaltools.internal.ant.dtd.IElement;
import org.eclipse.ui.externaltools.internal.ant.dtd.IModel;
import org.eclipse.ui.externaltools.internal.ant.dtd.ParseError;
import org.eclipse.ui.externaltools.internal.ant.dtd.schema.Atom;
import org.eclipse.ui.externaltools.internal.ant.dtd.schema.Dfm;
import org.eclipse.ui.externaltools.internal.ant.dtd.schema.Nfm;
import org.eclipse.ui.externaltools.internal.ant.dtd.schema.NfmParser;

public class Element
extends Atom
implements IElement {
    private boolean fUndefined = true;
    private boolean fText;
    private boolean fMixed;
    private IModel fModel;
    private HashMap fMap = new HashMap(4);
    private Dfm fElementDfm;
    private static final NfmParser fNfmParser = new NfmParser();
    private boolean fAny;
    private boolean fEmpty;

    public Element(String name) {
        super(0, name);
    }

    public void setUndefined(boolean undefined) {
        this.fUndefined = undefined;
    }

    public void setText(boolean text) {
        this.fText = text;
    }

    public void setMixed(boolean mixed) {
        this.fMixed = mixed;
    }

    public void setContentModel(IModel model) {
        this.fModel = model;
    }

    public void addAttribute(IAttribute attribute) {
        this.fMap.put(attribute.getName(), attribute);
    }

    public Map getAttributes() {
        return this.fMap;
    }

    public IModel getContentModel() {
        return this.fModel;
    }

    public boolean isMixed() {
        return this.fMixed;
    }

    public boolean isText() {
        return this.fText;
    }

    public boolean isUndefined() {
        return this.fUndefined;
    }

    public IDfm getDfm() {
        Dfm dfm = this.fElementDfm;
        if (dfm == null) {
            this.fElementDfm = dfm = this.parseElementDfm();
        }
        return dfm;
    }

    private Dfm parseElementDfm() {
        Dfm dfm;
        if (this.fAny) {
            dfm = Dfm.dfm(true);
            dfm.any = true;
        } else if (this.fEmpty || this.fText) {
            dfm = Dfm.dfm(true);
            dfm.empty = true;
        } else {
            dfm = this.parseModel(this.fModel);
        }
        return dfm;
    }

    private Dfm parseModel(IModel model) {
        Dfm dfm;
        Nfm nfm = model.toNfm();
        if (nfm != null) {
            try {
                dfm = fNfmParser.parse(nfm, true);
            }
            catch (ParseError parseError) {
                dfm = Dfm.dfm(false);
            }
        } else {
            dfm = Dfm.dfm(false);
        }
        return dfm;
    }

    public boolean isAny() {
        return this.fAny;
    }

    public boolean isEmpty() {
        return this.fEmpty;
    }

    public void setAny(boolean any) {
        this.fAny = any;
    }

    public void setEmpty(boolean empty) {
        this.fEmpty = empty;
    }
}

