/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.cbs.util.time;

import com.sap.tc.cbs.util.time.GMTSimpleDateFormatFactory;
import com.sap.tc.cbs.util.time.ISimpleDateFormatFactory;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimestampUtil {
    private static final ISimpleDateFormatFactory gmtFormatterFactory = GMTSimpleDateFormatFactory.getInstance();

    public static long getTime(Timestamp ts) {
        long time = ((Date)ts).getTime();
        time = time / 1000L * 1000L;
        return time + (long)(ts.getNanos() / 1000000);
    }

    public static int compareTimestamps(Timestamp ts1, Timestamp ts2) {
        if (((Date)ts1).getTime() < ((Date)ts2).getTime()) {
            return -1;
        }
        if (((Date)ts1).getTime() > ((Date)ts2).getTime()) {
            return 1;
        }
        if (ts1.getNanos() < ts2.getNanos()) {
            return -1;
        }
        if (ts1.getNanos() > ts2.getNanos()) {
            return 1;
        }
        return 0;
    }

    public static Date toDate(Timestamp ts) {
        return new Date(TimestampUtil.getTime(ts));
    }

    public static String toGMTString(Timestamp ts) {
        if (ts != null) {
            SimpleDateFormat formatter = null;
            try {
                formatter = gmtFormatterFactory.pop(1);
                String string = formatter.format(TimestampUtil.toDate(ts));
                Object var4_3 = null;
                if (formatter != null) {
                    gmtFormatterFactory.push(formatter, 1);
                }
                return string;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (formatter != null) {
                    gmtFormatterFactory.push(formatter, 1);
                }
                throw throwable;
            }
        }
        return null;
    }
}

