/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.cbs.util.time;

import com.sap.tc.cbs.util.time.ISimpleDateFormatFactory;
import java.text.SimpleDateFormat;
import java.util.EmptyStackException;
import java.util.Locale;
import java.util.Stack;
import java.util.TimeZone;

public abstract class SimpleDateFormatFactory
implements ISimpleDateFormatFactory {
    private static final String HTTP_DATE_FORMAT_PATTERN = "EEE, d MMM yyyy kk:mm:ss zzz";
    private static final String ISO_8601_DATE_FORMAT_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String HTML_RENDER_DATE_FORMAT_PATTERN = "dd.MM.yyyy HH:mm:ss z";
    private TimeZone timeZone = null;
    private Stack httpFormatPool = new Stack();
    private Stack isoFormatPool = new Stack();
    private Stack htmlFormatPool = new Stack();

    protected SimpleDateFormatFactory(String timeZone) {
        this.timeZone = TimeZone.getTimeZone(timeZone);
    }

    public int getPoolSize(int formatType) {
        int size = 0;
        switch (formatType) {
            case 1: {
                size = this.httpFormatPool.size();
                break;
            }
            case 2: {
                size = this.isoFormatPool.size();
                break;
            }
            case 3: {
                size = this.htmlFormatPool.size();
            }
        }
        return size;
    }

    public SimpleDateFormat pop(int formatType) {
        SimpleDateFormat format = null;
        switch (formatType) {
            case 1: {
                try {
                    format = (SimpleDateFormat)this.httpFormatPool.pop();
                }
                catch (EmptyStackException x) {
                    format = new SimpleDateFormat(HTTP_DATE_FORMAT_PATTERN, Locale.ENGLISH);
                }
                break;
            }
            case 2: {
                try {
                    format = (SimpleDateFormat)this.isoFormatPool.pop();
                }
                catch (EmptyStackException x) {
                    format = new SimpleDateFormat(ISO_8601_DATE_FORMAT_PATTERN, Locale.ENGLISH);
                }
                break;
            }
            case 3: {
                try {
                    format = (SimpleDateFormat)this.isoFormatPool.pop();
                }
                catch (EmptyStackException x) {
                    format = new SimpleDateFormat(HTML_RENDER_DATE_FORMAT_PATTERN, Locale.ENGLISH);
                }
                break;
            }
            default: {
                throw new RuntimeException("unknown simple date format");
            }
        }
        format.setTimeZone(this.timeZone);
        return format;
    }

    public void push(SimpleDateFormat format, int formatType) {
        switch (formatType) {
            case 1: {
                this.httpFormatPool.push(format);
                break;
            }
            case 2: {
                this.isoFormatPool.push(format);
                break;
            }
            case 3: {
                this.htmlFormatPool.push(format);
            }
        }
    }
}

